#############################################################################
# Author        : Ruediger Arnold
# Date          : 25.03.2015
# Description   : Save all tree data into the result directory
# Category      : Parser
#############################################################################
#               : 
#               : initial
#               :
##############################################################################

use strict;

###################################
# main routine
###################################
if ($#ARGV == 1) {
	&saveTree($ARGV[0],$ARGV[1]);
	exit;
	}	
else {
	print "*****************************\n";
	print "usage: $0 <data_file_position> <name_of_tree> \n";
	print "*****************************\n";
	exit;
}		

###################################
# subroutines
###################################
sub saveTree {


	my $fnDataFilePosition = shift;
	my $treeName = shift;
	my $fileName;
	my $inr;
	my $gen;
	my $line;

	my $sec;
	my $min;
	my $hour;
	my $mday;
	my $mon;
	my $year;
	my $wday;
	my $yday;
	my $isdst;

	($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime();
	$mon = $mon + 1;
	if ( $mon < 10 ) {
		$mon = "0".$mon;
	}
	if ( $mday < 10 ) {
		$mday = "0".$mday;
	}
	if ( $sec < 10 ) {
		$sec = "0".$sec;
	}
	if ( $min < 10 ) {
		$min = "0".$min;
	}
	if ( $hour < 10 ) {
		$hour = "0".$hour;
	}
	$year=$year+1900;
	$treeName=$treeName."_".$year.$mon.$mday."_".$hour.$min.$sec;

	if ( $^O eq "MSWin32") {  # Window Operating System
		print "Window Operating System\n";
		$fileName = ".\\Ergebnisse\\".$treeName;
		if (-e $fileName) {
			print "Baum ".$treeName." gibt es schon!\n";
			print "Keine Daten gesichert! Exit!\n";
			exit;
		} else {
			print "Neuer Baum wird angelegt.\n";
		}
		# Make Result Directory
		system("echo *");
		system("echo * Copy Tree Files into the Directory:");
		system("echo * \%\$resultDir\%\\".$treeName);
		system("echo *");
		system("mkdir \%\$resultDir\%\\".$treeName);
		# system("mkdir \%\$resultDir\%\\".$treeName."\\oo_draw");
		# system("mkdir \%\$resultDir\%\\".$treeName."\\oo_svm");
		system("mkdir \%\$resultDir\%\\".$treeName."\\BaumDefinitionen");
		# system("mkdir \%\$resultDir\%\\".$treeName."\\BaumDaten");
	
		# Copy General Files
		system("copy \%\$treeDefDir\%\\tree_form.txt \%\$resultDir\%\\".$treeName."\\BaumDefinitionen");
		system("copy \%\$treeDefDir\%\\tree_scaling.txt \%\$resultDir\%\\".$treeName."\\BaumDefinitionen");
		system("copy \%\$treeDefDir\%\\persons_in_tree.txt \%\$resultDir\%\\".$treeName."\\BaumDefinitionen");
		system("copy \%\$treeDefDir\%\\persons_in_tree_nr.txt \%\$resultDir\%\\".$treeName."\\BaumDefinitionen");
		
		system("copy \%\$treeDir\%\\tree.odg \%\$resultDir\%\\".$treeName."\\tree_".$treeName."\.odg");
		system("copy \%\$treeDir\%\\tree.pdf \%\$resultDir\%\\".$treeName."\\tree_".$treeName."\.pdf");
		#system("copy \%\$treeDataDir\%\\data_file_row_placement.csv \%\$resultDir\%\\".$treeName."\\BaumDaten");
	} else {
		print "Linux Cygwin or MAC Operating System\n";
		$fileName = ".\/Ergebnisse\/".$treeName;
		if (-e $fileName) {
			print "Baum ".$treeName." gibt es schon!\n";
			print "Keine Daten gesichert! Exit!\n";
			exit;
		} else {
			print "Neuer Baum wird angelegt.\n";
		}
		# Make Result Directory
		system("echo \"*\"");
		system("echo \"* Copy Tree Files into the Directory:\"");
		system("echo \"*\" \$resultDir\/".$treeName);
		system("echo \"*\"");	
		system("mkdir \$resultDir\/".$treeName);
		#system("mkdir \$resultDir\/".$treeName."\/oo_draw");
		#system("mkdir \$resultDir\/".$treeName."\/oo_svm");
		system("mkdir \$resultDir\/".$treeName."\/BaumDefinitionen");
		#system("mkdir \$resultDir\/".$treeName."\/BaumDaten");
	
		# Copy General Files
		system("cp \$treeDefDir\/tree_form.txt \$resultDir\/".$treeName."\/BaumDefinitionen");
		system("cp \$treeDefDir\/tree_scaling.txt \$resultDir\/".$treeName."\/BaumDefinitionen");
		system("cp \$treeDefDir\/persons_in_tree.txt \$resultDir\/".$treeName."\/BaumDefinitionen");
		system("cp \$treeDefDir\/persons_in_tree_nr.txt \$resultDir\/".$treeName."\/BaumDefinitionen");
		
		system("cp \$treeDir\/tree.odg \$resultDir\/".$treeName."\/tree_".$treeName."\.odg");
		#system("cp \$treeDataDir\/data_file_row_placement.csv \$resultDir\/".$treeName."\/BaumDaten");
	}



	# Copy Used ODG and SVM files
	#open(IN, "<$fnDataFilePosition") || die "Can't open file $fnDataFilePosition ($!)\n";
	#while(<IN>) {			
	#	$line= $_;
	#	if ( $line =~ m/INR (\d*) GEN (.*?) DIST (\d*) UD (\d*) DU (\d*) SS (\d*) SIDE (-*\d*) PLC (\d*) A2P (\d*)/ ) {
	#		$inr = $1;
	#		$gen = $2;
	#	} else {
	#		print $line."\n";
	#		print "**** ERROR Wrong format in file ".$fnDataFilePosition."\n";
	#		exit;
	#	}
	#	if ($gen eq "not_in_tree") {
	#		print "  **** Person ".$inr." is not in the tree, no data copied.\n";
	#	} else {
	#		print "  **** Copy Files for Person ".$inr.".\n";
	#
	#        if ( $^O eq "MSWin32") {  # Window Operating System
       	#		print "Window Operating System 2\n";
	#		system("copy \%\$odgDir\%\\i".$inr.".odg \%\$resultDir\%\\".$treeName."\\oo_draw");
	#		system("copy \%\$svmDir\%\\i".$inr.".odg.svm \%\$resultDir\%\\".$treeName."\\oo_svm");
	#	} else {
	#		print "Linux Cygwin or MAC Operating System 2\n";
	#		system("cp \$odgDir\/i".$inr.".odg \$resultDir\/".$treeName."\/oo_draw");
	#		system("cp \$svmDir\/i".$inr.".odg.svm \$resultDir\/".$treeName."\/oo_svm");
	#	}
	#
	#	}
	#}
	#close(IN);

}
