##############################################################################
# Author        : Ruediger Arnold
# Date          : 05.12.2011
# Description   : Replaces the text getft., gestrbn., gebrn. and gehrtt. begrbn.
# Category      : Parser
#############################################################################
#               : 
#               : initial
#               :
##############################################################################

use strict;


###################################
# main routine
###################################

my $symBirth;
my $symBaptism;
my $symMarriage;
my $symMarriageChurch;
my $symPartner;
my $symDivorce;
my $symDeath;
my $symBurial;
my $symFeminin;
my $symMaskulin;

if ($#ARGV == 1) {
	&readTreeSymbols(@ARGV[1]);
	&generateContent(@ARGV[0]);
	exit;
	}	
else {
	print "*****************************\n";
	print "usage: $0 <person_data_file> <tree_symbol_file> \n";
	print "*****************************\n";
	exit;
}		

###################################
# subroutines
###################################
sub readTreeSymbols {
	my $filename = shift;
	my $line;

	## open symbol definition file
	#print "***** Open Person Data File \n";
	open(IN, "<$filename") || die "Can't open file $filename ($!)\n";

	$line = <IN>;
	if ( $line=~ m/(.*) symBirth (.*)/ ) {
		$symBirth = $1;
	} else {
		print "**** ERROR: no birth symbol in file ".$filename."\n";
		exit;
	}

	$line = <IN>;
	if ( $line=~ m/(.*) symBaptism (.*)/ ) {
		$symBaptism = $1;
	} else {
		print "**** ERROR: no baptism symbol in file ".$filename."\n";
		exit;
	}

	$line = <IN>;
	if ( $line=~ m/(.*) symMarriage (.*)/ ) {
		$symMarriage = $1;
	} else {
		print "**** ERROR: no marriage symbol in file ".$filename."\n";
		exit;
	}

	$line = <IN>;
	if ( $line=~ m/(.*) symMarriageChurch (.*)/ ) {
		$symMarriageChurch = $1;
	} else {
		print "**** ERROR: no marriage in church symbol in file ".$filename."\n";
		exit;
	}

	$line = <IN>;
	if ( $line=~ m/(.*) symPartner (.*)/ ) {
		$symPartner = $1;
	} else {
		print "**** ERROR: no partnership symbol in file ".$filename."\n";
		exit;
	}

	$line = <IN>;
	if ( $line=~ m/(.*) symDivorce (.*)/ ) {
		$symDivorce = $1;
	} else {
		print "**** ERROR: no divorce symbol in file ".$filename."\n";
		exit;
	}

	$line = <IN>;
	if ( $line=~ m/(.*) symDeath (.*)/ ) {
		$symDeath = $1;
	} else {
		print "**** ERROR: no death symbol in file ".$filename."\n";
		exit;
	}

	$line = <IN>;
	if ( $line=~ m/(.*) symBurial (.*)/ ) {
		$symBurial = $1;
	} else {
		print "**** ERROR: no burial symbol in file ".$filename."\n";
		exit;
	}

	$line = <IN>;
	if ( $line=~ m/(.*) symMas (.*)/ ) {
		$symMaskulin = $1;
	} else {
		print "**** ERROR: no maskulin symbol in file ".$filename."\n";
		exit;
	}

	$line = <IN>;
	if ( $line=~ m/(.*) symFem (.*)/ ) {
		$symFeminin = $1;
	} else {
		print "**** ERROR: no feminin symbol in file ".$filename."\n";
		exit;
	}

	close(IN);

}

sub generateContent {
	my $filename = shift;
	my $line;
	my $word1;
	my $word2;
	my $word3;

	## open person data file
	#print "***** Open Person Data File \n";
	open(IN, "<$filename") || die "Can't open file $filename ($!)\n";
	while(<IN>) {			

		$line= $_;

		# replace reserved signs for XML files as <, > and $
		$line =~ s/&/&amp;/g;
		$line =~ s/</&lt;/g;
		$line =~ s/>/&gt;/g;
		#$line =~ s/"/&quote;/g; # funktioniert nicht
		#$line =~ s/'/&apos;/g; # funktioniert nicht

		# looking for the symbol locations

		if ( $line=~ m/(gebrn\. )(.*)/ ) {
			# Birthday found 
			$word1 = $1; # 
			$word2 = $2; #
			print $symBirth." ".$word2."\n";
		} else {
		if ( $line=~ m/(gestrbn\. )(.*)/ ) {
			# Death found 
			$word1 = $1; #
			$word2 = $2; #
			print $symDeath." ".$word2."\n";
		} else {
		if ( $line=~ m/(verhrtt\. )(.*)/ ) {
			# Wedding found 
			$word1 = $1; #
			$word2 = $2; #
			print $symMarriage." ".$word2."\n";
		} else {
		if ( $line=~ m/(verhrttkrch\. )(.*)/ ) {
			# Wedding in Church found 
			$word1 = $1; #
			$word2 = $2; #
			print $symMarriageChurch." ".$word2."\n";
		} else {
		if ( $line=~ m/(geschdn\. )(.*)/ ) {
			# Divorce found
			$word1 = $1; #
			$word2 = $2; #
			print $symDivorce." ".$word2."\n";
		} else {
		if ( $line=~ m/(o-o )(.*)/ ) { # partnership found
			$word1 = $1; # 
			$word2 = $2; # 
			print $symPartner." ".$word2."\n";
		} else {
		if ( $line=~ m/(getft\. )(.*)/ ) {
			# Baptism found 
			$word1 = $1; # 
			$word2 = $2; # 
			print $symBaptism." ".$word2."\n";
		} else {
		if ( $line=~ m/(begrbn\. )(.*)/ ) {
			# Burial found 
			$word1 = $1; # 
			$word2 = $2; # 
			print $symBurial." ".$word2."\n";
		} else {
		if ( $line=~ m/(.*)(maskln\.)(.*)/ ) {
			# Maskulin found 
			$word1 = $1; #
			$word2 = $2; # 
			$word3 = $3; #
			print $word1.$symMaskulin." ".$word3."\n";
		} else {
		if ( $line=~ m/(.*)(femnn\.)(.*)/ ) {
			# Feminine found 
			$word1 = $1; #
			$word2 = $2; # 
			$word3 = $3; # 
			print $word1.$symFeminin." ".$word3."\n";
		} else {
			print $line;
		}}}}}}}}}}
	}
	close(IN);
}
