##############################################################################
# Author        : Ruediger Arnold
# Date          : 15.10.2011
# Revision      : 15.10.2011 Rufname hat eigenen Stil (z.B. unterstrichen)
# Description   : Generate the odg files of the persons data file
# Category      : Parser
#############################################################################
#               : 
#               : initial
#               :
##############################################################################

#use strict;

###################################
# main routine
###################################
if ($#ARGV == 2) {
	&generateContent(@ARGV[0],@ARGV[1],@ARGV[2]);
	exit;
	}	
else {
	print "**************************************************************************\n";
	print "usage: $0 <person_data_new> <person_data_actual> <person_data_actual_temp>\n";
	print "**************************************************************************\n";
	exit;
}		

###################################
# subroutines
###################################
sub generateContent {
	my $filenamePersonDataFileNew = shift;
	my $filenamePersonDataFileActual = shift;
	my $filenamePersonDataFileActualTemp = shift;
	my $filenameXml = "content_example.xml";
	my $filenameExport = "content.xml";
	my $line1;
	my $line2;
	my $line_nolinefeedA;
	my $line_nolinefeedB;
	my $line_nolinefeedC;
	my $line_nolinefeedD;
	my $lineHeadXml;
	my $word1;
	my $word21A;
	my $word21B;
	my $word21C;
	my $word21D;
	my $word31A;
	my $word31B;
	my $word31C;
	my $word31D;
	my $word41A;
	my $word41B;
	my $word41C;
	my $word41D;
	my $word51A;
	my $word51B;
	my $word51C;
	my $word51D;
	my $word61A;
	my $word61B;
	my $word61C;
	my $word61D;
	my $word22;
	my $word32;
	my $word42;
	my $word52;
	my $word62;
	my $word7;
	my $firstLine;

	&generateFramePrepare;
	
	## open content XML file
	print "***** Analyse and Extract Example content.xml File \n";
	open(IN1, "<$filenameXml") || die "Can't open file $filenameXml ($!)\n";

	# Read Header Line
	$line1 = <IN1>;
	$lineHeadXml = $line1;
	print "*** Header \n";
	print $line1."\n";

	$line1 = <IN1>;
	print "*** Body \n";
	print $line1."\n";
	if ( $line1=~ m/(.*)(<text:p.*?>)(<text:span.*?>)(.*)(<\/text:span>)(<\/text:p>)(<text:p.*?>)(<text:span.*?>)(.*)(<\/text:span>)(<\/text:p>)(<text:p.*?>)(<text:span.*?>)(.*)(<\/text:span>)(<\/text:p>)(<text:p.*?>)(<text:span.*?>)(.*)(<\/text:span>)(<\/text:p>)(<text:p.*?>)(<text:span.*?>)(.*)(<\/text:span>)(<\/text:p>)(.*)/ ) {
		# Body Line Analysis
		print "***** Body Line Analysis \n";
		$word1 = $1; 	# part until <text:p>
		print "Word1: ".$word1."\n";

		# first line with names analysis	

		$word21A = $2; 	# part <text:p.*?>
		print "Word21A: ".$word21A."\n";
		$word31A = $3; 	# part <text:span.*?>
		print "Word31A: ".$word31A."\n";
		$word41A = $4; 			# part Text "preruf"
		print "Word41A: ".$word41A."\n";
		$word51A = $5; 	# part </text:span>
		print "Word51A: ".$word51A."\n";
		$word61A = $6; # part </text:p>
		print "Word61A: ".$word61A."\n";

		$word21B = $7; 	# part <text:p.*?>
		print "Word21B: ".$word21B."\n";
		$word31B = $8; 	# part <text:span.*?>
		print "Word31B: ".$word31B."\n";
		$word41B = $9; 			# part Text "rufname"
		print "Word41B: ".$word41B."\n";
		$word51B = $10; # part </text:span>
		print "Word51B: ".$word51B."\n";
		$word61B  = $11; # part </text:p>
		print "Word61B: ".$word61B."\n";

		$word21C = $12; # part <text:p.*?>
		print "Word21C: ".$word21C."\n";
		$word31C = $13; # part <text:span.*?>
		print "Word31C: ".$word31C."\n";
		$word41C = $14; 		# part Text "postruf"
		print "Word41C: ".$word41C."\n";
		$word51C = $15; # part </text:span>
		print "Word51C: ".$word51C."\n";
		$word61C = $16; # part </text:p>
		print "Word61C: ".$word61C."\n";

		$word21D = $17; # part <text:p.*?>
		print "Word21D: ".$word21D."\n";
		$word31D = $18; # part <text:span.*?>
		print "Word31D: ".$word31D."\n";
		$word41D = $19; 		# part Text "name"
		print "Word41D: ".$word41D."\n";
		$word51D = $20; # part </text:span>
		print "Word51D: ".$word51D."\n";
		$word61D = $21; # part </text:p>
		print "Word61D: ".$word61D."\n";

		# stil line with other informations
		$word22 = $22; 	# part <text:p.*?>
		print "Word22: ".$word22."\n";
		$word32 = $23; 	# part <text:span.*?>
		print "Word32: ".$word32."\n";
		$word42 = $24; 			# part Text "style second line"
		print "Word42: ".$word42."\n";
		$word52 = $25; 	# part </text:span>
		print "Word52: ".$word52."\n";
		$word62 = $26; 	# part </text:p>
		print "Word62: ".$word62."\n";

		$word7 = $27; 	# part 		# last part of the XML file
		print "Word4: ".$word4."\n";
	} else {
		print "****ERROR Wrong format in ".$filenameXml."\n";
		exit;
	}

	close(IN1);
	print "***** Content Analysis End\n";

	## open person data file
	open(IN2, "<$filenamePersonDataFileNew") || die "Can't open file $filenamePersonDataFileNew ($!)\n";
	open(IN3, "<$filenamePersonDataFileActual") || die "Can't open file $filenamePersonDataFileActual ($!)\n";
	while(<IN2>) {			
		$line2 = $_;
		#print "line2:\n";
		#print $line2;
		#print "\n";
		if ($line2 =~ m/SOI/) {
			# Finding start of index (SOI)
			$line2 = <IN2>;
			$line2 =~ m/(\S*)/;
			$indexNr = $1;
			$firstLine = 1;
			print "***** Finding start of person Nr.".$indexNr." (SOI)\n";
			open(OUT1, ">$filenameExport") || die "Can't open file $filenameExport ($!)\n";
			print OUT1 $lineHeadXml;
			print OUT1 $word1;
		} else {
			if ($line2 =~ m/EOI/) {
				# Finding end of index (EOI)
				print "***** Finding end of person Nr.".$indexNr." (EOI)\n";
				print OUT1 $word7;
				close(OUT1);
				&zipOdg($indexNr);
			} else {  
				if ( $line2 =~ m/(.*)\n/ ) {
					#print "***** Finding core of person\n";
					# Finding the text parts for each person (index), without carriage return
					$line_nolinefeedA = $1;              # Preruf
					if ($firstLine == 1) { # print the name
						# print $line_nolinefeedA." Preruf\n";
						$line2 = <IN2>; 
						$line2 =~ m/(.*)/;
						$line_nolinefeedB = $1;      # Rufname
						# print $line_nolinefeedB." Rufname\n";
						$line2 = <IN2>; 
						$line2 =~ m/(.*)/;
						$line_nolinefeedC = $1;      # Postruf
						# print $line_nolinefeedC." Postruf\n";
						$line2 = <IN2>; 
						$line2 =~ m/(.*)/;
						$line_nolinefeedD = " ".$1;  # Nachname
						# print $line_nolinefeedD." Nachname\n";
						print OUT1 $word21A.$word31A.$line_nolinefeedA.$word51A.$word31B.$line_nolinefeedB.$word51B.$word31C.$line_nolinefeedC.$word51C.$word31D.$line_nolinefeedD.$word51D.$word61A; 
						$firstLine = 0;
					} else {
						print OUT1 $word22,$word32,$line_nolinefeedA,$word52,$word62;
					}
				}
			}
		}
	}	
	close(IN2);

	&generateFrameCleanUp;

}

sub generateFramePrepare {
	system("\%\$scriptDir\%generate_frames_prepare.bat");
}

sub zipOdg {
	# Generate Open Office Drawing File
	my $indexNr = shift;

	print "***** Copy File content.xml into Working Directory \n";
	system("copy content.xml \%\$workOdgDir\%");

	print "*************************************************\n";
	print "***** ".$indexNr." Zip Office File for Index ".$indexNr."\n";
	print "*************************************************\n";
	system("\%\$zip\% \%\$workOdgDir\%\\i".$indexNr.".zip \%\$workOdgDir\%\\*");
		# name of archive must be *.zip, otherwise it will be a *.7z archive, which
		# cannot be read by Open Office

	system("move \%\$workOdgDir\%\\i".$indexNr.".zip \%\$odgDir\%\\i".$indexNr.".odg");
		# Copy Archive as Open Office Drawing

}

sub generateFrameCleanUp {
	system("\%\$scriptDir\%\generate_frames_clean_up.bat");
}	

