##############################################################################
# Author        : Ruediger Arnold
# Date          : 15.10.2011
# Revision      : 15.10.2011 Rufname hat eigenen Stil (z.B. unterstrichen)
# Revision      : 15.05.2012 Fuer Windows und Linux
# Revision      : 31.08.2012 Extraction out of Tree Example, not any longer frame example
# Description   : Generate the odg files of the persons data file
# Category      : Parser
#############################################################################
#               : 
#               : initial
#               :
##############################################################################

#use strict;

###################################
# main routine
###################################
if ($#ARGV == 1) {
	&generateContent(@ARGV[0], @ARGV[1]);
	exit;
	}	
else {
	print "*****************************\n";
	print "usage: $0 <person_data_file> <person_data_file_for_tree_gen> \n";
	print "*****************************\n";
	print @ARGV[0]."\n";
	print @ARGV[1]."\n";
	exit;
}		

###################################
# subroutines
###################################
sub generateContent {
	my $filenamePersonDataFile = shift;
	my $filenamePersonDataFileOld = shift;
	my $filenameTxt;
	my $filenameXml = "content_example.xml";
	my $filenameExport = "content.xml";
	my $line1;
	my $line2;
	my @lineArray;
	my @personDataOld;
	my $i;
	my $j;
	my $imax;
	my @imaxOld;
	my $indexNrMaxOld;
	my $identical;
	my $lineHeadXml;
	my $word1;
	my $word21A;
	my $word21B;
	my $word21C;
	my $word21D;
	my $word21E;
	my $word31A;
	my $word31B;
	my $word31C;
	my $word31D;
	my $word31E;
	my $word41A;
	my $word41B;
	my $word41C;
	my $word41D;
	my $word41E;
	my $word51A;
	my $word51B;
	my $word51C;
	my $word51D;
	my $word51E;
	my $word61A;
	my $word61B;
	my $word61C;
	my $word61D;
	my $word61E;
	my $word22;
	my $word32;
	my $word42;
	my $word52;
	my $word62;
	my $word7;
	my $style;

	&generateFramePrepare;
	
	## open content XML file
	print "***** Analyse and Extract Example content.xml File \n";
	open(IN1, "<$filenameXml") || die "Can't open file $filenameXml ($!)\n";

	# Read Header Line
	$line1 = <IN1>;
	$lineHeadXml = $line1;
	print "*** Header \n";
	print $line1."\n";

	$line1 = <IN1>;
	print "*** Body \n";
	print $line1."\n";
	if ( $line1=~ m/(.*<draw:page.*?>).*(<draw:custom-shape.*?svg:height=\").*?(cm\" svg.*?<text:p.*?>)(<text:span.*?>)(Stil Preruf)(<\/text:span>)(<\/text:p>)(<text:p.*?>)(<text:span.*?>)(Stil Ruf)(<\/text:span>)(<\/text:p>)(<text:p.*?>)(<text:span.*?>)(Stil Postruf)(<\/text:span>)(<\/text:p>)(<text:p.*?>)(<text:span.*?>)(Stil Nachname)(<\/text:span>)(<\/text:p>)(<text:p.*?>)(<text:span.*?>)(Stil Indexnummer)(<\/text:span>)(<\/text:p>)(<text:p.*?>)(<text:span.*?>)(Stil .*? Information)(<\/text:span>)<\/text:p>(.*?<\/draw:custom-shape>).*(<\/draw:page>.*)/ ) {
                #                1                           2                                      3               4              5           6             7            8             9           10            11          12            13          14            15              16             17           18           19             20               21           22           23           24                  25              26         27            28           29                  30                31                             32                      33                                                                                    
		# Body Line Analysis
		print "***** Body Line Analysis \n";
		$word1 = $1; 	# part until <draw:page...>
		print "Word1: ".$word1."\n";

		# first line with names analysis	

		$word21A = $2."0.1".$3;  # part from custom-shape to <text:p.*?> with 0.1 cm height of the frame as default
		print "Word21A: ".$word21A."\n";
		$word31A = $4; 	# part <text:span.*?>
		print "Word31A: ".$word31A."\n";
		$word41A = $5;   		# part Text "preruf"
		print "Word41A: ".$word41A."\n";
		$word51A = $6; 	# part </text:span>
		print "Word51A: ".$word51A."\n";
		$word61A = $7; # part </text:p>
		print "Word61A: ".$word61A."\n";

		$word21B = $8; 	# part <text:p.*?>
		print "Word21B: ".$word21B."\n";
		$word31B = $9; 	# part <text:span.*?>
		print "Word31B: ".$word31B."\n";
		$word41B = $10; 			# part Text "rufname"
		print "Word41B: ".$word41B."\n";
		$word51B = $11; # part </text:span>
		print "Word51B: ".$word51B."\n";
		$word61B = $12; # part </text:p>
		print "Word61B: ".$word61B."\n";

		$word21C = $13; # part <text:p.*?>
		print "Word21C: ".$word21C."\n";
		$word31C = $14; # part <text:span.*?>
		print "Word31C: ".$word31C."\n";
		$word41C = $15; 		# part Text "postruf"
		print "Word41C: ".$word41C."\n";
		$word51C = $16; # part </text:span>
		print "Word51C: ".$word51C."\n";
		$word61C = $17; # part </text:p>
		print "Word61C: ".$word61C."\n";

		$word21D = $18; # part <text:p.*?>
		print "Word21D: ".$word21D."\n";
		$word31D = $19; # part <text:span.*?>
		print "Word31D: ".$word31D."\n";
		$word41D = $20; 		# part Text "name"
		print "Word41D: ".$word41D."\n";
		$word51D = $21; # part </text:span>
		print "Word51D: ".$word51D."\n";
		$word61D = $22; # part </text:p>
		print "Word61D: ".$word61D."\n";

		$word21E = $23; # part <text:p.*?>
		print "Word21E: ".$word21E."\n";
		$word31E = $24; # part <text:span.*?>
		print "Word31E: ".$word31E."\n";
		$word41E = $25; 		# part Text "Index Nummer"
		print "Word41E: ".$word41E."\n";
		$word51E = $26; # part </text:span>
		print "Word51E: ".$word51E."\n";
		$word61E = $27; # part </text:p>
		print "Word61E: ".$word61E."\n";

		# stil line with other informations
		$word22 = $28; 	# part <text:p.*?>
		print "Word22: ".$word22."\n";
		$word32 = $29; 	# part <text:span.*?>
		print "Word32: ".$word32."\n";
		$word42 = $30; 			# part Text "Restliche Informationen"
		print "Word42: ".$word42."\n";
		$word52 = $31; 	# part </text:span>
		print "Word52: ".$word52."\n";
		$word62 = $32;  # part from </text:p> to end of custom-shape
		print "Word62: ".$word62."\n";

		$word7 = $33; 	# part 		# last part of the XML file
		print "Word7: ".$word7."\n";

	} else {
		print "****ERROR Wrong format in ".$filenameXml."\n";
		close(IN1);
		exit;
	}

	# Extraction of the Style of the Frame
	if ( $word21A =~ m/<draw:custom-shape draw:style-name=\"(.*?)\" .*?>/ ) {
		$style = $1;  # contains the grafik style e.g. "gr5"
		print "Style: ".$style."\n";
	} else {
		print "****ERROR Wrong format in ".$filenameXml." at Style Extraction\n";
		exit;
	}
	if ( $word1 =~ m/(.*?style:name=\")($style)(\" .*?fo:min-height=\")(.*?)(cm\" .*)/  ) {    # part until <draw:page...>
	#			1              2              3              4      5
		print "Min Height in Style Definition: ".$4."\n";
		$word1 = $1.$2.$3."0.2".$5;  # not set minimum height to zero
	} else {
		print "****ERROR Wrong format in ".$filenameXml." at Min. Style Height Reduction\n";
		exit;
	}
	close(IN1);


	print "***** Content Analysis End\n";

	# Read In Old Person Data

	## open person data file and compare each person with the available data
	print "**** Reading in Old (Actual) Person Data File. \n";
	$indexNrMaxOld = 0;
	open(IN2, "<$filenamePersonDataFileOld") || print "*** Can't open file $filenamePersonDataFileOld ($!)\n";
	while(<IN2>) {			
		$line2 = $_;
		if ($line2 =~ m/SOI/) {
			# Finding start of index (SOI)
			$line2 = <IN2>;
			$line2 =~ m/(\S*)/;
			$indexNr = $1;
			print "***** Finding in old data start of person Nr.".$indexNr." (SOI)\n";

			# Reading the Name, which always will be there
			$line2 = <IN2>; 
			$line2 =~ m/(.*)\n/;
			$personDataOld[$indexNr][1] = $1;
			# print $personDataOld[$indexNr][1]." Preruf\n";
			$line2 = <IN2>; 
			$line2 =~ m/(.*)\n/;
			$personDataOld[$indexNr][2] = $1;
			# print $personDataOld[$indexNr][2]." Ruf\n";
			$line2 = <IN2>; 
			$line2 =~ m/(.*)\n/;
			$personDataOld[$indexNr][3] = $1;
			# print $personDataOld[$indexNr][3]." Postruf\n";
			$line2 = <IN2>; 
			$line2 =~ m/(.*)\n/;
			$personDataOld[$indexNr][4] = $1;
			# print $personDataOld[$indexNr][4]." Nachname\n";

			# Reading further information of the person
			$line2 = <IN2>; 
			$line2 =~ m/(.*)\n/;
			$line2 = $1;  # without newline
			$i = 5;
			while ($line2 ne "EOI") { # not yet reached End Of Index
				$personDataOld[$indexNr][$i] = $line2;
				# print $personDataOld[$indexNr][$i]." Eintrag Nr.".$i."\n";
				$i = $i + 1;
				#if ( $i > 11 ) { die; };
				$line2 = <IN2>; 
				$line2 =~ m/(.*)\n/;
				$line2 = $1;  # without newline
			}
			$imaxOld[$indexNr] = $i - 1;		# Anzahl der Eintrge einer Person
			if ( $indexNrMaxOld < $indexNr ) {	# Nummer mit dem hchsten Index
				$indexNrMaxOld = $indexNr;
			}

			#print "***** Finding end of old person Nr.".$indexNr." (EOI)\n";
		}
	}
	close(IN2);

	#  Read In New Person Data

	## open person data file and compare each person with the available data
	print "**** Parsing through the new person data. \n";
	open(IN2, "<$filenamePersonDataFile") || die "Can't open file $filenamePersonDataFile ($!)\n";
	while(<IN2>) {			
		$line2 = $_;
		if ($line2 =~ m/SOI/) {
			# Finding start of index (SOI)
			$line2 = <IN2>;
			$line2 =~ m/(\S*)/;
			$indexNr = $1;
			print "***** Finding in new data start of person Nr.".$indexNr." (SOI)\n";

			# Reading the Name, which always will be there
			$line2 = <IN2>; 
			$line2 =~ m/(.*)\n/;
			$lineArray[1] = $1;      # Preruf
			# print $lineArray[1]." Preruf\n";
			$line2 = <IN2>; 
			$line2 =~ m/(.*)\n/;
			$lineArray[2] = $1;      # Rufname
			# print $lineArray[2]." Rufname\n";
			$line2 = <IN2>; 
			$line2 =~ m/(.*)\n/;
			$lineArray[3] = $1;      # Postruf
			# print $lineArray[3]." Postruf\n";
			$line2 = <IN2>; 
			$line2 =~ m/(.*)\n/;
			$lineArray[4] = $1;  # Nachname
			# print $lineArray[4]." Nachname\n";

			# Reading further information of the person
			$line2 = <IN2>; 
			$line2 =~ m/(.*)\n/;
			$line2 = $1;  # without newline
			$i = 5;
			while ($line2 ne "EOI") { # not yet reached End Of Index
				$lineArray[$i] = $line2; 
				$i = $i + 1;
				#print $i." ".$line2."\n";
				#if ( $i > 11 ) { die; };
				$line2 = <IN2>; 
				$line2 =~ m/(.*)\n/;
				$line2 = $1;  # without newline
			}
			$imax = $i - 1;
			#print "***** Finding end of person Nr.".$indexNr." (EOI)\n";

			if ( defined $personDataOld[$indexNr][1] ) { # old individual person data exists
				$identical = 1;
			} else {
				$identical = 0;
			}
			
			# print $identical."\n";

			if ( $identical == 1 ) { # old data exists, start comparing data
				if ( $imax != $imaxOld[$indexNr] ) { # different number of lines
					$identical = 0;
				} else {	# same number of lines, check content
					for $i (1..$imaxOld[$indexNr]) {
						if ( $lineArray[$i] ne $personDataOld[$indexNr][$i] ) {  # the informations in two corresponding lines are not identical
							$identical = 0;
						}
					}
				}
			}
			#print $identical."\n";
			
			if ( $identical == 0 ) { # not identical -> generate new frame and new txt-file
				print "Index-Nr.: ".$indexNr.": Old Data is not identical to new data.\n";
		
				# overwrite old person data
				
				#open(OUT1, ">$filenameTxt") || die "Can't open file $filenameTxt ($!)\n";
				#for $i (1 .. $imax) {
				#	print OUT1 $lineArray[$i]."\n";
				#}
				#close(OUT1);
				for $i (1 .. $imax) {
					$personDataOld[$indexNr][$i]=$lineArray[$i]; # Kopieren Zeile fuer Zeile
				}
				$imaxOld[$indexNr]=$imax; # Setzen der Neuen Anzahl fr Index-Nummern
				if ( $indexNrMaxOld < $indexNr ) {	# Es gibt eine neue Index-Nummer mit dem hchsten Index
					$indexNrMaxOld = $indexNr;
				}

				# generate new open office frame

				open(OUT2, ">$filenameExport") || die "Can't open file $filenameExport ($!)\n";
				print OUT2 $lineHeadXml;
				print OUT2 $word1;
				# Alle Vornamen
				print OUT2 $word21A.$word31A.$lineArray[1].$word51A.$word31B.$lineArray[2].$word51B.$word31C.$lineArray[3].$word51C; 
				# Nachname und ggf. Index-Nummer
				if ( $lineArray[4] =~ m/(.*?)(#.*)/ ) {	# Einfuegen eines zusaetzlichen Leerzeichens, wenn Index-Nr. hinter Nachname
					print OUT2 $word31D." ".$1." "."<text:s/>".$word51D.$word31E.$2.$word51E.$word61A; 
				} else {
					print OUT2 $word31D." ".$lineArray[4].$word51D.$word61A; 
				}
				for $i (5 .. $imax) {
					if ( $lineArray[$i] =~ m/(#[0-9]+)/ ) {	# Es gibt eine Index-Nummer
						#print "Found Index-Number: ".$1."\n"; 
						print OUT2 $word22,$word31E,$lineArray[$i],$word51E,$word61A;
					} else {
						#print $lineArray[5]."  No Index-Number\n"; 
						print OUT2 $word22,$word32,$lineArray[$i],$word52,$word61A;
					}
				}
				print OUT2 $word62;
				print OUT2 $word7;
				close(OUT2);
				#print "before ZIP \n";
				#exit;
				&zipOdg($indexNr);
			}
		}
	}	
	close(IN2);

	# generated updated Old Person Data File

	open(OUT2, ">$filenamePersonDataFileOld") || die "Can't open file $filenamePersonDataFileOld ($!)\n";
	for $i (1 .. $indexNrMaxOld) {
		if (defined $personDataOld[$i][1]) {
			print OUT2 "SOI\n";
			print OUT2 $i."\n";
			for $j (1 .. $imaxOld[$i]) {
				print OUT2 $personDataOld[$i][$j]."\n";
			}
			print OUT2 "EOI\n";
		}
	}
	close(OUT2);
	
	print "**** End Looking for changed Persons \n";


	&generateFrameCleanUp;

}

sub generateFramePrepare {
	if ( $^O eq "MSWin32") {  # Window Operating System
		print "Window Operating System 1\n";
		system("\%\$scriptDir\%generate_frames_prepare.bat");
	} else {
		print "Linux Cygwin or MAC Operating System 1\n";
		system("\$scriptDir/generate_frames_prepare.sh");
	}
}

sub zipOdg {
	# Generate Open Office Drawing File
	my $indexNr = shift;

	print "***** Copy File content.xml into Working Directory \n";
	if ( $^O eq "MSWin32") {  # Window Operating System
		print "Window Operating System 2\n";
		system("copy content.xml \%\$workOdgDir\%");
	} else {
		print "Linux Cygwin or MAC Operating System 2\n";
		system("cp content.xml \$workOdgDir");
	}

	print "*************************************************\n";
	print "***** ".$indexNr." Zip Office File for Index ".$indexNr."\n";
	print "*************************************************\n";
	if ( $^O eq "MSWin32") {  # Window Operating System
		print "Window Operating System 3\n";
		system("\%\$zip\% \%\$workOdgDir\%\\i".$indexNr.".zip \%\$workOdgDir\%\\*");
			# name of archive must be *.zip, otherwise it will be a *.7z archive, which
			# cannot be read by Open Office
	} else {
		print "Linux Cygwin or MAC Operating System 3\n";
		system("cd \$workOdgDir; \$zip i".$indexNr.".zip *");
	}

	if ( $^O eq "MSWin32") {  # Window Operating System
		print "Window Operating System 4\n";
		system("move \%\$workOdgDir\%\\i".$indexNr.".zip \%\$odgDir\%\\i".$indexNr.".odg");
			# Copy Archive as Open Office Drawing
	} else {
		print "Linux Cygwin or MAC Operating System 4\n";
		system("mv \$workOdgDir\/i".$indexNr.".zip \$odgDir\/i".$indexNr.".odg");
	}

}

sub generateFrameCleanUp {
	if ( $^O eq "MSWin32") {  # Window Operating System
		print "Window Operating System 5\n";
		system("\%\$scriptDir\%\generate_frames_clean_up.bat");
	} else {
		print "Linux Cygwin or MAC Operating System 5\n";
		system("\$scriptDir\/generate_frames_clean_up.sh");
	}
}	

