##############################################################################
# Author        : Ruediger Arnold
# Date          : 07.01.2013
# Description   : Find for each person its generation level for placing the names in the tree
# Category      : Parser
#############################################################################
#               : 
#               : initial
#               :
##############################################################################

use strict;
use warnings;

# Global Variables

my $noi=200; # maximum number of indexes
my $nob=20; # maximum number branches (persons, indexes) connected to each index
my $start_hus_inr = 1; # default start index number for recursion
my $start_wif_inr = 0; # default start index number for recursion
#my $start_gnr=0; # defines the generation number of the start index person
my $placement = 0;  # counter for the placed persons in the tree.
my $start_dist = 0;
my $start_ud = 0;
my $start_du = 0;
my $start_ss = 0;
my $start_dir = 0; # direction into the person: -1: down (toward younger),0: start 1: up (toward elder)
my %stopHash; # contains the information, if a person is set on "stop" or "stopAndExclude"
my %looseConHash;  # contains the informations about loose connection to cut loop on dedicated locations

my @gen_inc;     # generation increment data array
my @inr_entered; # array, which shows, that the an index is already in the recursion (=0 not in, =1 in)
my @inr_gen;     # array which contains the generation for each index
my @inr_placement; # array with placement number for each person
my @inr_a2p;     # array with shows, if the person is attached to his partner.
my @inr_dist;    # sum of all up and down steps to reach the end person from the start person
my @inr_ud;      # number of up down changes to reach the end person from the start person

my $MEHR_ALS_LIMIT_PERSONEN_IM_BAUM;
my $mehr_als_limit_message_sent = 0;
my $checkLimitPersonImBaum = 100;
		
my @inr_du;	# number of down up changes to reach the end person from the start person
		# if inr_du >=1 then it is not a "blood relative"
my @inr_ss;	# number of side steps to reach the end person from the start person
		# if inr_ss >=1 then it is not a "blood relative", just married
my @inr_side;	# -1: person is on the left side of the tree (husband family), 1: person is on the right side of the three (wife family)

my $notReadyAllInr;     # shows if still some persons are not proceed due to limit of branch depth
my $maxDuSteps;		# indicates the maximum down-up-steps during tree recursion
my $maxUdSteps;		# indicates the minimum up-down-steps during tree recursion
my $firstEnterDir;      # follow first  the branch in this direction (1:up; 0: to side, -1:down)
my $secondEnterDir;     # follow second the branch in this direction (1:up; 0: to side, -1:down)
my $thirdEnterDir;      # follow third  the branch in this direction (1:up; 0: to side, -1:down)

my $findPathToPersonInr;    # determine path to this person.
my $findPathToPersonActive; # indicates that the person to find, was found in the recursion
my $findPathReturnTokenInr;      # indicates, on which person (inr) the return token is standing
my $findPathCnt;            # counter value for number of persons in the path
my @findPathInr;            # Array which contains the path of the Index-Numbers
my %findPathInrHash;        # Hash mit den Index-Nummern

###################################
# main routine
###################################
if ($#ARGV == 6) {

	&initializeData($ARGV[0],$ARGV[1],$ARGV[2],$ARGV[5]);
	&generatePosition($ARGV[3],$ARGV[4]);
	&writeFindPath($ARGV[6],$ARGV[2]);

	exit;
	}	
else {
	print "****************************************************************************************\n";
	print "usage: $0 <data_file_noi_nob> <tree_form> <data_file_person_list> <generation_increment_file> <position_file> <data_file_start_names>\n";
	print "**********************************************************************************************\n";
	exit;
}		

###################################
# subroutines
###################################

sub initializeData {

	my $line; 

	print "**** Read in Tree Configuration Data\n";

	my $fnDataFileNoiNob = shift;
	my $fnTreeForm = shift;
	my $fnDataFilePersonList = shift;
	my $fnDataFileStartNames = shift;
	my $hash;
	my $hashValue;
	my $n;
	my $i;
	my $text;
	my $nameHusband = 0;
	my $nameWife = 0;

	my $numberWithWrongKeyWord = 0;
	my $NUMBER_WITH_WRONG_KEY_WORD;
	my $numberWithWrongKeyWordMessageSent = 0;

	## read data_file_noi_nob.txt
	open(IN, "<$fnDataFileNoiNob") || die "Can't open file $fnDataFileNoiNob ($!)\n";
	$line= <IN>;
	$line =~ m/(\d*) .*/; 
	$noi = $1; 
	print "noi ".$noi."\n";
	$line= <IN>;
	$line =~ m/(\d*) .*/; 
	$nob = $1; 
	print "nob ".$nob."\n";
	close(IN);

	## read tree_form.txt
	open(IN, "<$fnTreeForm") || die "Can't open file $fnTreeForm ($!)\n";
	$numberWithWrongKeyWord = 0;
	$i = 0;
	while (<IN>) {
		$i = $i + 1;
		$line= $_;
		if ($line =~ m/^#.*/) { # Comment found in line
			# nothing to do here
		} else {
			if ($line =~ m/(\d*) .*/) { # Is there a leading number with one space behind?
				$numberWithWrongKeyWord = 1;
				if ( $line =~ m/(\d*)\s*start_hus.*/ ) { # Suche Ehemann
					$start_hus_inr = $1; 
					print "start_hus_inr ".$start_hus_inr."\n";
					$numberWithWrongKeyWord = 0;
				}
				if ( $line =~ m/(\d*)\s*start_wif.*/ ) { # Suche nach Ehefrau
					$start_wif_inr = $1; 
					print "start_wif_inr ".$start_wif_inr."\n";
					$numberWithWrongKeyWord = 0;
				}
				if ( $line =~ m/(^\d*)\s*.*xclude.*/ ) { # exclude person found
					$hash = $1;
					$hashValue = $2;
					$stopHash{$hash} = "stopAndExclude";
					$numberWithWrongKeyWord = 0;
				} else {
					if ( $line =~ m/(^\d*)\s*stop.*/ ) { # stop person found, behind exclude, because of older keyword stopAndExclude
						$hash = $1;
						$hashValue = $2;
						$stopHash{$hash} = "stop";
						$numberWithWrongKeyWord = 0;
					}
				}
				if ( $line =~ m/(^\d*)( .*?)(\d*)(\s*)(looseCon.*)/ ) {  # loose connector found
					$hashValue = $1."_".$3;
					$looseConHash{$hashValue} = "looseCon";
					print "Loose Connector Extraced \n";
					$numberWithWrongKeyWord = 0;
				}
				if ( $line =~ m/(^\d*)\s*further.*/ ) { # stop person found with "further" marker instead of the frame
					$hash = $1;
					$hashValue = $2;
					$stopHash{$hash} = "stop"; # same treatment here as stop, differences occurs in tree construction
					$numberWithWrongKeyWord = 0;
				}

				if ( $line =~ m/(^\d*)\s*more.*/ ) { # stop person found with "more" marker instead of the frame
					$hash = $1;
					$hashValue = $2;
					$stopHash{$hash} = "stop"; # same treatment here as stop, differences occurs in tree construction
					$numberWithWrongKeyWord = 0;
				}

				if ( $line =~ m/(^\d*)\s*checkNumberOfPersons.*/ ) { #
					$checkLimitPersonImBaum = $1;
					$numberWithWrongKeyWord = 0;
				}

				if ( $line =~ m/(^\d*)\s*findPath.*/ ) { #
					$findPathToPersonInr = $1;
					$numberWithWrongKeyWord = 0;
				}

				if ($numberWithWrongKeyWord == 1) { # Put a Warning with two Beeps;
					if ($numberWithWrongKeyWordMessageSent == 0) {
						print "\a"; #Sending a Beep
						print "\a"; #Sending a Beep
						#print chr(7); #Sending a Beep
						$numberWithWrongKeyWordMessageSent = 1;
					}
					print "WARNUNG: In der Datei tree_form.txt folgt auf eine Zahl keine richtiges Schluesselwort.\n";
					print "Zeile:      ".$line;
					print "Zeilen-Nr.: ".$i."\n";
					if ($NUMBER_WITH_WRONG_KEY_WORD == 0) { # This if-statement is only to provoke a Perl-system-error-message in the shell, even with output forwarding.
						print "WARNUNG: In der Datei tree_form.txt folgt auf eine Zahl keine richtiges Schluesselwort.\n";
					} else {
						print "WARNUNG: In der Datei tree_form.txt folgt auf eine Zahl keine richtiges Schluesselwort.\n";
					}
				}
			}
		}
	}

	close(IN);

        while ( ($hash, $hashValue) = each %looseConHash){ 
		print $hash." ".$hashValue."\n";
	}


	print "**** Get the names of the start husband and start wife \n";
	open(IN, "<$fnDataFilePersonList") || die "Can't open file $fnDataFilePersonList ($!)\n";
	$line = <IN>; # Read of the first line, the title of the document
	while (<IN>) { # search in the person name list
		$line = $_;
		#if ( $line =~ m/(\d*) (.*)/ ) {
		if ($line =~ m/^(\d+) (.*) AD ([0-9]{2})\.([0-9]{2})\.([0-9]{4})/) { # Index-Number, Personname and Changedate in NewLine found
			$i = $1;
			$text = $2;
			if ( $i == $start_hus_inr ) {
				$nameHusband = $text;
			}
			if ( $i == $start_wif_inr ) {
				$nameWife = $text;
			}
		} else {
			print "**** ERROR: Wrong format in file ".$fnDataFilePersonList."\n";
			exit;
		}
	}
	close(IN);

	open(OUT, ">$fnDataFileStartNames") || die "Can't open file $fnDataFileStartNames ($!)\n";
	print OUT $nameHusband."\n";
	print OUT $nameWife."\n";
	close(OUT);


	print "**** Initialize Arrays \n";
	for my $i (0..$noi) {
		$n = 2*$nob+2;  #+2 is to have one addtional "0" vektor to indicate no more branches
		for my $j (0..$n) {
			$gen_inc[$i][$j] = 0;   # if the value is "0", then no further person
		}
		$inr_entered[$i] = 0;
		$inr_gen[$i] = "not_in_tree";  
		$inr_placement[$i] = 0;
		$inr_a2p[$i] = 0;
		$inr_dist[$i] = 0;
		$inr_ud[$i] = 0; 
		$inr_du[$i] = 0;
		$inr_ss[$i] = 0;
		$inr_side[$i] = 0;
	}

}


sub generatePosition {
	my $fnDataFileGenIncrement = shift;
	my $fnDataFilePosition = shift;
	my $line;
	
	my $inr;     # actual index number
	my $i;	     # counter value
	my $j;	     # counter value
	my $n;	     # a number
	my $recursion_depth; # indicates the recursion depth
	my $start_inr;
	my $start_side;

	my $start_hus_found = 0;
	my $start_wif_found = 0;
	my $partner_found = 0;

        $findPathToPersonActive = 0; # indicates that the person to find, was found in the recursion
        $findPathReturnTokenInr = 0; # indicates, on which person (inr) the return token is standing

	print "**** \n";
	print "**** Read In Generation Increment Data File and Store in Arrays \n";
	print "**** \n";

	$inr = 0;
	$i = 1;
	$j = 2;

	## read in generation increment data file
	open(IN, "<$fnDataFileGenIncrement") || die "Can't open file $fnDataFileGenIncrement ($!)\n";
	while(<IN>) {			
		$line= $_;
		if ( $line=~ m/SOI/ ) {
			$line= <IN>;
			$line =~ m/(\d*)/;
			$inr = $1;
			# print "# Index found: ".$inr."\n"; 
			$i = 1;
			$j = 2;
			if ( ($inr == $start_hus_inr) ) {
				$start_hus_found = 1;
			}
			if ( ($inr == $start_wif_inr) ) {
				$start_wif_found = 1;
			}
		} else { 
		if ( $line=~ m/EOI/ ) {
			# Do nothing at end of index
			$start_hus_found = 0;
			$start_wif_found = 0;
			# print "\n";
		} else {
		if ( $line =~ m/(.*) (.*)/ ) {
			$gen_inc[$inr][$i] = $1; # the branch index number
			$gen_inc[$inr][$j] = $2; # the generation increment for the branch
			# print " ".$gen_inc[$inr][$i]." ".$gen_inc[$inr][$j];
			$i=$i+2;
			$j=$j+2;
			if ( ($start_hus_found == 1) && ($2 == 0)  && ($start_wif_inr == 0) && ($partner_found == 0) ) { # partner of husband found with not defined wife
				$start_wif_inr = $1; # wife defined as first parnter
				$partner_found = 1;
			}
			if ( ($start_hus_found == 1) && ($2 == 0)  && ($start_wif_inr == $1) && ($partner_found == 0) ) { # partner of husband found
				$partner_found = 1;
			}
			if ( ($start_wif_found == 1) && ($2 == 0)  && ($start_hus_inr == 0) && ($partner_found == 0) ) { # partner of wife found with not defined husband
				$start_hus_inr = $1; # wife defined as first parnter
				$partner_found = 1;
			}
			if ( ($start_wif_found == 1) && ($2 == 0)  && ($start_hus_inr == $1) && ($partner_found == 0) ) { # partner of wife found
				$partner_found = 1;
			}
		} else { 
			print " **** ERROR WRONG FORMAT IN GENERATION DATA FILE\n";
		}}}
	}
	close(IN);

	print "**** \n";
	print "**** Finished Read In Generation Increment Data File and Store in Arrays \n";
	print "**** \n";

	if ( ($partner_found == 0) && ($start_hus_inr !=0) && ($start_wif_inr !=0) ) {
		print " **** WARNING Defined start partners ".$start_hus_inr." and ".$start_wif_inr." are not partners in the file ".$fnDataFileGenIncrement." !!\n";
		$start_wif_inr = 0; # unset the women
		#exit;
	}

	if ( ($start_hus_inr == 0) && ($start_wif_inr ==0) ) {
		print " **** WARNING: No start husband and no start wife defined!\n";
		$start_hus_inr = 1; # set Index No. as husband as default
		$stopHash{"1"} = "stop"; # set default to no persons
		#exit;
	}

	if ($start_hus_inr != 0) {
		$start_inr = $start_hus_inr;
		$start_side = -1;  # left side of the tree
	}

	if ( ($start_hus_inr == 0) && ($start_wif_inr !=0) ) {
		$start_inr = $start_wif_inr;
		$start_side = +1;  # right side of the tree
	}
	
	print " **** Husband= ".$start_hus_inr." Wife= ".$start_wif_inr."\n";

	$inr_gen[$start_inr] = 0; # defines the start (proband) generation as 0
	$inr_dist[$start_inr] = 0;
	$inr_ud[$start_inr] = 0;
	$inr_du[$start_inr] = 0;
	$inr_ss[$start_inr] = 0;
	$inr_side[$start_inr] = $start_side;
	$start_dir = 0;
        $placement = 1;

	$notReadyAllInr = 1;
	$maxDuSteps = 0;
	$maxUdSteps = 0;
	$firstEnterDir = +1;
	$secondEnterDir = -1;
	$thirdEnterDir = 0;

	while ($notReadyAllInr == 1) {  # solange bis alle Unterzweige abgearbeitet sind
		$notReadyAllInr = 0;
        	$findPathToPersonActive = 0; 
       		$findPathReturnTokenInr = 0; 
		$findPathCnt = 0;
		
		
		# enter the tree 
		&enterPerson($start_inr,$start_dir,0);

		print "\n";
		print "notReadyAllInr: ".$notReadyAllInr."\n";
		print "\n";

		if ($firstEnterDir == 1) { # enlarge branch limits and changed priority direction
			$maxUdSteps = $maxUdSteps + 1;
			$firstEnterDir = -1;
			$secondEnterDir = +1;
		} else {
			$maxDuSteps = $maxDuSteps + 1;
			$firstEnterDir = +1;
			$secondEnterDir = -1;
		}
		print "**** Initialize Arrays \n";

		# reset status, that person are already entered in the tree

		for my $i (0..$noi) {
			$inr_entered[$i] = 0;
		}

	}

	open(OUT, ">$fnDataFilePosition") || die "Can't open file $fnDataFilePosition ($!)\n";
	for my $i (1..$noi) {
		print OUT " INR ".$i;
		print OUT " GEN ".$inr_gen[$i];
		print OUT " DIST ".$inr_dist[$i];
		print OUT " UD ".$inr_ud[$i];     
		print OUT " DU ".$inr_du[$i];     
		print OUT " SS ".$inr_ss[$i];
		print OUT " SIDE ".$inr_side[$i];
		print OUT " PLC ".$inr_placement[$i];
		print OUT " A2P ".$inr_a2p[$i]."\n";
	}
	close(OUT);

}

sub enterPerson {
	my $inr = shift;
	my $dir = shift;
	my $inr_last = shift;

	my $inr_next;
	my $dir_next;
	my $parentNo;
	my $firstParentInr;
	
	my $i;
	my $k;
	my $exclude;


	print "\n";
	print "**** Actual Index:       ".$inr." \n";
	print "**** Generation:         ".$inr_gen[$inr]." \n";
	
	# entered person is already active in the recursion
	if ( $inr_entered[$inr] == 1 ) {
	print " **** Person ".$inr." already active in recursion. \n";
		return;
	}

	# entered person is marked as "stopAndExclude"
	if ( defined $stopHash{$inr} ) {
		if ( $stopHash{$inr} eq "stopAndExclude" ) {
			print " **** Person ".$inr." is marked as \"stopAndExclude\"\n";
			return;
		}
	}

	# loose connection detected to cut loops in the tree
	print "looseConHash ".$inr_last."_".$inr."\n";
	print "looseConHash ".$inr."_".$inr_last."\n";
	if ( (defined $looseConHash{$inr_last."_".$inr}) || (defined $looseConHash{$inr."_".$inr_last}) ) {
		print " **** Loose Connection Found between Person ".$inr." and Person ".$inr_last."\n";
		return;
	}

	# entered person is on a not yet unallowed up- or down-branch 

	if (($inr_du[$inr] > $maxDuSteps) || ($inr_ud[$inr] > $maxUdSteps)) { # person in unallowed branch
		$notReadyAllInr = 1;
		return;
	}


	$inr_entered[$inr] = 1; # Mark the person as entered person in the recursion

	# enterd person is the one, to which the path should be found.

	if ($inr == $findPathToPersonInr) {
		$findPathToPersonActive = 1;     # indicates that the person to find, was found in the recursion
		$findPathReturnTokenInr = $inr;   # indicates, on which person (inr) the return token is standing
		$findPathCnt = 1;
		$findPathInr[$findPathCnt] = $inr;
		$findPathInrHash{$inr} = "inPath";
		print "Set Find-Path Token on Searched Person: ".$inr."\n";
	}
		
	# entered person is marked as "stop"
	if ( defined $stopHash{$inr} ) {
		if ( $stopHash{$inr} eq "stop" ) {
			print " **** Person ".$inr." is marked as \"stop\" \n";
				return;
		}
	}

	# Start Person Detected
	if ( ($inr == $start_hus_inr) ) { # found husband
		print " **** Found Husband ".$inr."\n";
		$inr_side[$inr] = -1; # now we are on the left side of the tree
		$inr_gen[$inr] = 0; # defines the start generation as 0
		$inr_ud[$inr] = 0;
		$inr_du[$inr] = 0; 
		$inr_ss[$inr] = 0;
		$inr_dist[$inr] = 0;
		$inr_placement[$inr] = 1;
		$inr_a2p[$inr] = 0;
		$dir = 0;
	}
	if ( ($inr == $start_wif_inr) ) { # found wife
		print " **** Found Wife ".$inr."\n";
		$inr_side[$inr] = +1; # now we are on the right side of the tree
		$inr_gen[$inr] = 0; # defines the start generation as 0
		$inr_ud[$inr] = 0;
		$inr_du[$inr] = 0; 
		$inr_ss[$inr] = 0;
		$inr_dist[$inr] = 0;
		$inr_placement[$inr] = 1;
		$inr_a2p[$inr] = 0;
		$dir = 0;
	}

	# define the placement values for the connected persons of the just entered person

	$i = 1;
	$k = 2;
	$inr_next = $gen_inc[$inr][$i]; # Looking for the first branch from person
	$dir_next = $gen_inc[$inr][$k]; # Looking for the increment
	$parentNo = 0; # Indicates, that the first parent was found
	$firstParentInr = 0; 
	while( $inr_next != 0 ) { # There is a further person in the branch
		$exclude = 0;
		# next person is marked as "stopAndExclude"
		if ( defined $stopHash{$inr_next} ) {
			if ( $stopHash{$inr_next} eq "stopAndExclude" ) {
				print " **** Person ".$inr_next." is marked as \"stopAndExclude\" \n";
				$exclude = 1;
			}
		}

		# loose connection detected to cut loops in the tree
		print "looseConHash ".$inr_next."_".$inr."\n";
		print "looseConHash ".$inr."_".$inr_next."\n";
		if ( (defined $looseConHash{$inr_next."_".$inr}) || (defined $looseConHash{$inr."_".$inr_next}) ) {
			print " **** Loose Connection Found between Person ".$inr." and Person ".$inr_next."\n";
			$exclude = 1;
		}

		if ( ($inr_placement[$inr_next] == 0) && ($exclude == 0) ) { # found un-placed person. which is not excluded
			# set side
	
			$inr_side[$inr_next] = $inr_side[$inr];  # default: next person has the same side

			if ( (($inr == $start_hus_inr) || ($inr == $start_wif_inr)) && ($dir_next == -1) ) { # down from start persons
				$inr_side[$inr_next] = 0;
			} 
			# else {
				#if ( (($inr == $start_hus_inr) || ($inr == $start_wif_inr)) && ($dir_next == 0) ) {
				#	$inr_side[$inr_next] = $inr_side[$inr] * (-1);  # change the side
				#} else {
				#	$inr_side[$inr_next] = $inr_side[$inr]; #next person has the same side
				#}
				#if ( ( ($inr == $start_hus_inr) && ($inr_next != $start_wif_inr) && ($dir_next == 0) ) || ( ($inr_next != $start_hus_inr) && ($inr == $start_wif_inr) && ($dir_next == 0) ) ) {
				#	$inr_side[$inr_next] = $inr_side[$inr];  # stay at the same side, it is the second partner of the starting person
				#} else { 
				#	$inr_side[$inr_next] = $inr_side[$inr];  #next person has the same side
				#}
			#}
			# set other distance parameters
			if ( ( ($dir == 1) || ($dir == 0) )&& ($dir_next == 1) ) { # go up in the tree
				$inr_gen[$inr_next] = $inr_gen[$inr] + $dir_next;
				$inr_ud[$inr_next] = $inr_ud[$inr];
				$inr_du[$inr_next] = $inr_du[$inr];
				$inr_ss[$inr_next] = $inr_ss[$inr];
				$inr_dist[$inr_next] = $inr_dist[$inr] + 1;
				$placement = $placement + 1;
				$inr_placement[$inr_next] = $placement;
			
				# check, that mother will be attached to the father
				$parentNo = $parentNo + 1;
				if ($parentNo == 1) {
					$firstParentInr = $inr_next;
				}
				if ($parentNo == 2) { # the second parent is normally the mother, which needs to be attached
					$inr_a2p[$inr_next] = $firstParentInr; # attach mother to father
				}
			}
			if ( ( ($dir == -1) || ($dir == 0) ) && ($dir_next == -1) ) { # go down in the tree
				$inr_gen[$inr_next] = $inr_gen[$inr] + $dir_next;
				$inr_ud[$inr_next] = $inr_ud[$inr];
				$inr_du[$inr_next] = $inr_du[$inr];
				$inr_ss[$inr_next] = $inr_ss[$inr];
				$inr_dist[$inr_next] = $inr_dist[$inr] + 1;
				$placement = $placement + 1;
				$inr_placement[$inr_next] = $placement;
				#&placePartners($inr_next);
			}
			if ( ($dir == 1) && ($dir_next == -1) ) { # change from up direction into down direction
				$inr_gen[$inr_next] = $inr_gen[$inr] + $dir_next;
				$inr_ud[$inr_next] = $inr_ud[$inr] + 1;
				$inr_du[$inr_next] = $inr_du[$inr];
				$inr_ss[$inr_next] = $inr_ss[$inr];
				$inr_dist[$inr_next] = $inr_dist[$inr] + 1;
				$placement = $placement + 1;
				$inr_placement[$inr_next] = $placement;
			}
			if ( ($dir == -1) && ($dir_next == 1) ) { # change from down direction into up direction
				$inr_gen[$inr_next] = $inr_gen[$inr] + $dir_next;
				$inr_ud[$inr_next] = $inr_ud[$inr];
				$inr_du[$inr_next] = $inr_du[$inr] + 1;
				$inr_ss[$inr_next] = $inr_ss[$inr];
				$inr_dist[$inr_next] = $inr_dist[$inr] + 1;
				$placement = $placement + 1;
				$inr_placement[$inr_next] = $placement;
			}
			#if ( (($dir == 1) || ($dir == 0)) && ($dir_next == 0) ) { # go sideward in the tree
			if ($dir_next == 0) { # go sideward in the tree
				$inr_gen[$inr_next] = $inr_gen[$inr];
				$inr_ud[$inr_next] = $inr_ud[$inr];
				$inr_du[$inr_next] = $inr_du[$inr];
				$inr_ss[$inr_next] = $inr_ss[$inr] + 1;
				$inr_dist[$inr_next] = $inr_dist[$inr] + 1;
				$placement = $placement + 1;
				$inr_placement[$inr_next] = $placement;
				#$inr_placement[$inr_next] = $inr_placement[$inr]; 
				$inr_a2p[$inr_next] = $inr;
				#&placePartners($inr_next);
			}
			#if ( (($dir == -1) || ($dir == 0)) && ($dir_next == 0) ) { # go sideward in the tree
			#	$inr_gen[$inr_next] = $inr_gen[$inr];
			#	$inr_ud[$inr_next] = $inr_ud[$inr];
			#	$inr_du[$inr_next] = $inr_du[$inr];
			#	$inr_ss[$inr_next] = $inr_ss[$inr] + 1;
			#	$inr_dist[$inr_next] = $inr_dist[$inr] + 1;
			#	$placement = $placement + 1;
			#	$inr_placement[$inr_next] = $placement;
			#	#$inr_placement[$inr_next] = $inr_placement[$inr]; 
			#	$inr_a2p[$inr_next] = $inr;
			#}
		}
	
		$i=$i+2;
		$k=$i+1;
		$inr_next = $gen_inc[$inr][$i]; # Looking for the next person
		$dir_next = $gen_inc[$inr][$k]; # Looking for the increment
	}
	# Sending a beep at too many persons
	if ($placement > $checkLimitPersonImBaum) {
		if  ($mehr_als_limit_message_sent==0) { #Sent only one Beep
			print "\a"; #Sending a Beep
			#print chr(7); #Sending a Beep
			$mehr_als_limit_message_sent = 1;
			print "WARNUNG: Die Anzahl der Personen im Baum ueberschreitet das gesetzte Limit.\n";
			if ($MEHR_ALS_LIMIT_PERSONEN_IM_BAUM == 0) { # This if-statement is only to provoke a Perl-system-error-message in the shell, even with output forwarding.
				print "WARNUNG: Die Anzahl der Personen im Baum berschreitet das gesetzte Limit.\n";
			} else {
				print "WARNUNG: Die Anzahl der Personen im Baum ueberschreitet das gesetzte Limit.\n";
			}
		}
	#die "This is the End";
	}

	print "# enter the next persons in first  direction = ".$firstEnterDir."\n";

	$i = 1;
	$k = 2;
	$inr_next = $gen_inc[$inr][$i]; # Looking for the next person
	$dir_next = $gen_inc[$inr][$k]; # Looking for the increment
	while( $inr_next != 0 ) { # There is a further branch from the actual person
		if ( ($dir_next == $firstEnterDir) && (($dir_next != 1) || ($dir != -1)) ) { # go new dir, but not back to the father or mother		

			# Do the recursion
			print "# enter INR ".$inr_next."\n";
			&enterPerson($inr_next,$dir_next,$inr);
			print "# return to INR ".$inr."\n";
		}
		$i = $i + 2;
		$k = $i + 1;
		$inr_next = $gen_inc[$inr][$i]; # Looking for the next person
		$dir_next = $gen_inc[$inr][$k]; # Looking for the next increment
	}	
		
	print "# enter the next persons in second direction = ".$secondEnterDir."\n";

	$i = 1;
	$k = 2;
	$inr_next = $gen_inc[$inr][$i]; # Looking for the next person
	$dir_next = $gen_inc[$inr][$k]; # Looking for the increment
	while( $inr_next != 0 ) { # There is a further person in the branch
		if ( ($dir_next == $secondEnterDir) && (($dir_next != 1) || ($dir != -1)) ) { # go new dir, but not back to the father or mother

			# Do the recursion
			print "# enter INR ".$inr_next."\n";
			&enterPerson($inr_next,$dir_next,$inr);
			print "# return to INR ".$inr."\n";
		}
		$i = $i + 2;
		$k = $i + 1;
		$inr_next = $gen_inc[$inr][$i]; # Looking for the next person
		$dir_next = $gen_inc[$inr][$k]; # Looking for the next increment
	}	
	
	print "# enter the next persons in third  direction = ".$thirdEnterDir."\n";

	$i = 1;
	$k = 2;
	$inr_next = $gen_inc[$inr][$i]; # Looking for the next person
	$dir_next = $gen_inc[$inr][$k]; # Looking for the increment
	while( $inr_next != 0 ) { # There is a further person in the branch
		if ( ($dir_next == $thirdEnterDir) && (($dir_next != 1) || ($dir != -1)) ) { # go new dir, but not back to father or mother

			# Do the recursion
			print "# enter INR ".$inr_next."\n";
			&enterPerson($inr_next,$dir_next,$inr);
			print "# return to INR ".$inr."\n";
		}
		$i = $i + 2;
		$k = $i + 1;
		$inr_next = $gen_inc[$inr][$i]; # Looking for the next person
		$dir_next = $gen_inc[$inr][$k]; # Looking for the next increment
	}	

	# Set Find Path Return Token

	if (($findPathToPersonActive == 1) && ($findPathReturnTokenInr == $inr)) {
		$findPathReturnTokenInr = $inr_last; # set the return token one level higher
		$findPathCnt = $findPathCnt + 1;
		$findPathInr[$findPathCnt] = $inr_last;
		$findPathInrHash{$inr_last} = "inPath";
		print "Set Find-Path Token on Person: ".$inr_last."\n";
	}
		
	print "**** leaving INR ".$inr."\n";		
}

sub placePartners {
	my $inr2 = shift;
	my $i2;
	my $k2;
	my $exclude2;
	my $inr_next2;
	my $dir_next2;

	
	$i2 = 1;
	$k2 = 2;
	$inr_next2 = $gen_inc[$inr2][$i2]; # Looking for the first branch from person
	$dir_next2 = $gen_inc[$inr2][$k2]; # Looking for the increment
	while( $inr_next2 != 0 ) { # There is a further person in the branch
		print "Placement Loop ".$i2." ".$k2."\n";
		$exclude2 = 0;
		# next person is marked as "stopAndExclude"
		if ( defined $stopHash{$inr_next2} ) {
			if ( $stopHash{$inr_next2} eq "stopAndExclude" ) {
				print " **** Person ".$inr_next2." is marked as \"stopAndExclude\" \n";
				$exclude2 = 1;
			}
		}

		if ( ($inr_placement[$inr_next2] == 0) && ($exclude2 == 0) ) { # found un-placed person. which is not excluded
			if ($dir_next2 == 0) { # go sideward in the tree
				$inr_gen[$inr_next2] = $inr_gen[$inr2];
				$inr_ud[$inr_next2] = $inr_ud[$inr2];
				$inr_du[$inr_next2] = $inr_du[$inr2];
				$inr_ss[$inr_next2] = $inr_ss[$inr2] + 1;
				$inr_dist[$inr_next2] = $inr_dist[$inr2] + 1;
				$placement = $placement + 1;
				$inr_placement[$inr_next2] = $placement;
				$inr_a2p[$inr_next2] = $inr2;
			}
		}

		$i2=$i2+2;
		$k2=$i2+1;
		$inr_next2 = $gen_inc[$inr2][$i2]; # Looking for the next person
		$dir_next2 = $gen_inc[$inr2][$k2]; # Looking for the increment

	}
}

sub writeFindPath {
	
	my $fnFindPath = shift;
	my $fnPersonList = shift;
	my $i;
	my $j;
	my $line;
	my $inrPath;
	my $name;

	# Look in the person list for the person names

	open(IN, "<$fnPersonList") || die "Can't open file $fnPersonList ($!)\n";
	$line= <IN>; # erste Zeile auslesen.
	while (<IN>) {
		$line= $_;
		if ($line =~ m/^(\d+) (.*) AD ([0-9]{2})\.([0-9]{2})\.([0-9]{4})/) { # Index-Number, Personname and Changedate in NewLine found
			$j = $1;
			$name = $2;
			if ( defined $findPathInrHash{$j} ) {
				$findPathInrHash{$j} = $name;
				#print $j." ".$name." gefunden\n"
			}
		} else {
			print "WARNUNG: Zeile in Personliste ohne Index, Name oder Datum!\n";
			print $line;
			exit;
		}
	}
	close(IN);

	open(OUT, ">$fnFindPath") || die "Can't open file $fnFindPath ($!)\n";

	print "\n";	
	print "Personenabfolge von der Start-Person zur Ziel Person\n";
	print OUT "Personenabfolge von der Start-Person zur Ziel Person\n";
	print "----------------------------------------------------\n";
	print OUT "----------------------------------------------------\n";
	print "\n";
	print OUT "\n";
	print "Anzahl der Personen im Baum: ".$placement."\n\n";
	print OUT "Anzahl der Personen im Baum: ".$placement."\n\n";
	#print OUT "Test ".$findPathCnt;
	if ($findPathCnt == 0) { #keine Verbindung
		print "Es gibt keine Verbindung zwischen Start- und Zielperson.\n";
		print OUT "Es gibt keine Verbindung zwischen Start- und Zielperson.\n";
	} else {
		$inrPath = $findPathInr[$findPathCnt-2+1];
		print $inrPath." ".$findPathInrHash{$inrPath}." -> Startperson\n";
		print OUT $inrPath." ".$findPathInrHash{$inrPath}." -> Startperson\n";
		for $i (3..$findPathCnt-1) {
			$inrPath = $findPathInr[$findPathCnt-$i+1];
			print $inrPath." ".$findPathInrHash{$inrPath}."\n";
			print OUT $inrPath." ".$findPathInrHash{$inrPath}."\n";
		}		
		$inrPath = $findPathInr[1];
		print $inrPath." ".$findPathInrHash{$inrPath}." -> Zielperson\n";
		print OUT $inrPath." ".$findPathInrHash{$inrPath}." -> Zielperson\n";
	}	
	close(OUT);
}

