##############################################################################
# Author        : Ruediger Arnold
# Date          : 29.05.2012 Merge New and Old Data
# Description   : Merge the frame height file of the old frames with the new frames
# Category      : Parser
#############################################################################
#               : 
#               : initial
#               :
##############################################################################

use strict;
use warnings;


###################################
# main routine
###################################
if ($#ARGV == 1) {
	&mergeHeightFiles($ARGV[0],$ARGV[1],"data_file_frame_height_merged_new_old.txt");
	exit;
	}	
else {
	print "*****************************\n";
	print "usage: $0 do \n";
	print "*****************************\n";
	exit;
}		

###################################
# subroutines
###################################


sub mergeHeightFiles {
	my $filenameBoxHeightListOld = shift;
	my $filenameBoxHeightListNew = shift;
	my $filenameBoxHeightListMerged = shift;

	my $line1;
	my $line2;	
	my $inr; # actual index number
	my $inrMax; # maximum occurred index number
	my $i;	 # counter value
	my @frameLines;
	my $eolOldList; #

	$inrMax = 0;
	print "**** Read In Old Frame Height File\n";
	if ( -e $filenameBoxHeightListOld ) { # old heigth file exists
		open(IN1, "<$filenameBoxHeightListOld") || die "Can't open the old frame height list ($!)\n";
		while (<IN1>) { # read in old heights
			$line1= $_;
			$line1=~ m/(\d*) (.*)/;
			$inr = $1; # index number
			if ( $inr > $inrMax ) {
				$inrMax = $inr;
			}
			$frameLines[$inr] = $line1;
		}
	}
	close(IN1);

	print "**** Read In New Frame Height File\n";
	open(IN2, "<$filenameBoxHeightListNew") || die "Can't open the old frame height list ($!)\n";
	while (<IN2>) { # read in new heights
		$line2= $_;
		$line2=~ m/(\d*) (.*)/;
		$inr = $1; # index number
		$frameLines[$inr] = $line2;
		if ( $inr > $inrMax ) {
			$inrMax = $inr;
		}
	}
	close(IN2);

	open(OUT, ">$filenameBoxHeightListMerged") || die "Can't open for writing the merged list file ($!)\n";
	print "**** Write merged Frame Height File \n";
	for $i (1..$inrMax) {
		if ( defined $frameLines[$i] ) {
			print OUT $frameLines[$i];
		}
	}
	close(OUT);
		
}

