##############################################################################
# Author        : Ruediger Arnold
# Date          : 09.03.2011 
# Date          : 16.05.2012 Window und Linux
# Description   : Extract the name box height for all save odg files in the oo_draw dir 
# Category      : Parser
#############################################################################
#               : 
#               : initial
#               :
##############################################################################

use strict;
use warnings;


###################################
# main routine
###################################
if ($#ARGV == 0) {
	&generateBoxHeight("data_file_frame_height.txt");
	exit;
	}	
else {
	print "*****************************\n";
	print "usage: $0 do \n";
	print "*****************************\n";
	exit;
}		

###################################
# subroutines
###################################

sub unzipOdg {
	my $inr = shift;
        if ( $^O eq "MSWin32") {  # Window Operating System
                print "Window Operating System 1\n";
		system("\%\$unzip\% \%\$odgDir\%\\i".$inr.".odg");
		# unzip the data into the start directory of the perl script
        } else {
                print "Linux Cygwin or MAC Operating System 1\n";
		system("\$unzip \$odgDir\/i".$inr.".odg");
        }

}
sub generateBoxHeight {
	my $filenameBoxHeightList = shift;
	my $filenameFileList = "file_list.txt";
	my $filenameContent = "content.xml";
	my $line;
	my $line2;	
	my $inr; # actual index number
	my $i;	 # counter value
	my $w;   # box width
	my $h;   # box heigth

	print "**** Read In Open Drawing File List\n";
	## open content XML file
	open(IN, "<$filenameFileList") || die "Can't open file file_list.txt ($!)\n";
	open(OUT, ">$filenameBoxHeightList") || die "Can't open file $filenameBoxHeightList ($!)\n";
	while(<IN>) {			
		$line= $_;
		if ( $line=~ m/(.*) i(\d*)\.odg/ ) {
			$inr = $2;
			print "# Index found: ".$inr."\n"; 
			&unzipOdg($inr);
			open(IN2, "<$filenameContent") || die "Can't open file $filenameContent($!)\n";
			while(<IN2>) {			
				$line2= $_;
				if ( $line2=~ m/(.*)svg:width="(.*)cm"(.*)svg:height="(.*)cm" svg:x(.*)/ ) {
					$w = $2;
					$h = $4;
					print "**************************************************\n";
					print "# Index-Nr.: ".$inr." Width: ".$w." Height: ".$h."\n";
					print "**************************************************\n";
					print OUT $inr." ".$w." ".$h."\n";
				}
			}
			close(IN2);		
		}
	}
	close(OUT);
	close(IN);
	
}


