##############################################################################
# Author        : Ruediger Arnold
# Date          : 06.04.2015
# Description   : Exclude Collect Person from the In-Book-List
# Category      : Parser
#############################################################################
#               : 
#               : initial
#               :
##############################################################################

use strict;


###################################
# main routine
###################################

my @tree_exclude_files; # Array of tree list files
my $data_file_noi_nob; # Filename with Number of Branches and Trees
my $noi=0; # number of indexes
my $nob=0; # number of branches, not used here in this perl script, but required
my $noexper; # number of excluded persons
my %person_exclude_hash; # shows, which persons should not be in the FAM_BUCH


if ($#ARGV == 2) {
	&initializeData($ARGV[0],$ARGV[2]);
	&writePersonsIntoBook($ARGV[1]);
	}	
else {
	print "*****************************\n";
	print "usage: $0 <exclude_file_list> <person_into_book> <data_file_noi_noi> \n";
	print "*****************************\n";
	exit;
}		

###################################
# subroutines
###################################
sub initializeData {
	my $fnPersonExcludeFileList = shift; # Liste mit Files zum Ausschluss aus dem Buch
	my $fnDataFileNoiNob = shift; # Number of Index and Branch File
	my $fn;
	my $line;
	my $index;
	
	if ( $^O eq "MSWin32") {  # Window Operating System
		print "Window Operating System\n";
		system("echo Suche nach Exclude Dateien fuer Personen");
		#print "vor schluss\n";
		system("cd Ergebnisse\\DATA_COLLECTION\\exclude_persons & dir persons_in_tree*.txt /b /s > $fnPersonExcludeFileList");
		#$path_limiter="\";
		#print "schluss\n";
		#exit;
	} else {
		print "Linux Cygwin or MAC Operating System\n";
		system("find . -name $fnPersonExcludeFileList");
		#$path_limiter="/";
	}

	## read data_file_noi_nob.txt
	open(IN, "<$fnDataFileNoiNob") || die "Can't open file $fnDataFileNoiNob ($!)\n";
	$line = <IN>;
	$line =~ m/(\d*) .*/; 
	$noi = $1; 
	print "Anzahl Personen in Datenbasis ".$noi."\n";
	$line = <IN>;
	$line =~ m/(\d*) .*/; 
	$nob = $1; 
	#print "nob ".$nob."\n";
	close(IN);

	$noexper = 0;
	print "\nLese alle Dateien mit auszuschliessenden Personen.\n";
	open(IN1,  "<$fnPersonExcludeFileList") || die "Can't open file $fnPersonExcludeFileList ($!)\n";
	while(<IN1>) { # alle Exclude-Files durchgehen
	$fn = $_;
		open(IN2,  "<$fn") || die "Can't open file $fn ($!)\n";
		$line = <IN2>; # erste Zeile wird verworfen, koennte UFT Code sein
		while(<IN2>) {
			$line = $_;
			if ( $line =~ m/^([0-9]+) (.*)  AD ([0-9]{2})\.([0-9]{2})\.([0-9]{4})/ ) { # suche Index-Nummer, Namen + Aenderungsdatum
				$index=$1;
				if ( defined $person_exclude_hash{$index} ) {
					# Person schon ausgeschlossen
				} else {
					$person_exclude_hash{$index} = "excluded";
					$noexper = $noexper + 1;
				}
			}
		}
		close IN2;
	}
	close IN1

}

sub writePersonsIntoBook {
	my $fnPersonIntoBookFile = shift;
	my $i;

	print "\nSchreibe alle Indexnummern, die in das Buch sollen in Datei:\n\n";
	print $fnPersonIntoBookFile."\n\n";
	open(OUT, ">$fnPersonIntoBookFile") || die "Can't open file $fnPersonIntoBookFile ($!)\n";
	print OUT "Datenbasispersonenzahl: ".$noi." Anzahl ausgeschlossener Personen: ".$noexper."\n";
	for $i (1..$noi) {
		if ( defined $person_exclude_hash{$i} ) {
			# Person nicht ausgeben
		} else {
			print OUT $i.",";
		}
	}
	print OUT "\n\n"; # Zeilenumbruch zum besseren Copy&Paste
	close OUT;
}

