##############################################################################
# Author        : Ruediger Arnold
# Date          : 19.01.2015
# Description   : Collect all Tree Data and put it into the RTF-File FAMILIEN_BUCH_V5
# Category      : Parser
#############################################################################
#               : 
#               : initial
#               :
##############################################################################

use strict;


###################################
# main routine
###################################

my @tree_file_path; # Array of tree list files
my @tree_fam_name; # Name of the Family
my @tree_gen_date; # Date of Generation
my @tree_gen_date_format; # Date of Generation with normal Format DD.MM.YYYY
my $noft; # number of different family trees 
my $noi=0;
my @person_csv_line; # number of trees with the person for CSV File
my @person_rtf_line; # number of trees with the person for RTF File
my @person_name;     # name of Person in RTF File
my @person_date;     # last change date of the Person in RTF File  YYYYMMDD
#my $path_limiter;    # can be \ for Windows or / for Unix
my $j;


if ($#ARGV == 7) {
	&initializeData($ARGV[6]);
	&generateTreeList($ARGV[0]);
	&readTreeLists($ARGV[0],$ARGV[7]);
	&writePersonInTreesCvs($ARGV[2],$ARGV[3],$ARGV[1]);
	&putTreeDataIntoRTF($ARGV[4],$ARGV[5]);
	exit;
	}	
else {
	print "*****************************\n";
	print "usage: $0 <list_of_tree_lists.txt> \n";
	print "*****************************\n";
	exit;
}		

###################################
# subroutines
###################################
sub initializeData {
	my $filename1 = shift; # Personenliste von FB2ODG mit Indexnummer und Datum
	my $line;
	my $index;
	my $i;
	

	open(IN,  "<$filename1") || die "Can't open file $filename1 ($!)\n";
	$line = <IN>; # erste Zeile "Personen-Liste (AD = nderungsdatum)" wird verworfen
	while(<IN>) {
		$line = $_;
		if ( $line =~ m/([0-9]+) (.*)  AD ([0-9]{2})\.([0-9]{2})\.([0-9]{4})/ ) { # suche Index-Nummer, Namen + Aenderungsdatum
			$index=$1;
			$noi += 1;  # Zaehlen der Indexe
			$person_name[$index] = $2;
			$person_date[$index] = $5.$4.$3;  # Date of Person in Format YYYYMMDD
		} else {
			print "FEHLER: Zeile ohne Nummer und Name und Datum in ".$filename1."\n";
			print $line;
			exit;
		}
	}
	close IN;

	# Initialize Arrays
	for $j (1 .. $noi) {
		$person_csv_line[$j]=$j.",";
		$person_rtf_line[$j]="";
	}

}

sub generateTreeList {
	my $fn_treelist = shift;

	if ( $^O eq "MSWin32") {  # Window Operating System
		print "Window Operating System\n";
		system("echo Suche nach Stammbaeumen im Ergebnis-Verzeichnis");
		system("cd Ergebnisse & dir persons_in_tree.txt /b /s > $fn_treelist");
		#$path_limiter="\";
		#exit;
	} else {
		print "Linux Cygwin or MAC Operating System\n";
		system("find . -name $fn_treelist");
		#$path_limiter="/";
	}
}

sub readTreeLists {
	my $fn_treelist = shift;
	my $fn_excludelist = shift;
	my $line;
	my $tree_name;
	my $tree_name_base;
	my $tree_date_time;
	my $tree_date;
	my $tree_time;
	my $tree_date_format; # DD.MM.YYYY
	my $tree_name_old;
	my $date;
	my %file_exclude_hash;

	## open list exclude list
	open(IN, "<$fn_excludelist") || die "Can't open file $fn_excludelist ($!)\n";
	while(<IN>) {
		$line = $_;
		$file_exclude_hash{$line}="exclude_this_file";
	}
	close(IN);
	
	## open list of tree_lists file
	#print "***** Open List of TreeList File \n";
	$noft = 0;
	$tree_name_old="";

	open(IN, "<$fn_treelist") || die "Can't open file $fn_treelist ($!)\n";
	while(<IN>) {
		$line = $_;
		print $line."\n";
#		if ($line =~ m/(.*)\\(.+?)_([0-9]{8}).*?\\Baumdefinitionen\\persons_in_tree\.txt.*/ ) { # suche nach dem Stammbaum-Namen
		if ($line =~ m/(.*)\\(.*)_([0-9]{8}).*/ ) { # suche nach dem Stammbaum-Namen
			$tree_name = $2;
			$tree_date_time = $3;
			if ($tree_date_time =~ m/([0-9]{8})_([0-9]{6})/ ) { # Pfad mit Uhrzeit gefunden
				$tree_date = $1;
				$tree_time = $2;
			} else {
				$tree_date = $tree_date_time;  # Stammbaum ohne Uhrzeit
				$tree_time = "000000";
			}
		} else {
			print "Falsches Format in der Datei-Liste in Zeile z.B. kein Datum YYYYMMDD:\n";
			print $line."\n";
		}	
		#print $tree_name."\n";
		#print $tree_date."\n";
		#print $tree_time."\n";
		#exit;
		if ( defined $file_exclude_hash{$tree_name} ) {
			# tu nichts, dieser Baum wird ignoriert
		} else {
			# Datum Umformatierung	
	
			if ( $tree_date =~ m/([0-9]{4})([0-9]{2})([0-9]{2})/ ) {
				# Datumsformat-Generierung
				$tree_date_format = $3."\.".$2."\.".$1;
			} else {
				print "FEHLER: falsche Datumsformat: ".$tree_gen_date[$noft]." nicht YYYYMMDD.\n";
				exit;
			}
	
			# Analyse ob es sich um den letzten Baum handeltA
	
			if ( $tree_name eq $tree_name_old ) {
				# kein neuer Familienstammbaum in Liste oder erste Zeile
				$tree_file_path[$noft] = $line;
				$tree_fam_name[$noft] = $tree_name;
				$tree_gen_date[$noft] = $tree_date;
				$tree_gen_date_format[$noft] = $tree_date_format;
				print "NAME BEKANNT ".$noft." ".$tree_name." ".$tree_date."\n";
				$tree_name_old=$tree_name;
			} else {
				# neuer Familienstammbaum gefunden
				$noft += 1;	
				$tree_file_path[$noft] = $line;
				$tree_fam_name[$noft] = $tree_name;
				$tree_gen_date[$noft] = $tree_date;
				$tree_gen_date_format[$noft] = $tree_date_format;
				print "NAME NEU     ".$noft." ".$tree_name." ".$tree_date."\n";
				$tree_name_old=$tree_name;
			}
			#print $noft."\n";
		}
	}
	
	close(IN);


}

sub writePersonInTreesCvs {
	my $filename1 = shift; # CSV-Datei
	my $resultDir = shift; # Ergebnispfad
	my $filename2 = shift;
	my $filename3;  # Pfad der Stammbaum-person_in_tree.txt
	my $i;
	my $index;
	my $name_und_datum;
	my $person_name_in_tree; # Name im tree
	my $person_date_in_tree; # Datum der Person im tree
	my $line;
	my @number_of_n; # Anzahl der falschen Namen im Baum
	my @number_of_d; # Anzahl der abgelaufenen Aenderungsdaten
	my @number_of_i; # Anzahl der Personen im Baum

	print "\n\n";
	print "*****************************************\n";
	print "* Vergleich Tree mit RTF Personen Daten *\n";
	print "*****************************************\n";
	print "\n";
	for $i (1 .. $noft) { # Initializierung
		$number_of_d[$i]=0; 
		$number_of_n[$i]=0; 
		$number_of_i[$i]=0; 
	}
	for $i (1 .. $noft) {
		#$filename3 = $resultDir.$tree_file_path[$i];
		$filename3 = $tree_file_path[$i];
		#print $filename3."\n";
		open(IN, "<$filename3") || die "Can't open file $filename3 ($!)\n";
		while(<IN>) {
			$line = $_;
			if ( $line =~ m/([0-9]+) (.*)/ ) { # suche Index-Nummer, Namen + Aenderungsdatum
				$number_of_i[$i]+=1; 
				$index=$1;
				$name_und_datum=$2;
				if ( $name_und_datum =~ m/(.*)  AD ([0-9]{2})\.([0-9]{2})\.([0-9]{4}).*/ ) { # Datum gefunden
					$person_name_in_tree=$1;
					$person_date_in_tree=$4.$3.$2;
				} else {
					$person_name_in_tree=$name_und_datum;
					$person_date_in_tree=$tree_gen_date[$i]; # Wenn kein Datum individual vorhanden, dann pro Person dann Baum-Datum
				}
				#print $index." und ".$person_name_in_tree."\n";
				$person_csv_line[$index]=$person_csv_line[$index]."S".$i;
				$person_rtf_line[$index]=$person_rtf_line[$index]."S".$i;
				if ($person_date_in_tree < $person_date[$index]) {
					print "WARNUNG: Datum im letzten FB2ODG-Export ist neuer als im Stammbaum:\n";
					print "S".$i."\. ".$tree_fam_name[$i]." vom ".$tree_gen_date[$i]."\n";
					print "#".$index." tree: ".$person_date_in_tree." rtf: ".$person_date[$index]."\n";
					$person_csv_line[$index]=$person_csv_line[$index]."d";
					#$person_rtf_line[$index]=$person_rtf_line[$index]."d";
					$person_rtf_line[$index]=$person_rtf_line[$index]."a";
					$number_of_d[$i]+=1; 
				}
				if ($person_name_in_tree ne $person_name[$index]) {
					print "WARNUNG: Name im letzten FB2ODG-Export ist anders als im Stammbaum:\n";
					print "S".$i."\. ".$tree_fam_name[$i]." vom ".$tree_gen_date[$i]."\n";
					print "#".$index." tree: ".$person_name_in_tree." rtf: ".$person_name[$index]."\n";
					$person_csv_line[$index]=$person_csv_line[$index]."n";
					#$person_rtf_line[$index]=$person_rtf_line[$index]."n";
					$person_rtf_line[$index]=$person_rtf_line[$index]."a";
					$number_of_n[$i]+=1; 
				}
				$person_csv_line[$index]=$person_csv_line[$index].",";
				$person_rtf_line[$index]=$person_rtf_line[$index]." ";
			} else {
				#print "Zeile ohne Nummer, Name und Datum in Datei ".$tree_file_path[$i]."\n";
				#print $line;
				#exit;
			}
		}
		#print OUT $i." ".$tree_fam_name[$i]." ";
		#print OUT $tree_gen_date[$i]."\n";
		close(IN);
	}		

	# Write CSV Personen-Namen-File
	open(OUT, ">$filename1") || die "Can't open file $filename1 ($!)\n";
	for $i (1 .. $noi) {
		print OUT "\"".$person_name[$i]."\",".$person_csv_line[$i]."\n";
	}
	close(OUT);

	# Write Tree-Namen-File
	open(OUT, ">$filename2") || die "Can't open file $filename2 ($!)\n";
	print OUT "\"S-Nr.\",\"Stammbaum\",\"Datum\",\"Personen\",\"alte Namen\",\alte Daten\"\n";
	for $i (1 .. $noft) {
		#print OUT $tree_file_path[$i]."\n";
		print OUT "S".$i.",";
		print OUT $tree_fam_name[$i].",";
		print OUT $tree_gen_date_format[$i].",";
		print OUT $number_of_i[$i].",";
		print OUT $number_of_n[$i].",";
		print OUT $number_of_d[$i]."\n";
	}		
	close(OUT);

}

sub putTreeDataIntoRTF {
	my $filename1 = shift; # RTF-Datei
	my $filename2 = shift; # RTF-AusgabeDatei
	my $line;
	my $index;
	my $i;
	my $switch_im_namensindex=0;
	my $line_printed=0;
	my $index_found=0;
	
	
	open(IN,  "<$filename1") || die "Can't open file $filename1 ($!)\n";
	open(OUT, ">$filename2") || die "Can't open file $filename1 ($!)\n";
	$switch_im_namensindex=0;
	while(<IN>) {
		$line = $_;
		$line_printed=0;

		# Ende des Namensindex
		if ($switch_im_namensindex == 1) {
			#mit der naechsten Ueberschrift endet der Namensindex
			if ( $line =~ m/^\{\\s6 .*/ ) {
				$switch_im_namensindex=0;
				print "switch_im_namensindex = 0\n";
			}
			if ( $line =~ m/^\{\\s5 .*/ ) {
				$switch_im_namensindex=0;
				print "switch_im_namensindex = 0\n";
			}
		}
		# NAMENSINDEX gefunden
		if ( $line eq "{\\s6 Namensindex aller Personen\\par}\n" ){
		$switch_im_namensindex = 1;
		print "switch_im_namensindex = 1\n";
		}
		# SUCHE BEFINDET SICH MOMENTAN IM NAMENSINDEX hier Stammbaumnummern hinzufuegen
		if ($switch_im_namensindex == 1) {
			#print "Test \n";
			# Index-Nummer gefunden
			if ( $line =~ m/^ #([0-9]+)/ ) {
				$index_found=1;
				#print "index_found=1 in $index \n";
				$index = $1;
			}
		}
		# MOMENTAN IM NAMENSINDEX hier Stammbaumnummern hinzufuegen
		if (($switch_im_namensindex == 1) && ($index_found == 1)) {
			# Stammbaumausgabe ans Ende der Zeile vor \par}
			if ( $line =~ m/^\\par\}/ ) {
				$index_found=0;
				print OUT " ".$person_rtf_line[$index]."\n";
			}
		}
		# STAMMBAUM INDEX vor dem Herkunftsindex ausgeben.
		if ( $line eq "{\\s6 Herkunftsindex\\par}\n" ){
			# Ausgabe der Stammbaum Referenzen
			print OUT "{\\s6 Stammbaumindex\\par}\n";
			for $i (1 .. $noft) {
				print OUT "{\\s3 S".$i."   ".$tree_fam_name[$i]." ";
				print OUT "vom ".$tree_gen_date_format[$i]."\\par}\n";
			}		
		}
		if ( $line eq "\\u0091(x\\u0093):\\tab Herkunftsreferenz-Nummer\\par\n" ) {
			# Legende am Beginn ergaenzen hinter Herkunft-Refeneznummer
			print OUT $line;
			$line_printed=1;
			print OUT "Sx :\\tab x=Stammbaum-Nummer\\par\n";
			print OUT "Sxa :\\tab Stammbaum-Daten \\'e4ltern als hier\\par\n";
		}
		# Wenn die Zeile noch nicht ausgegeben wurde
		if ( $line_printed == 0) {
			print OUT $line;
		}
		#print "ende1\n";
	}
	#print "ende\n";
	close IN;
	close OUT;
	
}

