# Usage:
#   utf16to8.pl infile > outfile
#
# by Ruediger Arnold, 09.03.2011


use strict;
use warnings;

my $filename1;
my $filename2;

$filename1 = shift;
$filename2 = shift;

binmode(STDOUT, ':raw');

# Assumes the presence of a BOM (Bit Order Marker, FFFF or FFFE).
#open(IN, "<:raw:encoding(UTF-16)", $filename1)
open(IN1, "<:raw", $filename1)
	or die("Can't open $filename1 $!\n");
while (<IN1>) {
	print $_;
}
close(IN1);

open(IN2, "<:raw", $filename2)
	or die("Can't open $filename2 $!\n");
while (<IN2>) {
	print $_;
}
#close(IN2);

#raw is needed to disable the crlf layer if present. 
#It would corrupt the data on the UTF-16 side, and 
#the UTF-8 sides needs it to mirror the UTF-16 side. 
