##############################################################################
# Author        : Ruediger Arnold
# Date          : 23.01.2015 
# Description   : Construct the tree from generation info file and box size file
# Category      : Parser
#############################################################################
#               : 
#               : initial
#               : 05.01.2012 changed position file
#               : 06.06.2012 added skew into connector description
#               : 25.09.2012 Persons in Tree List Added
#		: 10.10.2012 More Frames added
#               : 25.03.2013 Pictures added
#               : 17.04.2013 Replace the MAC ":" Pathdivider in the Picture Path
#		: 27.04.2013 Added moreText Option
#		: 04.06.2013 Added Index-Error Comment at Resolution Reading
#		: 01.07.2013 Allows "Umlaute" in Dateinamen und Pfaden
#		: 23.01.2015 Zusammenarbeit mit RTF-Files
#               :
##############################################################################

use strict;
use List::Util qw[min max];  # stellt die Minimum und Maximum Funktion zur Verfuegung
#use warnings;


# Variables from init.txt file, here default values

my $noi=200;               # number of indexes
my $nob=20;                # maximum number of branches from one index to other indexes
my $nom=100;               # number of marriages
my $noc=0;                 # number of connectors
my @inrConStart;           # array of start connectors
my @inrConStop;            # array of stop connectors
my @conFamDefInr;          # define to which family the connector belongs, index number of marriage of parents
my @conType;               # array of connector type: =1: from children to marriage symbole =2: from parent to marriages symbol
my @conPlaced;             # placed position of each connector
my @conMaxCnt;             # maximum count of connectors in the generation of this connector
my %conGenHash;            # hash of Generation, where the connector occurs
my %conGenMaxCntHash;      # maximum parallel connectors in this generation
my %conYstartHash;         # start Y position of family connector
my %conYstopHash;          # stop Y position of family connector
my %conPlacedOrderHash;    # indicates at which position < family connector is placed
my %conGenParentHash;            # hash of Generation, where the connector occurs
my %conGenMaxCntParentHash;      # maximum parallel connectors in this generation
my %conYstartParentHash;         # start Y position of family connector
my %conYstopParentHash;          # stop Y position of family connector
my %conPlacedOrderParentHash;    # indicates at which position < family connector is placed

my $deltaX = 3;            # space between generation levels in X-Direction [cm] 
my $deltaYmar = 0.2;       # space between frames in Y-Direction between couple [cm]
my $deltaYbrosis = 0.4;    # space between frames of sisters and brothers in Y-Direction [cm]
my $deltaYfam = 2.0;       # space between frames at family borders in Y-Direction [cm]
my $stickYmar = "yes";       # stick together the husband and wife in Y-Direction [yes/no]
my $stickYbrosis = "yes";    # stick together bothers, sisters and bothers-in-law and sisters-in-las in [yes/no]
my $stickYfam = "no";        # stick together different families in Y-Direction [yes/no]
my $movementLoop = "MBBT";   # number of optimization movement loops. Reasonable Values [1, 2, 3, ...]
my $treeOrientation = "yo";  #
my $treeOriFac = +1;         #
my $zeroX = 2;             # start point of the tree in X-Direction [cm]
my $zeroY = 2;             # start point of the tree in Y-Direction [cm]
my $marriageX = 0.6;       # size of the marriage symbol in X direction [cm]
my $marriageY = 0.6;       # size of the marriage symbol in Y direction [cm]
my $marriageXdelta = 0.6;  # distance of mariage symbol from parents in X direction
my $distCon = 0.2;         # distance between connectors
my $gridFactor =5;         # grid_factor: rounding of the frame boxes to 1/grid_factor in [cm] 
my $picPos = "none";       # positition of the picture (none, top, bottom, left, right)
my $picMaxHeight = 4;     # maximum height of the picture
my $picMaxWidth = 3;      # maximum width of the picture [cm]
my %picPathHash;          # pathname of the picture
my %picPathHrefHash;      # pathname of the picture, but as hyperlink for OO with / as Trenner, not \
my %picFileNameHash;      # filename of the picture
my %picXPosHash;          # X Position of the pictures [cm]
my %picYPosHash;          # Y Position of the picture [cm]
my %picXSizeHash;         # X size of the picture [cm]
my %picYSizeHash;         # Y size of the picture [cm]
my %picCutTopHash;        # cut on the top [cm]
my %picCutLeftHash;       # cut on the left[cm]
my %picCutBottomHash;     # cut on the bottom [cm]
my %picCutRightHash;      # cut on the right [cm]

my $dXchanChild;        # width of rounting channel for connectors between children and marriage symbol
my $dXchanParent;        # width of rounting channel for connectors between parents and marriage symbol

my $startGluePoint=3;  # Start Glue Point from elder generation: 1: right,2: bottom, 3: left, 4:top 
my $stopGluePoint=1;   # Start Glue Point to younger generation: 1: right,2: bottom, 3: left, 4:top 

my $fnContentExample = "content_example.xml"; # content.xml file of the example tree
my $fnContent = "content.xml";  # content.xml file for the new tree
my $fnStylesExample = "styles_example.xml"; # styles.xml file of the example tree, where the page size is defined
my $fnStyles = "styles.xml";  # styles.xml file for the new tree, where the new page size is defined
my $fnManifestExample = "manifest_example.xml"; # content.xml file of the example tree
my $fnManifest = "manifest.xml"; # content.xml file of the example tree

# Variables for Tree Construction

my $frameWidthAll = 0; # frame witdh (X-direction) of all frames, frame of index 1 is defining this value.
my $genMax;	 # highest generation No.
my $genMin;	 # lowest generation No.
my $nog;	 # number of generations
my @genYpos;	 # Actual Placement Y Position for each generation
my @genXpos;	 # Actual Placement X Position for each generation
my @genInrSum;   # Sum of all indexes in a generation row
my @genMarSum;   # Sum of all marriges in a generation row
my @genInrCnt;   # Actual Counter Value of placed persons in a generation row
my @genHasPic;   # Indicates, that in a generation, there are persons with fotographs
my @genPlcInr;   # [$i][$j], two dim array for placed index numbers, $i=generation, $j=position in the generation
my @genPlcMar;   # [$i][$j], two dim array for placed marriage numbers, $i=generation, $j=position in the generation
my @inrXsize;    # X-Size of frame for each index number
my @inrYsize;	 # Y-Size of frame for each index number
my @inrXpos;	 # X-Position of the frame
my @inrYpos;	 # Y-Position of the frame
my @inrLLim;     # Kind of Limit in  Left Direction
my @inrRLim;     # Kind of Limit in Right Direction
                 # Values for Limit Variables inrLLim and inrRLim
                 # "initialBorder": not defined, free
                 # "marriageBorder": marriage
                 # "brotherSisterBorder": brother or sister
                 # "brotherSisterInLawBorder": brother or sister in law
                 # "familyBorder": family border
my @inrTopPad;   # Padding at the Top
my @inrBotPad;# Padding at the Bottom
my @inrLeftPad;  # Padding at the Left
my @inrRightPad; # Padding at the Right
my @inrPicYesNo; # shows if a frame will be prepared for a picture, and if a picture will be placed

my %furtherHash;         # indicates, which person will have a "further"-frame or "more"-frame, instead of its normal frame.
my %furtherTextHash;        # indicates, which person will have a "further"-frame or "more"-frame, instead of its normal frame.
my $furtherXsize;        # X-Size of the "further"-Frames
my $furtherYsize= 2.0;   # Y-Size of the "further"-Frames
my $extraMoreY= 1.0;     # Extra Height for More-Frame, for extra space for Text

my %marriageHash; # Hash Table for Marriages related to ODG frame IDs
my @inrHusbandMarriage;   # Husband index number of n'th marriage
my @inrWifeMarriage;      # Wife index number of n'th marriage
my @marriageGen;          # Generation of a marriage (symbol)
my @inrFather;            # Father of index
my @inrMother;            # Mother of index
my @inrWife;              # [$inr][$j] two dimensional array of available wifes for an index, =0 => no wife
my @inrHusband;           # [$inr][$j] two dimensional array of available husbands for an index, =0 => no husband
my $partnerShipSymbol;    # Should be "o-o" or ""
my %partnerShipHash;      # Hash Table for Partnership related to ODG frame IDs

my @inrGen;	    # Generation for each index number, if a person is not placed, the value is "not_in_tree"
my @inrDist;        # Distance from start person to index person
my @inrUpDown;      # Up and Downs from start person to index person
my @inrDownUp;      # Down and Ups from start person to index person
my @inrSideStep;    # Side Steps from start person to index person
my @inrSide;        # Side of the tree -1: side of start husband, 1: side of start wife, 0: children of the couble
my @inrPlacement;   # Preplacement number of each index, as higher the number, as more distant from the start persons.
my @inrA2P;         # if ==0 then person is not attached to any partner; if not = 0 then it shows the index number of the partner attached to
my @inrFam;         # familily code, normally marriage or single parrent, attached partners get the code the partners
my @inrPlacedInGenRow; # =1: indicates, that a person is already placed in a generation row, or is not in the tree

# Variables for Frame Placement Optimization

my @flexInr;         # Index numbers of to be moved items
my @fixYpos;         # Y-Position of where the flex items are pulled to
my @inrTension;      # mechanical tension after the index
my @parentsYpullAvg; # Average value of the children, pulling their parents to this point
my @parentsYpullCnt; # Count Value of Children, pulling a parent
my $maxYpos;     # Maximum length of any column [cm]
my $maxYposGen;  # Generation with the maximum length

# Variables for ODG File Analysis

my $wordOdg1;
my $wordOdg1Start;
my $wordOdg1StartHelper;
my $wordOdg1Mitte;
my $wordOdg1End;
my $wordOdg2;
my $wordOdg3;
my $wordOdg4;
my $wordOdg5;

my $lineHeadContent;

my $wordFrameStart;
my $wordFrameCore;
my $wordFrameStop;
my $wordFrameId;
my $frameId;
my $wordFrameIdXml;
my $frameIdXml;
my $wordFrameStyle;
my $frameStyle;
my $wordFrameWidth;
my $frameWidth;
my $wordFrameHeight;
my $frameHeight;
my $wordFrameXpos;
my $frameXpos;
my $wordFrameYpos;
my $frameYpos;
my $wordFrameEnd;
my $wordFrameParagraphStyle;
my $wordFramePrerufStyle;
my $wordFrameTextEnd;
my $wordFrameParagraphEnd;
my $wordFrameRufStyle;
my $wordFrameRestStyle;
my $wordFrameIndexNummerStyle;

my $wordFrameStyleStart;
my $wordFrameStyleMinHeight;
my $frameStyleMinHeight;
my $wordFrameStyleTopPadding;
my $frameStyleTopPadding;
my $wordFrameStyleBotPadding;
my $frameStyleBotPadding;
my $wordFrameStyleLeftPadding;
my $frameStyleLeftPadding;
my $wordFrameStyleRightPadding;
my $frameStyleRightPadding;
my $wordFrameStyleEnd;


my $wordFrameMoreStart;
my $wordFrameMoreCore;
my $wordFrameMoreStop;
my $wordFrameMoreId;
my $frameMoreId;
my $wordFrameMoreIdXml;
my $frameMoreIdXml;
my $wordFrameMoreStyle;
my $frameMoreStyle;
my $wordFrameMoreWidth;
my $frameMoreWidth;
my $wordFrameMoreHeight;
my $frameMoreHeight;
my $wordFrameMoreXpos;
my $frameMoreXpos;
my $wordFrameMoreYpos;
my $frameMoreYpos;
my $wordFrameMoreEnd;

#my $wordFrameMoreParagraphStyle;
#my $wordFrameMorePrerufStyle;
#my $wordFrameMoreTextEnd;
#my $wordFrameMoreParagraphEnd;
#my $wordFrameMoreRufStyle;
#my $wordFrameMoreRestStyle;
#my $wordFrameMoreIndexNummerStyle;

my $wordFrameMoreStyleStart;
my $wordFrameMoreStyleMinHeight;
my $frameMoreStyleMinHeight;
my $wordFrameMoreStyleTopPadding;
my $frameMoreStyleTopPadding;
my $wordFrameMoreStyleBotPadding;
my $frameMoreStyleBotPadding;
my $wordFrameMoreStyleLeftPadding;
my $frameMoreStyleLeftPadding;
my $wordFrameMoreStyleRightPadding;
my $frameMoreStyleRightPadding;
my $wordFrameMoreStyleEnd;


my $wordMarriageStart;
my $wordMarriageCore;
my $wordPartnerShipCore;
my $wordMarriageStop;
my $wordMarriageId;
my $marriageId;
my $wordMarriageIdXml;
my $marriageIdXml;
my $wordMarriageStyle;
my $marriageStyle;
my $wordMarriageWidth;
my $marriageWidth;
my $wordMarriageHeight;
my $marriageHeight;
my $wordMarriageXpos;
my $marriageXpos;
my $wordMarriageYpos;
my $marriageYpos;
my $wordMarriageEnd;

my $wordFurtherStyle;
my $furtherStyle;
my $wordFurtherYpos;
my $furtherYpos;
my $wordFurtherXpos;
my $furtherXpos;
my $wordFurtherHeight;
my $furtherHeight;
my $wordFurtherWidth;
my $furtherWidth;
my $wordFurtherId;
my $furtherId;
my $wordFurtherIdXml;
my $furtherIdXml;
my $wordFurtherText;
my $furtherText;
my $wordFurtherEnd;


my $wordConnectorStart;
my $wordConnectorCore;
my $wordConnectorStop;
my $wordConDef;
my $wordConX1;
my $conX1;
my $wordConY1;
my $conY1;
my $wordConX2;
my $conX2;
my $wordConY2;
my $conY2;
my $wordConStartSh;
my $conStartSh;
my $wordConStartShGl;
my $conStartShGl;
my $wordConStopSh;
my $conStopSh;
my $wordConStopShGl;
my $conStopShGl;
my $wordConPath;
my $conPath;
my $wordConSkew;
my $conSkew;
my $wordConEnd;

my $wordTitleStart;
my $wordTitleStop;
my $wordDateStart;
my $wordDateStop;
my $wordSourceStart;
my $wordSourceStop;
my $wordGenerationStartX;
my $wordGenerationMiddle;
my $wordGenerationStop;

my $lineHeadStyles;
my $wordPageHeight;
my $wordPageWidth;
my $wordPageEnd;
my $pageHeight;
my $pageWidth;

my $wordManifest;

my $titleText;
my $furtherText;
my $dateText;
my $dateTextStart;
my $dateTextDatum;
my $dateTextStop;
my $sourceText;
my $descendantText;
my $ancestorText;
my @generationText;
my $generationTextXpos;
my $foundGenerationNames = 0;
my $nameHusband;
my $nameWife;

my $sec;
my $min;
my $hour;
my $mday;
my $mon;
my $year;
my $wday;
my $yday;
my $isdst;

# Variables for Read in for Person Data File For Tree Generation
my @personData;
my @imaxArray;
my $imax;
my $indexNr;
my $indexNrMaxOld;

###################################
# main routine
###################################
if ($#ARGV == 13) {

	&constructTreeUnzipOdg; ## Unpack example_tree.odg

	&analyseTreeOdgContent;

	&initializeData($ARGV[0],$ARGV[1],$ARGV[2],$ARGV[3],$ARGV[4],$ARGV[5],$ARGV[7],$ARGV[8],$ARGV[9],$ARGV[11]);

	&groupFamilies;

	&defineRowPlacement($ARGV[6]);
	
	&optimize_frame_position_preparation;

	&optimize_frame_position;

	&collect_connectors;

	&connectors_ordering;

	&constructTree;

	&constructTreeZipOdg; ## Pack example_tree.odg

	&constructTreeCleanUp; ## Delete Work Directories

	&printPersonList($ARGV[13],$ARGV[10],$ARGV[12]);

	&checkHusWifSameGen;

	exit;

	}	

else {
	print "*****************************************************************************************************************************************************************\n";
	print "usage: $0 <tree_scaling> <data_file_start_names> <data_file_noi_nob> <data_file_frame_height> <data_file_position> <data_file_row_placement> <data_file_marriages> <data_file_connectors>\n";
	print "*****************************************************************************************************************************************************************\n";
	exit;
}		

###################################
# subroutines
###################################

sub initializeData {

	print "**** \n";
	print "**** Read in ConfigurationData\n";
	print "**** \n";

	my $fnTreeScaling = shift;
	my $fnDataFileStartNames = shift;
	my $fnDataFileNoiNob = shift;
	my $fnDataFileFrameHeight = shift;
	my $fnDataFilePosition = shift;
	my $fnDataFileMarriages = shift;
	my $fnDataFileConnectors = shift;
	my $fnTreeForm = shift;
	my $filenamePersonDataFileForTreeGen = shift;
	my $fnDataFilePictures = shift;
	my $line;
	my $inr;
	my $gen;
	my $xSize;  # x width of the frames
	my $ySize;  # y height of the frames
	my $hashEntry;
	my $j;
	my $i;
	my $text;
	my $picXsizePx;
	my $picYsizePx;
	my $picXresDpi;
	my $picYresDpi;
	my $picXCut0Px;
	my $picYCut0Px;
	my $picXCutSizePx;
	my $picYCutSizePx;

	## read data_file_noi_nob.txt
	open(IN, "<$fnDataFileNoiNob") || die "Can't open file $fnDataFileNoiNob ($!)\n";
	$line = <IN>;
	$line =~ m/(\d*) .*/; 
	$noi = $1; 
	print "noi ".$noi."\n";
	$line = <IN>;
	$line =~ m/(\d*) .*/; 
	$nob = $1; 
	print "nob ".$nob."\n";
	close(IN);

	## Read In Person Data For Tree Generation
	print "**** \n";
	print "**** Reading in Tree Person Data File. \n";
	print "**** \n";
	$indexNrMaxOld = 0;
	open(IN, "<$filenamePersonDataFileForTreeGen") || die "Can't open file $filenamePersonDataFileForTreeGen ($!)\n";
	while(<IN>) {			
		$line = $_;
		if ($line =~ m/SOI/) {
			# Finding start of index (SOI)
			$line = <IN>;
			$line =~ m/(\S*)/;
			$indexNr = $1;
			print "***** Finding in old data start of person Nr.".$indexNr." (SOI)\n";

			# Reading the Name, which always will be there
			$line = <IN>; 
			$line =~ m/(.*)\n/;
			$personData[$indexNr][1] = $1;
			# print $personData[$indexNr][1]." Preruf\n";
			$line = <IN>; 
			$line =~ m/(.*)\n/;
			$personData[$indexNr][2] = $1;
			# print $personData[$indexNr][2]." Ruf\n";
			$line = <IN>; 
			$line =~ m/(.*)\n/;
			$personData[$indexNr][3] = $1;
			# print $personData[$indexNr][3]." Postruf\n";
			$line = <IN>; 
			$line =~ m/(.*)\n/;
			$personData[$indexNr][4] = $1;
			print $personData[$indexNr][4]." Nachname\n";

			# Reading further information of the person
			$line = <IN>; 
			$line =~ m/(.*)\n/;
			$line = $1;  # without newline
			$i = 5;
			while ($line ne "EOI") { # not yet reached End Of Index
				$personData[$indexNr][$i] = $line;
				# print $personData[$indexNr][$i]." Eintrag Nr.".$i."\n";
				$i = $i + 1;
				#if ( $i > 11 ) { die; };
				$line = <IN>; 
				$line =~ m/(.*)\n/;
				$line = $1;  # without newline
			}
			$imaxArray[$indexNr] = $i - 1;		# Anzahl der Einträge einer Person
			if ( $indexNrMaxOld < $indexNr ) {	# Nummer mit dem höchsten Index
				$indexNrMaxOld = $indexNr;
			}

			#print "***** Finding end of old person Nr.".$indexNr." (EOI)\n";
		}
	}
	close(IN);

	## read data_init_tree.txt
	open(IN, "<$fnTreeScaling") || die "Can't open file $fnTreeScaling ($!)\n";
	$line = <IN>; # reading title, first line, to get ride of an evtl. added BOM for UTF-8
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *deltaX  *.*/ ) {
		$deltaX = $1;
		print "deltaX ".$deltaX."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at deltaX \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *deltaYmar  *.*/ ) {
		$deltaYmar = $1;
		print "deltaYmar ".$deltaYmar."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at deltaYmar \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *deltaYbrosis  *.*/ ) {
		$deltaYbrosis = $1;
		print "deltaYbrosis ".$deltaYbrosis."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at deltaYbrosis \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *deltaYfam  *.*/ ) {
		$deltaYfam = $1;
		print "deltaYfam ".$deltaYfam."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at deltaYfam \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *stickYmar  *.*/ ) {
		$stickYmar = $1;
		print "stickYmar ".$stickYmar."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at stickYmar \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *stickYbrosis  *.*/ ) {
		$stickYbrosis = $1;
		print "stickYbrosis ".$stickYbrosis."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at stickYbrosis \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *stickYfam  *.*/ ) {
		$stickYfam = $1;
		print "stickYfam ".$stickYfam."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at stickYfam \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^[BMT]{2,})  *movementLoop  *.*/ ) {
		$movementLoop = $1;
		print "movementLoop ".$movementLoop."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at movementLoop \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^[yo]{2}) *treeOrientation *.*/ ) {
		$treeOrientation = $1;
		print "treeOrientation ".$treeOrientation."\n";
		if ( $treeOrientation eq "yo" ) {
			$treeOriFac = +1;  # young left, old right
			$startGluePoint=3;  # Start Glue Point from elder generation: 1: right,2: bottom, 3: left, 4:top 
			$stopGluePoint=1;   # Start Glue Point to younger generation: 1: right,2: bottom, 3: left, 4:top 
		} else {
			$treeOriFac = -1;  # young right, old left
			$startGluePoint=1;  # Start Glue Point from elder generation: 1: right,2: bottom, 3: left, 4:top 
			$stopGluePoint=3;   # Start Glue Point to younger generation: 1: right,2: bottom, 3: left, 4:top 
		}
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at treeOrientation \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *zeroX  *.*/ ) {
		$zeroX = $1;
		print "zeroX ".$zeroX."\n";
		$zeroX = $zeroX + 1.0; # add Offset
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at zeroX \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *zeroY  *.*/ ) {
		$zeroY = $1;
		print "zeroY ".$zeroY."\n";
		$zeroY = $zeroY + 1.0; # add Offset
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at zeroY \n";
		exit;
	}
#	$line = <IN>;
#	if ( $line =~ m/(^.*?)  *marriageX  *.*/ ) {
#		$marriageX = $1;
#		print "marriageX ".$marriageX."\n";
#	} else {
#		print " **** ERROR Wrong format in file ".$fnTreeScaling." at marriageX \n";
#		exit;
#	}
#	$line = <IN>;
#	if ( $line =~ m/(^.*?)  *marriageY  *.*/ ) {
#		$marriageY = $1;
#		print "marriageY ".$marriageY."\n";
#	} else {
#		print " **** ERROR Wrong format in file ".$fnTreeScaling." at marriageY \n";
#		exit;
#	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *marriageXdelta  *.*/ ) {
		$marriageXdelta = $1;
		print "marriageXdelta ".$marriageXdelta."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at marriageXdelta \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *furtherY  *.*/ ) {
		$furtherYsize = $1;
		print "furtherY ".$furtherYsize."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at furtherY \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *extraMoreY  *.*/ ) {
		$extraMoreY = $1;
		print "extraMoreY ".$extraMoreY."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at extraMoreY \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *distCon  *.*/ ) {
		$distCon = $1;
		print "distCon ".$distCon."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at distCon \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *gridFactor  *.*/ ) {
		$gridFactor = $1;
		print "gridFactor ".$gridFactor."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at gridFactor \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *picPos  *.*/ ) {
		$picPos = $1;
		print "picPos ".$picPos."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at picPos \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *picMaxHeight  *.*/ ) {
		$picMaxHeight = $1;
		print "picMaxHeight ".$picMaxHeight."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at picMaxHeight \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *picMaxWidth  *.*/ ) {
		$picMaxWidth = $1;
		print "picMaxWidth ".$picMaxWidth."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at picMaxWidth \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *furtherText/ ) {
		$furtherText = $1;
		print "furtherText ".$furtherText."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at furtherText \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *titleText/ ) {
		$titleText = $1;
		print "titleText ".$titleText."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at titleText \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?) *dateText/ ) {
		$dateText = $1;
		print "dateTextRaw ".$dateText."\n";
		if ( $dateText =~ m/(.*)(DATUM1)(.*)/ ) { # DATUM1 Platzhalter gefunden
			$dateTextStart = $1;
			$dateTextDatum = $2;
			$dateTextStop = $3;
			#print "dateTextStart ".$dateTextStart."\n";
			#print "dateTextDatum ".$dateTextDatum."\n";
			#print "dateTextStop ".$dateTextStop."\n";
			($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime();
			$mon = $mon + 1;
			if ( $mon < 10 ) {
				$mon = "0".$mon;
			}
			if ( $mday < 10 ) {
				$mday = "0".$mday;
			}
			$year=$year+1900;
			$dateText=$dateTextStart.$mday.".".$mon.".".$year.$dateTextStop;
		}
		$dateText =~ s/</&lt;/g ;  # ersetzt <, > und & durch Kuerzel
		$dateText =~ s/>/&gt;/g ;  # ersetzt <, > und & durch Kuerzel
		$dateText =~ s/&/&amp;/g;  # ersetzt <, > und & durch Kuerzel
		print "dateText ".$dateText."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at dateText \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *sourceText/ ) {
		$sourceText = $1;
		$sourceText =~ s/</&lt;/g ;  # ersetzt <, > und & durch Kuerzel
		$sourceText =~ s/>/&gt;/g ;  # ersetzt <, > und & durch Kuerzel
		$sourceText =~ s/&/&amp;/g;  # ersetzt <, > und & durch Kuerzel
		print "sourceText ".$sourceText."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at sourceText \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *descendantText/ ) {
		$descendantText = $1;
		print "descendantText ".$descendantText."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at descendantText \n";
		exit;
	}
	$line = <IN>;
	if ( $line =~ m/(^.*?)  *ancestorText/ ) {
		$ancestorText = $1;
		print "ancestorText ".$ancestorText."\n";
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." at ancestorText \n";
		exit;
	}

	# checking width of rounting channels

	$dXchanChild = $deltaX - $marriageX - $marriageXdelta;
	print "Routing Channel Width for Children: ".$dXchanChild."\n";
	$dXchanParent = $marriageXdelta;
	print "Routing Channel Width for Parents: ".$dXchanParent."\n";

	if ($dXchanChild - 5.99*$distCon < 0) {
		print "**** Error: No Space for rounting the connectors between CHILDREN and marriage symbol! \n";
		exit;
	}
	if ($dXchanParent - 5.99*$distCon < 0) {
		print "**** Error: No Space for rounting the connectors between PARENTS and marriage symbol! \n";
		exit;
	}
		
	close(IN);

	# read in the names of the start persons and modify the title text

	open(IN, "<$fnDataFileStartNames") || die "Can't open file $fnDataFileStartNames ($!)\n";
	$line = <IN>;
	if ($line =~ m/(.*)/) { # remove return
		$nameHusband = $1;
		print "Husbandname: ".$nameHusband;
	}
	$line = <IN>;
	if ($line =~ m/(.*)/) { # remove return
		$nameWife = $1;
		print "Wifename: ".$nameWife;
	}
	close(IN);
	if ( $titleText =~ m/(.*)(NAME1)(.*)(NAME2)/ ) { # analysis Title
		$titleText = $1.$nameHusband.$3.$nameWife;
		$titleText =~ s/</&lt;/g ;  # ersetzt <, > und & durch Kuerzel
		$titleText =~ s/>/&gt;/g ;  # ersetzt <, > und & durch Kuerzel
		$titleText =~ s/&/&amp;/g;  # ersetzt <, > und & durch Kuerzel
	} else {
		print " **** ERROR Wrong format in file ".$fnTreeScaling." in titleText, no NAME1, no NAME2 \n";
		exit;
	}
		
	print "**** Initialize Arrays \n";
	for $i (0..$noi) {     # Index =0 means unknown person, so it is as default "not_in_tree"
		$inrGen[$i] = "not_in_tree"; # also person 0 = unknown person is "not_in_tree"
		$inrXsize[$i] = 0;
		$inrYsize[$i] = 0;
		$inrXpos[$i] = 0;
		$inrYpos[$i] = 0;
		$inrLLim[$i] = "initialBorder";
		$inrRLim[$i] = "initialBorder";
		$inrPicYesNo[$i] = "no"; # that means do not prepare the frame for a picture
	}

	print "**** Read in the Tree Position of each index\n";

	open(IN, "<$fnDataFilePosition") || die "Can't open file $fnDataFilePosition ($!)\n";
	$genMax = -9999;
	$genMin = +9999;
	while(<IN>) {			
		$line= $_;
		if ( $line =~ m/INR (\d*) GEN (.*?) DIST (\d*) UD (\d*) DU (\d*) SS (\d*) SIDE (-*\d*) PLC (\d*) A2P (\d*)/ ) {
			$inr = $1;
			$gen = $2;
			$inrGen[$inr] = $gen;
			$inrDist[$inr] = $3;
			$inrUpDown[$inr] = $4;
			$inrDownUp[$inr] = $5;
			$inrSideStep[$inr] = $6;
			$inrSide[$inr] = $7;
			$inrPlacement[$inr] = $8;
			$inrA2P[$inr] = $9;
			$inrPlacedInGenRow[$inr] = 0;   # person not placed
		} else {
			print $line."\n";
			print "**** ERROR Wrong format in file ".$fnDataFilePosition."\n";
			exit;
		}
		if ($gen eq "not_in_tree") {
			#print "  **** Person ".$inr." is not in the tree.\n";
			$inrPlacedInGenRow[$inr] = 1;   # a person not in the tree counts as placed
		} else {
			if ($genMax < $gen) {
				$genMax = $gen;
			}
			if ($genMin > $gen) {
				$genMin = $gen;
			}
		}
	}
	close(IN);

	print "side 1 ".$inrSide[1]."\n";
	print "side 4 ".$inrSide[4]."\n";
	
	print "Maximum Generation: ".$genMax." \n";
	print "Minimum Generation: ".$genMin." \n";

	print "**** Initialize Generation Y-Position \n";

	$nog = $genMax - $genMin + 1; # number of generations
	print "Number of Generations: ".$nog."\n";

	for $i (1..$nog) {
		$genYpos[$i] = $zeroY;
		$genXpos[$i] = $zeroX;
		$genInrSum[$i] = 0;
		$genInrCnt[$i] = 0;
		$genHasPic[$i] = "no";
		if ($i+$genMin-1 < 0) { # Descendant Direction
			$j = -$i-$genMin+1;
			$generationText[$i] = $j.". ".$descendantText;
		}
		if ($i+$genMin-1 > 0) { # Ancestor Direction
			$j = $i+$genMin-1;
			$generationText[$i] = $j.". ".$ancestorText;
		}
	}


	## read data_init_tree.txt again for special generation names as for example Eltern, Enkel, etc.
	open(IN, "<$fnTreeScaling") || die "Can't open file $fnTreeScaling ($!)\n";
	$line = <IN>; # reading title, first line, to get ride of an evtl. added BOM for UTF-8
	while (<IN>) {
		$line = $_;
			if ( $line =~ m/(^.*?)  *generationText  *(-*\d)/ ) { # found generation text
				$text = $1;
				$i = $2;
				print "Generation-Name: ".$i." ".$text."\n";
				if ( ($i >= $genMin) && ($i <= $genMax) ) { # generation $i is in the tree
					$generationText[$i-$genMin+1] = $text; # load special names for some generations
					$foundGenerationNames = 1;
				}
			}
	}
	if ( $foundGenerationNames == 0) {
		print "****ERROR: Found no Generation Names in file ".$fnTreeScaling."\n";
		exit;
	}


	# count the persons per generation	
	for $i (1..$noi) {
		if ($inrGen[$i] eq "not_in_tree") {
			#print "**** During Person Count: ".$i." is not in the tree.\n";
		} else {
			$genInrSum[$inrGen[$i]-$genMin+1] = $genInrSum[$inrGen[$i]-$genMin+1] + 1;
		}
	}
	for $i (1..$nog) {
		$gen = $i + $genMin -1;
		print "Generation ".$gen." has ".$genInrSum[$i]." persons.\n";
	}
	# set the placement array to initialize value
	for $i (1..$nog) {
		for $j (1..$genInrSum[$i]) {
			$genPlcInr[$i][$j] = 0;
		}
	}

	# SUCHE FURTHER-Frame-Persons and MORE-Frame-Persons

	## read tree_form.txt
	print "**** Read in tree_form.txt and looking for 'further'-symbols\n";

	open(IN, "<$fnTreeForm") || die "Can't open file $fnTreeForm ($!)\n";
	$line = <IN>; # reading title, first line, to get ride of an evtl. added BOM for UTF-8
	while(<IN>) {
		$line= $_;
		if ( $line =~ m/(^\d*)\s*further[ \s]+/ ) { # stop person found with "further" frame instead of the normal frame
			$i = $1;
			$furtherHash{$i} = "further"; 
		}
		if ( $line =~ m/(^\d*)\s*furtherText[ \s]+(.*)/ ) { # stop person found with "further" Text
			$i = $1;
			$furtherTextHash{$i} = $2; 
		}
		if ( $line =~ m/(^\d*)\s*more[ \s]+/ ) { # stop person found with "more" frame instead of the normal frame
			$i = $1;
			$furtherHash{$i} = "more"; 
		}
		if ( $line =~ m/(^\d*)\s*moreText[ \s]+(.*)/ ) { # stop person found with "more" Text
			$i = $1;
			$furtherTextHash{$i} = $2; 
		}
	}

	close(IN);

	print "**** Initialize Picture Data and check in which Generation are Pictures\n";
	
	$inrFather[0] = 0;
	$inrMother[0] = 0;

	open(IN, "<$fnDataFilePictures") || die "Can't open file $fnDataFilePictures ($!)\n";
	$line = <IN>;  # Read the Header of the file = filename
	while(<IN>) {
		$line= $_;	
		if ($line =~ m/(\d*) Index/) {  # Read the Index Number of the actual person
			$inr = $1;
			if ( $inrGen[$inr] ne "not_in_tree" ) { # person is in tree
				$inrPicYesNo[$inr] = "yes"; # Prepare the frame for a picture
			}
		} else {
			die "**** ERROR Wrong Format in ".$fnDataFilePictures." at Index Reading.\n";
		}

		print "**** Check in which Generation are pictures\n";
		if ( ($inrGen[$inr] ne "not_in_tree")&&($inrPicYesNo[$inr] eq "yes") ) { # Not in tree and not further-frame
			$genHasPic[$inrGen[$inr]-$genMin+1] = "yes";
		}

		$line = <IN>;  # Ready Document Name with Path
		
	        if ( $^O eq "MSWin32") {  # Window Operating System
	                print "Window Operating System at Data Path\n";
			if ( $line =~ m/(.+\\)(.+)/ )   { # Read the Picture Path and Name
				$picPathHash{$inr} = $1;
				$picFileNameHash{$inr} = $2;
				$picPathHrefHash{$inr} = $picPathHash{$inr};
				$picPathHrefHash{$inr} =~ s/\\/\//g;  # replace "\" with "/" in DOS system
			} else {
				die "**** ERROR Wrong Format in ".$fnDataFilePictures." at Index Reading.\n";
			}
	        } else {
			if ( $line =~ m/.*\:.*/ ) { # Here is MAC OS Datapath, which need to convert to Linux Data Path
				$line =~ s/\:/\//g;  # Replace the path divider ":" of MAC OS by Linux Path Divider "/"
				$line = "\/".$line;  # Add the Path divider for Linux also at the Beginning
				print "Neuer Pfad fuer MAC-OS: \n".$line;
			}
	                print "Linux Cygwin or MAC Operating System at Data Path\n";
			if ( $line =~ m/(.+\/)(.+)/ )   { # Read the Picture Path and Name
				$picPathHash{$inr} = $1;
				$picFileNameHash{$inr} = $2;
				$picPathHrefHash{$inr} = $picPathHash{$inr};
			} else {
				die "**** ERROR Wrong Format in ".$fnDataFilePictures." at Index Reading.\n";
			}
	        }

		$line = <IN>;  # Size
		if ( $line =~ m/(\d+) (\d+) xsize ysize/ )  { # Read the Index Number of the actual person
			$picXsizePx=$1;
			$picYsizePx=$2;
		} else {
			die "**** ERROR Wrong Format in ".$fnDataFilePictures." at Size Reading.\n";
		}
		$line = <IN>;  # Cutting
		if ($line =~ m/(\d+) (\d+) (\d+) (\d+) xcut0 ycut0 xcutsize ycutsize/) {  # Read Cutting Information
			$picXCut0Px = $1;
	 		$picYCut0Px = $2;
	 		$picXCutSizePx = $3;
	 		$picYCutSizePx = $4;
		} else {
			if ($line =~ m/    xcut0 ycut0 xcutsize ycutsize/) {  # No Cutting
				print "Info: Picture for Index ".$inr." without Cutting.";
				$picXCut0Px = 0;
	 			$picYCut0Px = 0;
	 			$picXCutSizePx = $picXsizePx;
	 			$picYCutSizePx = $picYsizePx;
			} else {
				die "**** ERROR Wrong Format in ".$fnDataFilePictures." at Cutting Reading.\n";
			}
		}
		$line = <IN>;  # Resolution
		if ($line =~ m/(\d+) (\d+) xres yres/) {  # Read Cutting Information
			$picXresDpi=$1;
			$picYresDpi=$2;
		} else {
			if ($line =~ m/  xres yres/) {  # No Resolution 
				print "Info: Picture for Index ".$inr." set default 96 dpi or 300 dpi.";
				if ($picFileNameHash{$inr} =~ m/.+\.png/) {
					# PNG Picture with 300 dpi
					$picXresDpi=96;
					$picYresDpi=96;
				} else { 
					if ($picFileNameHash{$inr} =~ m/.+\.PNG/) {
						# PNG Picture
						$picXresDpi=96;
						$picYresDpi=96;
					} else {
						# GIF Picture und andere mit 96 dpi
						$picXresDpi=96;
						$picYresDpi=96;
					}
				}
			} else {
				print "**** ERROR Wrong Format in ".$fnDataFilePictures." at Resolution Reading for Index ".$inr.".\n";
				exit;
			}
		}
		# Calculation of the Cutting of the Picture
		$picCutTopHash{$inr}    = $picYCut0Px / $picYresDpi * 2.54;
		$picCutLeftHash{$inr}   = $picXCut0Px / $picXresDpi * 2.54;
		$picCutRightHash{$inr}  = ($picXsizePx-$picXCut0Px-$picXCutSizePx) / $picXresDpi * 2.54;
		$picCutBottomHash{$inr} = ($picYsizePx-$picYCut0Px-$picYCutSizePx) / $picYresDpi * 2.54;
		# Debug Printing
		if ($inr == -9999) {
			print $picXsizePx." xsize\n";
			print $picYsizePx." ysize\n";
			print $picXCut0Px." xcut0\n";
			print $picYCut0Px." ycut0\n";
			print $picXCutSizePx." xcutw\n";
			print $picYCutSizePx." ycuth\n";
			print $picXresDpi." xres\n";
			print $picYresDpi." yres\n";
			print $picCutTopHash{$inr}." cutT\n";
			print $picCutLeftHash{$inr}." cutL\n";
			print $picCutRightHash{$inr}." cutR\n";
			print $picCutBottomHash{$inr}." cutB\n";
			exit;
		}

	 	if (($picXCutSizePx/$picMaxWidth) > ($picYCutSizePx/$picMaxHeight)) { # Verkleinerungsfaktoren
			# MaxWidth is limiting 
			$picXSizeHash{$inr} = $picMaxWidth;
			$picYSizeHash{$inr} = ($picYCutSizePx/$picYresDpi*2.54)/(($picXCutSizePx/$picXresDpi*2.54)/$picMaxWidth);
			#Rounding
			$picYSizeHash{$inr} = int($picYSizeHash{$inr} * ($gridFactor/2) + 0.9999) / ($gridFactor/2); # rounding always up to get the next size step of the frame
		} else {
			# MaxHeight is limiting 
			$picYSizeHash{$inr} = $picMaxHeight;
			$picXSizeHash{$inr} = ($picXCutSizePx/$picXresDpi*2.54)/(($picYCutSizePx/$picYresDpi*2.54)/$picMaxHeight);
			#Rounding
			$picXSizeHash{$inr} = int($picXSizeHash{$inr} * ($gridFactor/2) + 0.9999) / ($gridFactor/2); # rounding always up to get the next size step of the frame
		}
	}
	close(IN);

	# Make Picture Directory

	if ( $picPos ne "none" ) {
		# Pictures Verzeichnis anlegen
        	if ( $^O eq "MSWin32") {  # Window Operating System
  			print "Window Operating System \@ mkdir Pictures\n";
			system("mkdir \%\$workOdgDir\%Pictures");
		} else {
			print "Linux Cygwin or MAC Operating System \@ mkdir Pictures\n";
			system("mkdir \$workOdgDir\/Pictures");
		}
	}

	print "**** Read in Frame Height Information from Frame Generation\n";

	open(IN, "<$fnDataFileFrameHeight") || die "Can't open file $fnDataFileFrameHeight ($!)\n";
	while(<IN>) {			
		$line= $_;
		$line =~ m/(\d*?) (.*) (.*)/;
		$inr = $1;
		$xSize = $2;
		$ySize = $3;
		# Rounding The Frame Size to Double Grid
		print "Index: ".$inr." rounding";
		print "  X: ".$xSize." to ";
		$xSize = int($xSize * ($gridFactor/2) + 0.9999) / ($gridFactor/2); # rounding always up to get the next size step of the frame
		print $xSize;
		print "  Y: ".$ySize." to ";
		$ySize = int($ySize * ($gridFactor/2) + 0.9999) / ($gridFactor/2); # rounding alway up toe get the next size step of the frame
		print $ySize."\n";
		$inrXsize[$inr] = $xSize;
		$inrYsize[$inr] = $ySize;

		# Set default of Paddgings (top, bot, left, right)
		$inrTopPad[$inr]    = $frameStyleTopPadding; 
		$inrBotPad[$inr]    = $frameStyleBotPadding; 
		$inrLeftPad[$inr]   = $frameStyleLeftPadding; 
		$inrRightPad[$inr]  = $frameStyleRightPadding; 

		# Check which Frame is used (more / further)
		if ( defined $furtherHash{$inr} ) { # this person will get the "further"-symbol
			if ( $furtherHash{$inr} eq "further" ) { # this person will get the "further"-symbol
				$inrYsize[$inr] = $furtherYsize;
				$inrPicYesNo[$inr] = "no"; # Do not prepare the frame for a picture
			} else {  
				$inrYsize[$inr] = $inrYsize[$inr] + $extraMoreY; # This person gets the more frame, with extra space
				# Change to More Frame Paddgings (top, bot, left, right)
				$inrTopPad[$inr]    = $frameMoreStyleTopPadding; 
				$inrBotPad[$inr]    = $frameMoreStyleBotPadding; 
				$inrLeftPad[$inr]   = $frameMoreStyleLeftPadding; 
				$inrRightPad[$inr]  = $frameMoreStyleRightPadding; 
			}
		}
		# Check if left and right padding of more frame and standard frame are the same
		# It must be for the picture position.
		if (($frameMoreStyleLeftPadding != $frameStyleLeftPadding)||($frameMoreStyleRightPadding != $frameStyleRightPadding)) {
			print "**** ERROR: Left and Right Padding of more- and standard-frames/n"; 
			print "****        be the same for picture placement./n"; 
			print "**** In der Datei \"example_tree.odg\" hat der Rahmen\n";
			print "**** fuer \"More Frame Stil\" einen anderen Text-Abstand\n";
			print "**** als der Standard Rahmen. Bitte in OPEN OFFICE auf den \n";
			print "**** Rahmen mit Rechts Klicken und dort unter Text \n";
			print "**** und beide Werte gleich stellen.\n";
			#print $frameMoreStyleLeftPadding."\n";
			#print $frameStyleLeftPadding."\n";
			#print $frameMoreStyleRightPadding."\n";
			#print $frameStyleRightPadding."\n";
			exit;
		}
		$inrRightPad[$inr]  = $frameMoreStyleRightPadding; 
		$inrRightPad[$inr]  = $frameStyleRightPadding; 


		if ($inr == 1) {
			$frameWidthAll = $xSize;
			$furtherXsize = $xSize;  # the further frame get the size of all frames, as frame No. 1
		}

		# Check for Fotograph and define Y-Height
		if ( $picPos ne "none" ) {
			if  ( ($picPos eq "top") && (defined $picFileNameHash{$inr}) && ($inrPicYesNo[$inr] eq "yes") ) { # Picture to the top
				$inrYsize[$inr] = $inrYsize[$inr] + $picMaxHeight + 1*$inrTopPad[$inr]; # This person gets the more frame, with extra space
				$inrTopPad[$inr]    = 2*$inrTopPad[$inr] + $picMaxHeight;    # Adding space for picture and two times padding 
			}
			if  ( ($picPos eq "bottom") && (defined $picFileNameHash{$inr}) && ($inrPicYesNo[$inr] eq "yes") ) { # Picture to the bottom
				$inrYsize[$inr] = $inrYsize[$inr] + $picMaxHeight + 1*$inrBotPad[$inr]; # This person gets the more frame, with extra space
				$inrBotPad[$inr] = 2*$inrBotPad[$inr] + $picMaxHeight; # Adding space for picture and two times padding 
			}
			if  ( (($picPos eq "left")||($picPos eq "right")) && (defined $picFileNameHash{$inr}) && ($inrPicYesNo[$inr] eq "yes") ) { # Picture to the left and frame height to small
				if ($inrYsize[$inr] < $picMaxHeight + $inrBotPad[$inr] + $inrTopPad[$inr]) { # This person get a higher frame to fit in the picture on the left/right side
					$inrYsize[$inr] = $picMaxHeight + $inrBotPad[$inr] + $inrTopPad[$inr]; # This person gets the more frame, with extra space
				}
			}
			if  ( ($picPos ne "top")&&($picPos eq "bottom")&&($picPos ne "left")&&($picPos eq "right") ) {
				print "Error: Falsches Schluesselwort bei der Foto-Position. \n";
				exit;
			}
		}
	}
	close(IN);

	if ($frameWidthAll == 0) {
		print " **** Error: no index of No. 1 found, $frameWidthAll could not be set! \n";
		exit;
	}

    	print "**** Initialize Generation X-Position \n";

	if ( $treeOrientation eq "yo" ) { # young left, old right
		$genXpos[1] = $zeroX;
		for $i (2..$nog) {
			if ( ($genHasPic[$i-1] eq "yes") && (($picPos eq "left")||($picPos eq "right")) ) {
				if ($picPos eq "left") {
					$genXpos[$i] = $genXpos[$i-1] + $frameWidthAll + $deltaX  + $picMaxWidth + $frameStyleLeftPadding;
				} else {
					$genXpos[$i] = $genXpos[$i-1] + $frameWidthAll + $deltaX  + $picMaxWidth + $frameStyleRightPadding;
				}
			} else {
				$genXpos[$i] = $genXpos[$i-1] + $frameWidthAll + $deltaX;
			}
		}
	} else {
		$genXpos[$nog] = $zeroX;
		for ($i = $nog-1; $i >= 1; $i--) { 
			if ( ($genHasPic[$i+1] eq "yes") && (($picPos eq "left")||($picPos eq "right")) ) {
				if ($picPos eq "left") {
					$genXpos[$i] = $genXpos[$i+1] + $frameWidthAll + $deltaX  + $picMaxWidth + $frameStyleLeftPadding;
				} else {
					$genXpos[$i] = $genXpos[$i+1] + $frameWidthAll + $deltaX  + $picMaxWidth + $frameStyleRightPadding;
				}
			} else {
				$genXpos[$i] = $genXpos[$i+1] + $frameWidthAll +$deltaX;
			}
		}
	}
				

    	print "**** Increase the width of the Frame for fitting a new fotograh to the left of right\n";
	if ( ($picPos eq "left")||($picPos eq "right") ) {
		for $i (1..$noi) {
			if ($inrGen[$i] ne "not_in_tree") { # Not in tree 
				if ($genHasPic[$inrGen[$i]-$genMin+1] eq "yes") { # In einer Generation mit Bildern, werden alle Rahmen breiter gemacht
					if ($picPos eq "left") {
						$inrXsize[$i] = $frameWidthAll + $picMaxWidth + $inrLeftPad[$i]; # Make place for pictures on left side
						$inrLeftPad[$i] = 2 * $inrLeftPad[$i] + $picMaxWidth;
					} else {
						$inrXsize[$i] = $frameWidthAll + $picMaxWidth + $inrRightPad[$i]; # Make place for pictures on right side
						$inrRightPad[$i] = 2 * $inrRightPad[$i] + $picMaxWidth;
					}
				}
			}
		}
	}



	print "**** Create Marriage ID Hash\n";

	open(IN, "<$fnDataFileMarriages") || die "Can't open file $fnDataFileMarriages ($!)\n";
	$j = 0; 
	while(<IN>) {			
		$line= $_;
		if ($line =~ m/(\d*?) (\d*)(.*)/) {
			$j = $j +1;
			$inrHusbandMarriage[$j] = $1;
			$inrWifeMarriage[$j] = $2;
			$partnerShipSymbol = $3;
			if ( ($partnerShipSymbol ne " o-o") && ($partnerShipSymbol ne "") ) {
				print " **** Error in format in file ".$fnDataFileMarriages."\n";
				print "Partnerschaftssymbol: X".$partnerShipSymbol."X \n";
				print " **** Each line of the file must contain two index-numbers: husband and wife and optional o-o.\n";
				exit;
			}
			$marriageGen[$j] = "not_in_tree"; # Initialisation, not set.
			$hashEntry = $inrHusbandMarriage[$j]."_".$inrWifeMarriage[$j];
			$marriageHash{$hashEntry} = $noi+$j;  # the marriages IDs are above the frame IDs.
			if ($partnerShipSymbol eq " o-o") {
				$partnerShipHash{$hashEntry} = $noi+$j;  # the martner ships get a marriage frame without oo.
				print $inrHusbandMarriage[$j]." o-o ".$inrWifeMarriage[$j]."\n";
			} else {
				print $inrHusbandMarriage[$j]." oo ".$inrWifeMarriage[$j]."\n";
			}
		} else {
			print " **** Error in format in file ".$fnDataFileMarriages."\n";
			print " **** Each line of the file must contain two index-numbers: husband and wife.\n";
			exit;
		}
	}
	$nom = $j;
	close(IN);

	print "**** Initialize Connector Data \n";
	
	$inrFather[0] = 0;
	$inrMother[0] = 0;

	open(IN, "<$fnDataFileConnectors") || die "Can't open file $fnDataFileConnectors ($!)\n";
	while(<IN>) {
		$line= $_;	
		if ($line =~ m/SOI/) {
			$line = <IN>;  # Read the Index Number of the actual person
			if ($line =~ m/(\d*)/) {  # Read the Index Number of the actual person
				$inr = $1;
			} else {
				print "**** ERROR Wrong Format in ".$fnDataFileConnectors." at Index Reading.\n";
				exit;
			}
			$line = <IN>;  # Read Parents
			if ($line =~ m/(\d*) (\d*)/) {  # Read the Index Number of the actual person
				$inrFather[$inr] = $1;
				$inrMother[$inr] = $2;
			} else {
				print "**** ERROR Wrong Format in ".$fnDataFileConnectors." at Index Parents Reading.\n";
				exit;
			}
			$j = 1;
			$line = <IN>;  # Read Husband/Wife or EOI
		}
		if ( $line =~ m/(\d*?) (\d*)/ ) { # found marriage
			$inrHusband[$inr][$j] = $1;
			$inrWife[$inr][$j] = $2;
			print "Marriage found: ".$1." ".$2."\n";
			$j = $j + 1;
		}
		if ($line =~ m/EOI/) { # End Of Index found
			$inrHusband[$inr][$j] = 0; # no furher husbands
			$inrWife[$inr][$j] = 0; # no further wifes
		}
	}
	close(IN);

}


sub analyseTreeOdgContent {

	my $line1;

	## open example content XML file
	print "*****\n";
	print "***** Page Content Analyse Start \n";
	print "*****\n";

	open(IN, "<$fnContentExample") || die "Can't open file $fnContentExample ($!)\n";

	$line1= <IN>;
	# Header Line Analysis
	print "***** Header Line Analysis \n";
	$lineHeadContent = $line1;

	$line1= <IN>;
	if ( $line1=~ m/(.*)(<draw:page.*?>)(<.*>)(<\/draw:page>)(.*)/ ) {
		$wordOdg1 = $1; # part until <draw:page ...>
		print "WordOdg1: ".$wordOdg1."\n";
		$wordOdg2 = $2; # part <draw:page ...>
		print "WordOdg2: ".$wordOdg2."\n";
		$wordOdg3 = $3; # part example tree, will be replaced
		print "WordOdg3: ".$wordOdg3."\n";
		$wordOdg4 = $4; # part </draw:page>
		print "WordOdg4: ".$wordOdg4."\n";
		$wordOdg5 = $5; # last part of the Body Line
		print "WordOdg5: ".$wordOdg5."\n";
	} else {
		# Header Line Analysis
		print "***** ERROR: Wrong format in file ".$fnContentExample." in second line. \n";
		exit;
	}
	close(IN);
	print "*****\n";
	print "***** Page Content Analysis End\n";
	print "*****\n";

	## open example style XML file, for getting the page size
	print "*****\n";
	print "***** Page Styles Analyse Start \n";
	print "*****\n";

	open(IN, "<$fnStylesExample") || die "Can't open file $fnStylesExample ($!)\n";

	$line1= <IN>;
	# Header Line Analysis
	print "***** Header Line Analysis \n";
	$lineHeadStyles = $line1;
	print $lineHeadStyles."\n";

	$line1= <IN>;
	print $line1."\n";
	if ( $line1=~ m/(.*page-width=\")(.*)(cm\" fo:page-height=\")(.*)(cm\" .*)/ ) {
	#if ( $line1=~ m/(.*page-width)(.*)(:page-height")(.*)(page-layout.*)/ ) {
		$wordPageWidth = $1; 
		print "WordPageWidth: ".$wordPageWidth."\n";
		$pageWidth = $2;  
		print "Page Width: ".$pageWidth."\n";
		$wordPageHeight = $3; 
		print "WordPageHeight: ".$wordPageHeight."\n";
		$pageHeight = $4; 
		print "Page Height: ".$pageHeight."\n";
		$wordPageEnd = $5; 
		print "WordPageEnd: ".$wordPageEnd."\n";
	} else {
		# Style Content Analysis
		print "***** ERROR: Wrong format in file ".$fnStylesExample." in second line. \n";
		exit;
	}
	close(IN);
	print "*****\n";
	print "***** Page Styles Analysis End\n";
	print "*****\n";

	## open example manifest XML file, for referencing the pictures
	print "*****\n";
	print "***** Manifest Analyse Start \n";
	print "*****\n";

	open(IN, "<$fnManifestExample") || die "Can't open file $fnManifestExample ($!)\n";

	$wordManifest =""; # Reset
	while (<IN>) {
		$line1 = $_;
		if ( $line1 ne "</manifest:manifest>" ) { # found the last line
			$wordManifest = $wordManifest.$line1;
		}
	}

	close(IN);
	print "*****\n";
	print "***** Manifest Analysis End\n";
	print "*****\n";

	print "*****\n";
	print "***** Frame Content Analyse Start \n";
	print "*****\n";
	if ($wordOdg3 =~ m/(.*?)(<draw:custom-shape.*?>)(.*?Stil Preruf.*?)(<draw:enhanced-geometry.*?\/><\/draw:custom-shape>).*/ ) {
	#                      1             2                    3                         4           
		$wordFrameStart = $2; 
		print "FrameStart: ".$wordFrameStart."\n";
		$wordFrameCore = $3; 
		print "FrameCore: ".$wordFrameCore."\n";
		$wordFrameStop = $4; 
		print "FrameStop: ".$wordFrameStop."\n";
	} else {
		print "**** ERROR: no Frame found in example_tree.odg\n";
		exit;
	}
	if ($wordFrameStart =~ m/(.* draw:style-name=")(.*?)(" draw:text.*? xml:id=")(.*?)(" draw:id=")(.*?)(" .*svg:width=")(.*?)(cm" svg:height=")(.*?)(cm" svg:x=")(.*?)(cm" svg:y=")(.*?)(cm">)/ )  {
	#                                  1             2               3             4        5        6        7            8          9           10       11      12       13        14   15
		$wordFrameStyle = $1;
		print "Word Frame Style: ".$wordFrameStyle."\n";
		$frameStyle = $2;
		print "Frame Style: ".$frameStyle."\n";
		$wordFrameIdXml = $3;
		print "Word Frame Id Xml: ".$wordFrameIdXml."\n";
		$frameIdXml = $4;
		print "Frame ID Xml: ".$frameIdXml."\n";
		$wordFrameId = $5;
		print "Word Frame Id: ".$wordFrameId."\n";
		$frameId = $6;
		print "Frame ID: ".$frameId."\n";
		$wordFrameWidth = $7;
		print "Word Frame Width: ".$wordFrameWidth."\n";
		$frameWidth = $8;
		print "Frame Width: ".$frameWidth."\n";
		$wordFrameHeight = $9;
		print "Word Frame Height: ".$wordFrameHeight."\n";
		$frameHeight = $10;
		print "Frame Height: ".$frameHeight."\n";
		$wordFrameXpos = $11;
		print "Word Frame X Position: ".$wordFrameXpos."\n";
		$frameXpos = $12;
		print "Frame X Position: ".$frameXpos."\n";
		$wordFrameYpos = $13;
		print "Word Frame Y Position: ".$wordFrameXpos."\n";
		$frameYpos = $14;
		print "FX Y Position: ".$frameYpos."\n";
		$wordFrameEnd = $15;
		print "Word Frame End: ".$wordFrameEnd."\n";
	} else {
		print "**** ERROR: no Frame Dimension found in example_tree.odg\n";
		exit;
	}

	# reduce minimum heigth of a frame, which is defined in the style of the frame
	if ( $wordOdg1 =~ m/(.*)(<style:style style:name=\")($frameStyle)(\" .*?fo:min-height=\")(.*?)(cm\" fo:padding-top=\")(.*?)(cm\" fo:padding-bottom=\")(.*?)(cm\" fo:padding-left=\")(.*?)(cm\" fo:padding-right=\")(.*?)(cm\" .*?<\/style:style>)(.*)/  ) {    # part until <draw:page...>
	#		       1                   2                3                4              5            6               7                  8  v        9             10              11           12                13          14               15
		$wordOdg1Start = $1;
		$wordFrameStyleStart = $2;  # <style:style ...
		$wordFrameStyleMinHeight = $4;
		$frameStyleMinHeight = $5;
		$wordFrameStyleTopPadding = $6;
		$frameStyleTopPadding = $7;
		$wordFrameStyleBotPadding = $8;
		$frameStyleBotPadding = $9;
		$wordFrameStyleLeftPadding = $10;
		$frameStyleLeftPadding = $11;
		$wordFrameStyleRightPadding = $12;
		$frameStyleRightPadding = $13;
		$wordFrameStyleEnd = $14;   #  <\style:style>
		$wordOdg1End = $15;
		print "Min Height in Style Definition: ".$frameStyleMinHeight."\n";
		print "Top Padding in Style Definition: ".$frameStyleTopPadding."\n";
		print "Bot Padding in Style Definition: ".$frameStyleBotPadding."\n";
		print "Left Padding in Style Definition: ".$frameStyleLeftPadding."\n";
		print "Right Padding in Style Definition: ".$frameStyleRightPadding."\n";
	} else {
		print "****ERROR Wrong format in example_tree.odg at Min. Style Height Reduction\n";
		exit;
	}

	# find out the different stils of text in a frame, as Preruf, Nachname
	if ($wordFrameCore =~ m/(<text:p text:style-name=".*?">)(<text:span text:style-name=".*?">)Stil Preruf(<\/text:span>)(<\/text:p>).*(<text:span text:style-name=".*?">)Stil Ruf(<\/text:span>).*(<text:span text:style-name=".*?">)Stil Indexnummer(<\/text:span>).*(<text:span text:style-name=".*?">)Stil Restliche Information(<\/text:span>).*/ )  {
	#                                       1                               2                                      3            4                    5                                    6                       7                                        8                             9                                                       10         
		$wordFrameParagraphStyle = $1;
		print "Word Frame Paragraph Style: ".$wordFrameParagraphStyle."\n";
		$wordFramePrerufStyle = $2;
		print "Word Frame Preruf Style: ".$wordFramePrerufStyle."\n";
		$wordFrameTextEnd = $3;
		print "Word Frame Text End: ".$wordFrameTextEnd."\n";
		$wordFrameParagraphEnd = $4;
		print "Word Frame Paragraph End: ".$wordFrameParagraphEnd."\n";
		$wordFrameRufStyle = $5;
		print "Word Frame Ruf Style: ".$wordFrameRufStyle."\n";
		$wordFrameIndexNummerStyle = $7;
		print "Word Frame Index Nummer Style: ".$wordFrameIndexNummerStyle."\n";
		$wordFrameRestStyle = $9;
		print "Word Frame Rest Style: ".$wordFrameRestStyle."\n";
	} else {
		print "**** ERROR: no Frame Dimension found in example_tree.odg\n";
		exit;
	}
	print "*****\n";
	print "***** Frame Content Analysis End\n";
	print "*****\n";


	print "*****\n";
	print "***** Frame More Content Analyse Start \n";
	print "*****\n";
	if ($wordOdg3 =~ m/(.*)(<draw:custom-shape.*?>)(.*?More Frame Stil.*?)(<draw:enhanced-geometry.*?>.*?<\/draw:custom-shape>).*/ ) {
	#                    1             2                    3                         4           
		$wordFrameMoreStart = $2; 
		print "FrameMoreStart: ".$wordFrameMoreStart."\n";
		$wordFrameMoreCore = $3; 
		print "FrameMoreCore: ".$wordFrameMoreCore."\n";
		$wordFrameMoreStop = $4; 
		print "FrameMoreStop: ".$wordFrameMoreStop."\n";
	} else {
		print "**** ERROR: no Frame-More found in example_tree.odg\n";
		exit;
	}
	if ($wordFrameMoreStart =~ m/(.* draw:style-name=")(.*?)(" draw:text.*? xml:id=")(.*?)(" draw:id=")(.*?)(" .*svg:width=")(.*?)(cm" svg:height=")(.*?)(cm" svg:x=")(.*?)(cm" svg:y=")(.*?)(cm">)/ )  {
	#                                      1             2               3             4        5        6        7            8          9           10       11      12       13        14   15
		$wordFrameMoreStyle = $1;
		print "Word Frame More Style: ".$wordFrameMoreStyle."\n";
		$frameMoreStyle = $2;
		print "FrameMore Style: ".$frameMoreStyle."\n";
		$wordFrameMoreIdXml = $3;
		print "Word FrameMore Id Xml: ".$wordFrameMoreIdXml."\n";
		$frameMoreIdXml = $4;
		print "FrameMore ID Xml: ".$frameMoreIdXml."\n";
		$wordFrameMoreId = $5;
		print "Word FrameMore Id: ".$wordFrameMoreId."\n";
		$frameMoreId = $6;
		print "FrameMore ID: ".$frameMoreId."\n";
		$wordFrameMoreWidth = $7;
		print "Word FrameMore Width: ".$wordFrameMoreWidth."\n";
		$frameMoreWidth = $8;
		print "FrameMore Width: ".$frameMoreWidth."\n";
		$wordFrameMoreHeight = $9;
		print "Word FrameMore Height: ".$wordFrameMoreHeight."\n";
		$frameMoreHeight = $10;
		print "FrameMore Height: ".$frameMoreHeight."\n";
		$wordFrameMoreXpos = $11;
		print "Word FrameMore X Position: ".$wordFrameMoreXpos."\n";
		$frameMoreXpos = $12;
		print "FrameMore X Position: ".$frameMoreXpos."\n";
		$wordFrameMoreYpos = $13;
		print "Word FrameMore Y Position: ".$wordFrameMoreXpos."\n";
		$frameMoreYpos = $14;
		print "FX Y Position: ".$frameMoreYpos."\n";
		$wordFrameMoreEnd = $15;
		print "Word FrameMore End: ".$wordFrameMoreEnd."\n";
	} else {
		print "**** ERROR: no FrameMore Dimension found in example_tree.odg\n";
		exit;
	}

	# reduce minimum heigth of a frameMore, which is defined in the style of the frame
	if ( $wordOdg1Start =~ m/(.*)(<style:style style:name=\")($frameMoreStyle)(\" .*?fo:min-height=\")(.*?)(cm\" fo:padding-top=\")(.*?)(cm\" fo:padding-bottom=\")(.*?)(cm\" fo:padding-left=\")(.*?)(cm\" fo:padding-right=\")(.*?)(cm\" .*?<\/style:style>)(.*)/  ) {    # part until <draw:page...>
	#		           1                   2                3                4                    5            6               7                  8          9             10              11         12                  13       14                   15        

		# FrameMore Stil befindet sich am Anfang

		$wordOdg1Start = $1;
		$wordFrameMoreStyleStart = $2;  # <style:style ...
		#print "WordFrameMoreStyleStart: ".$wordFrameMoreStyleStart."\n";
		$wordFrameMoreStyleMinHeight = $4;
		#print "WordFrameMoreStyleMinHeight: ".$wordFrameMoreStyleMinHeight."\n";
		$frameMoreStyleMinHeight = $5;
		$wordFrameMoreStyleTopPadding = $6;
		$frameMoreStyleTopPadding = $7;
		$wordFrameMoreStyleBotPadding = $8;
		$frameMoreStyleBotPadding = $9;
		$wordFrameMoreStyleLeftPadding = $10;
		$frameMoreStyleLeftPadding = $11;
		$wordFrameMoreStyleRightPadding = $12;
		$frameMoreStyleRightPadding = $13;
		$wordFrameMoreStyleEnd = $14;   #  <\style:style>
		$wordOdg1Mitte = $15;
		print "Min Height in Style Definition: ".$frameStyleMinHeight."\n";
		print "Top Padding in Style Definition: ".$frameStyleTopPadding."\n";
		print "Bot Padding in Style Definition: ".$frameStyleBotPadding."\n";
		print "Left Padding in Style Definition: ".$frameStyleLeftPadding."\n";
		print "Right Padding in Style Definition: ".$frameStyleRightPadding."\n";

	} else {

		if ( $wordOdg1End =~ m/(.*?)(<style:style style:name=\")($frameMoreStyle)(\" .*?fo:min-height=\")(.*?)(cm\" fo:padding-top=\")(.*?)(cm\" fo:padding-bottom=\")(.*?)(cm\" fo:padding-left=\")(.*?)(cm\" fo:padding-right=\")(.*?)(cm\" .*?<\/style:style>)(.*)/  ) {    # part until <draw:page...>
		#		         1                 2                3                4                     5            6               7                  8            9             10              11         12                  13       14                  15

		# FrameMore Stil befindet sich am Ende

			$wordOdg1Mitte = $1;
			$wordFrameMoreStyleStart = $2;  # <style:style ...
			#print "WordFrameMoreStyleStart: ".$wordFrameMoreStyleStart."\n";
			$wordFrameMoreStyleMinHeight = $4;
			#print "WordFrameMoreStyleMinHeight: ".$wordFrameMoreStyleMinHeight."\n";
			$frameMoreStyleMinHeight = $5;
			$wordFrameMoreStyleTopPadding = $6;
			$frameMoreStyleTopPadding = $7;
			$wordFrameMoreStyleBotPadding = $8;
			$frameMoreStyleBotPadding = $9;
			$wordFrameMoreStyleLeftPadding = $10;
			$frameMoreStyleLeftPadding = $11;
			$wordFrameMoreStyleRightPadding = $12;
			$frameMoreStyleRightPadding = $13;
			$wordFrameMoreStyleEnd = $14;   #  <\style:style>
			$wordOdg1End = $15;
			print "Min Height in Style Definition: ".$frameStyleMinHeight."\n";
			print "Top Padding in Style Definition: ".$frameStyleTopPadding."\n";
			print "Bot Padding in Style Definition: ".$frameStyleBotPadding."\n";
			print "Left Padding in Style Definition: ".$frameStyleLeftPadding."\n";
			print "Right Padding in Style Definition: ".$frameStyleRightPadding."\n";
		} else {
			print "\n";
			print "Word FrameMore Style Name: ".$frameMoreStyle."\n\n";
			print "Word FrameMore Odg1 Start: ".$wordOdg1Start."\n\n";
			print "Word FrameMore Odg1 End: ".$wordOdg1End."\n\n";
			print "****ERROR Wrong format in example_tree.odg at FrameMore Min. Style Height Reduction\n";
			exit;
		}
	}

	$wordOdg1 = $wordOdg1Start.$wordOdg1Mitte; # the End is coming later, each frame needs its own style;

	# find out the different stils of text in a frame, as Preruf, Nachname
	if ($wordFrameCore =~ m/(<text:p text:style-name=".*?">)(<text:span text:style-name=".*?">)Stil Preruf(<\/text:span>)(<\/text:p>).*(<text:span text:style-name=".*?">)Stil Ruf(<\/text:span>).*(<text:span text:style-name=".*?">)Stil Indexnummer(<\/text:span>).*(<text:span text:style-name=".*?">)Stil Restliche Information(<\/text:span>).*/ )  {
	#                                       1                               2                                      3            4                    5                                    6                       7                                        8                             9                                                       10         
		$wordFrameParagraphStyle = $1;
		print "Word Frame Paragraph Style: ".$wordFrameParagraphStyle."\n";
		$wordFramePrerufStyle = $2;
		print "Word Frame Preruf Style: ".$wordFramePrerufStyle."\n";
		$wordFrameTextEnd = $3;
		print "Word Frame Text End: ".$wordFrameTextEnd."\n";
		$wordFrameParagraphEnd = $4;
		print "Word Frame Paragraph End: ".$wordFrameParagraphEnd."\n";
		$wordFrameRufStyle = $5;
		print "Word Frame Ruf Style: ".$wordFrameRufStyle."\n";
		$wordFrameIndexNummerStyle = $7;
		print "Word Frame Index Nummer Style: ".$wordFrameIndexNummerStyle."\n";
		$wordFrameRestStyle = $9;
		print "Word Frame Rest Style: ".$wordFrameRestStyle."\n";
	} else {
		print "**** ERROR: no Frame Dimension found in example_tree.odg\n";
		exit;
	}
	print "*****\n";
	print "***** Frame More Content Analysis End\n";
	print "*****\n";



	print "*****\n";
	print "***** Marriage Symbol Content Analyse Start \n";
	print "*****\n";
	if ($wordOdg3 =~ m/(.*)(<draw:custom-shape.*?>)(.*?∞.*?)(<draw:enhanced-geometry.*?\/><\/draw:custom-shape>).*/ ) {
		$wordMarriageStart = $2; 
		print "MarriageStart: ".$wordMarriageStart."\n";
		$wordMarriageCore = $3; 
		print "MarriageCore: ".$wordMarriageCore."\n";
		$wordMarriageStop = $4; 
		print "MarriageStop: ".$wordMarriageStop."\n";
		if ($wordMarriageCore =~ m/(.*?)∞(.*)/) { # remove the symbol oo, and replace with nothing for partnership
			$wordPartnerShipCore = $1."|".$2; 
		}	 
	} else {
		print "**** ERROR: no Marriage found in example_tree.odg\n";
		exit;
	}
	if ($wordMarriageStart =~ m/(.* draw:style-name=")(.*?)(" draw:text.*? xml:id=")(.*?)(" draw:id=")(.*?)(" .*svg:width=")(.*?)(cm" svg:height=")(.*?)(cm" svg:x=")(.*?)(cm" svg:y=")(.*?)(cm">)/ )  {
	#                                     1             2               3             4        5        6        7            8          9           10       11      12       13        14   15
		$wordMarriageStyle = $1;
		print "Word marriage Style: ".$wordMarriageStyle."\n";
		$marriageStyle = $2;
		print "Marriage Style: ".$marriageStyle."\n";
		$wordMarriageIdXml = $3;
		print "Word Marriage Id Xml: ".$wordMarriageIdXml."\n";
		$marriageIdXml = $4;
		print "Marriage ID Xml: ".$marriageIdXml."\n";
		$wordMarriageId = $5;
		print "Word marriage Id: ".$wordMarriageId."\n";
		$marriageId = $6;
		print "Marriage ID: ".$marriageId."\n";
		$wordMarriageWidth = $7;
		print "Word marriage Width: ".$wordMarriageWidth."\n";
		$marriageWidth = $8;
		print "Marriage Width: ".$marriageWidth."\n";
		$wordMarriageHeight = $9;
		print "Word marriage Height: ".$wordMarriageHeight."\n";
		$marriageHeight = $10;
		print "Marriage Height: ".$marriageHeight."\n";
		$wordMarriageXpos = $11;
		print "Word marriage X Position: ".$wordMarriageXpos."\n";
		$marriageXpos = $12;
		print "Marriage X Position: ".$marriageXpos."\n";
		$wordMarriageYpos = $13;
		print "Word marriage Y Position: ".$wordMarriageXpos."\n";
		$marriageYpos = $14;
		print "Marriage Y Position: ".$marriageYpos."\n";
		$wordMarriageEnd = $15;
		print "Word Marriage End: ".$wordMarriageEnd."\n";

		$marriageX = $marriageWidth;       # size of the marriage symbol in X direction [cm]
		$marriageY = $marriageHeight;       # size of the marriage symbol in Y direction [cm]

	} else {
		print "**** ERROR: no Marriage Dimension found in example_tree.odg\n";
		exit;
	}
	print "*****\n";
	print "***** Marriage Content Analysis End\n";
	print "*****\n";


	print "*****\n";
	print "***** Further-Block Content Analyse Start \n";
	print "*****\n";
	if ($wordOdg3 =~ m/.*(<draw:.*? draw:style-name=")(.*?)(" draw:text.*? xml:id=")(.*?)(" draw:id=")(.*?)(" .*?svg:width=")(.*?)(cm" svg:height=")(.*?)(cm" svg:x=")(.*?)(cm" svg:y=")(.*?)(cm">.*?)(Stil Weiter-Symbol)(.*?<\/draw:.*?>)/ )  {
	#                            1             2               3             4        5        6        7            8          9           10       11      12       13        14   15            16                  17
		$wordFurtherStyle = $1;
		print "Word Further Style: ".$wordFurtherStyle."\n";
		$furtherStyle = $2;
		print "Further Style: ".$furtherStyle."\n";
		$wordFurtherIdXml = $3;
		print "Word Further Id Xml: ".$wordFurtherIdXml."\n";
		$furtherIdXml = $4;
		print "Further ID Xml: ".$furtherIdXml."\n";
		$wordFurtherId = $5;
		print "Word Further Id: ".$wordFurtherId."\n";
		$furtherId = $6;
		print "Further ID: ".$furtherId."\n";
		$wordFurtherWidth = $7;
		print "Word Further Width: ".$wordFurtherWidth."\n";
		$furtherWidth = $8;
		print "Further Width: ".$furtherWidth."\n";
		$wordFurtherHeight = $9;
		print "Word Further Height: ".$wordFurtherHeight."\n";
		$furtherHeight = $10;
		print "Further Height: ".$furtherHeight."\n";
		$wordFurtherXpos = $11;
		print "Word Further X Position: ".$wordFurtherXpos."\n";
		$furtherXpos = $12;
		print "Further X Position: ".$furtherXpos."\n";
		$wordFurtherYpos = $13;
		print "Word Further Y Position: ".$wordFurtherXpos."\n";
		$furtherYpos = $14;
		print "Further Y Position: ".$furtherYpos."\n";
		$wordFurtherText = $15;
		print "Word Further Text: ".$wordFurtherText."\n";
		#$furtherText = $16;   # the further text is coming from the tree size file.
		#print "Further Text: ".$furtherText."\n";
		$wordFurtherEnd = $17;
		print "Word Further End: ".$wordFurtherEnd."\n";
	} else {
		print "**** ERROR: no Further Block in example_tree.odg\n";
		exit;
	}

	print "*****\n";
	print "***** Further Block Content Analysis End\n";
	print "*****\n";

	print "*****\n";
	print "***** Connector Content Analyse Start \n";
	print "*****\n";
	if ($wordOdg3 =~ m/.*?(<draw:connector.*?>)(.*?)(<\/draw:connector>).*/ ) {
		$wordConnectorStart = $1; 
		print "ConnectorStart: ".$wordConnectorStart."\n";
		$wordConnectorCore = $2; 
		print "ConnectorCore: ".$wordConnectorCore."\n";
		$wordConnectorStop = $3; 
		print "ConnectorStop: ".$wordConnectorStop."\n";
		if ($wordConnectorStart =~ m/(<draw:connector .*? draw:text-style-name=".*?")(.*)/) {
			$wordConDef = $1;
			$wordConX1 = "svg:x1=";
			$conX1 = 0.0;
			$wordConY1 = "svg:y1=";	
			$conY1 = 0.0;
			$wordConX2 = "svg:x2=";
			$conX2 = 0.0;
			$wordConY2 = "svg:y2=";	
			$conY2 = 0.0;
			$wordConStartSh = "draw:start-shape=";
			$conStartSh = 0.0;
			$wordConStartShGl = "draw:start-glue-point=";
			$conStartShGl = 0.0;
			$wordConStopSh = "draw:end-shape=";
			$conStopSh = 0.0;
			$wordConStopShGl = "draw:end-glue-point=";
			$conStopShGl = 0.0;
			$wordConPath = "svg:d=";
			$conPath = 0.0;
			$wordConSkew = "draw:line-skew=";
			$conSkew = 0.0;
			$wordConEnd = ">";
		} else {
			print "**** ERROR: no Connector found in example_tree.odg\n";
			exit;
		}		
	} else {
		print "**** ERROR: no Connector found in example_tree.odg\n";
		exit;
	}
	print "*****\n";
	print "***** Connector Content Analysis End\n";
	print "*****\n";

	print "*****\n";
	print "***** Text Analyse Start \n";
	print "*****\n";
	if ($wordOdg3 =~ m/(.*)(<draw:frame.*?>)(titleText)(.*?<\/draw:frame>).*/ ) {
		$wordTitleStart = $2;
		$wordTitleStop = $4;
	} else {
		print "**** ERROR: no titleText found in example_tree.odg\n";
		exit;
	}
	if ($wordOdg3 =~ m/(.*)(<draw:frame.*?>)(dateText)(.*?<\/draw:frame>).*/ ) {
		$wordDateStart = $2;
		$wordDateStop = $4;
	} else {
		print "**** ERROR: no dateText found in example_tree.odg\n";
		exit;
	}
	if ($wordOdg3 =~ m/(.*)(<draw:frame.*?>)(sourceText)(.*?<\/draw:frame>).*/ ) {
		$wordSourceStart = $2;
		$wordSourceStop = $4;
	} else {
		print "**** ERROR: no sourceText found in example_tree.odg\n";
		exit;
	}
	if ($wordOdg3 =~ m/(.*)(<draw:frame.*? svg:x=")(.*?)(cm".*?>)(generationText)(.*?<\/draw:frame>).*/ ) {
		$wordGenerationStartX = $2;
		$wordGenerationMiddle = $4;
		$wordGenerationStop = $6;
	} else {
		print "**** ERROR: no generationText found in example_tree.odg\n";
		exit;
	}
	
	print "*****\n";
	print "***** Text Analysis End\n";
	print "*****\n";
}


sub defineRowPlacement {  # Define the series of the row placement for each generation

print "*****\n";
print "***** Define Row Placement Start \n";
print "*****\n";

my $fnDataFileRowPlacement = shift;
my $i;
my $inrCmp;
my $inrSmallestCmp;
my $j;
my $sumOfPlacedPersons=0;
my $sumOld;
my $placed;
my $genIdx;
my @genSmallestInr; # actual smallest Index Number in a Row
my $gen;
my $genInrCntMax; # maximum numbers of placed person in one generation
my $cmp; # position compare value
my $stillPartners;
my $smallestPerson;
my $smallestPartner;

	for $i (1..$nog) { # set default for all generations
		$genIdx = $i;
		$genSmallestInr[$genIdx] = 0;
		$genInrCnt[$genIdx] = 0;
	}
	
	while ($sumOfPlacedPersons < $noi) { # as long as not all persons placed
		print " **** \n";
		print " **** New Run Through All Persons \n";
		print " **** \n";
		$sumOfPlacedPersons = 0;
		for $i (1..$noi) { # check all person
			$placed = $inrPlacedInGenRow[$i];
			if ($placed == 0) { # not placed and in the tree
				$genIdx = $inrGen[$i] - $genMin + 1;
				if ($genSmallestInr[$genIdx] == 0) { # actual no smallest person in this row
					$genSmallestInr[$genIdx] = $i;
					print "Set ".$i." into generation ".$inrGen[$i]." as first smallest person.\n";
				} else {

					# search compare index for actual person

					if ($inrA2P[$i] == 0) { # index is not attached to his partner
						$inrCmp = $i;
					} else {
						#if ($inrA2P[$i] == $genSmallestInr[$genIdx]) { # attached partner and smallest are the same
						#	$inrCmp = $i;
						#} else {
						#	$inrCmp = $inrA2P[$i]; # use to compare the position of attached partner
						#	print "Use at next compare attached partner ".$inrCmp." instead of ".$i."\n";
						#}
						if ($inrA2P[$i] == $genSmallestInr[$genIdx]) { # attached partner and smallest are the same
							$inrCmp = $i;
						} else {
							$inrCmp = $inrA2P[$i]; # use to compare the position of attached partner
							while ($inrA2P[$inrCmp] != 0) { # suche nach einem nicht-"attachten" Partner
								$inrCmp = $inrA2P[$inrCmp];  
							}
							print "Use at next compare attached partner ".$inrCmp." instead of ".$i."\n";
						}
						#if (($inrA2P[$i] != 0)  && ($inrPlacedInGenRow[$inrA2P[$i]] == 1) ) { # platziere nach schon platzierten Partnern, auch Partner von Partnern
						#	$inrCmp = $inrA2P[$i]; # use to compare the partner position
						#	while ($inrA2P[$inrCmp] != 0) { # suche nach einem nicht-"attachten" Partner
						#		$inrCmp = $inrA2P[$inrCmp];  
						#	}
						#	#print "Use at next compare attached partner ".$inrCmp." instead of ".$i."\n";
						#} else {
						#	$inrCmp = $i;
						#}
					}
					
					# search compare index for smallest person

					if ($inrA2P[$genSmallestInr[$genIdx]] == 0) { # smallest index is not attached to his partner
						$inrSmallestCmp = $genSmallestInr[$genIdx];
					} else {
						if ($inrA2P[$genSmallestInr[$genIdx]] == $i) { # attached partner and smallest are the same
							$inrSmallestCmp = $genSmallestInr[$genIdx];
						} else {
							$inrSmallestCmp = $inrA2P[$genSmallestInr[$genIdx]]; # use to compare the partner position
							while ($inrA2P[$inrCmp] != 0) { # suche nach einem nicht-"attachten" Partner
								$inrCmp = $inrA2P[$inrCmp];  
							}
							print "Use for smallest Persron the next attached partner ".$inrCmp." instead of ".$i."\n";
						}
					}

					#if  ( $inrA2P[$i] == $inrA2P[$genSmallestInr[$genIdx]] ) { # both have the same partner, so use the native placements
					if  ( $inrCmp == $inrSmallestCmp ) { # both have the same partner or partner's partner, so use the native placements
						$inrCmp = $i;
						$inrSmallestCmp = $genSmallestInr[$genIdx];
					}

					print "Compare new ".$i." with smallest ".$genSmallestInr[$genIdx]." in generation ".($genIdx+$genMin-1)."\n";
					$cmp = &comparePosition($inrDist[$inrCmp],$inrSideStep[$inrCmp],$inrSide[$inrCmp],$inrPlacement[$inrCmp],$inrDist[$inrSmallestCmp],$inrSideStep[$inrSmallestCmp],$inrSide[$inrSmallestCmp],$inrPlacement[$inrSmallestCmp]);
					print "  Result ".$cmp."\n";

					if ($cmp == -1) {
						$genSmallestInr[$genIdx] = $i; # found new Index with smaller position
					}
				}
			} else {
				$sumOfPlacedPersons = $sumOfPlacedPersons + 1;
			}
		} # all persons have been checked to find the new smallest in all rows

	
		# collect the smallest person of each generation

		$sumOld = $sumOfPlacedPersons;
		for $i (1..$nog) { # after one run through all persons, collect the smallest and mark them
			$genIdx = $i;
			$gen = $i + $genMin -1;
			$smallestPerson = $genSmallestInr[$genIdx];
			if ( $smallestPerson != 0 ) { # the last run through all person give a further person in this generations

				if ( $inrPlacedInGenRow[$smallestPerson] == 0) { # found none placed person

					$inrPlacedInGenRow[$smallestPerson] = 1; # person marked as placed
					print "Person ".$genSmallestInr[$genIdx]." is smallest in Generation ".$gen."\n";
					$sumOfPlacedPersons = $sumOfPlacedPersons + 1;
					$genInrCnt[$genIdx] = $genInrCnt[$genIdx] + 1;
					$genPlcInr[$genIdx][$genInrCnt[$genIdx]] = $smallestPerson; # placement array value set

					# search for all marriage-partners of the just placed persons and place them
					$stillPartners = 1;
					$smallestPartner = 0;
					#while ($stillPartners > 0) {
					while ($stillPartners < -1000) {
						$stillPartners = 0;

						for $j (1..$nom) { # go through all marriages

							# smallest person is a husband and wife is in tree => looking for wifes
							if ( ($smallestPerson == $inrHusbandMarriage[$j]) && ($inrGen[$inrWifeMarriage[$j]] ne "not_in_tree") ) { 
								if ($inrPlacedInGenRow[$inrWifeMarriage[$j]]==0) { # found a none placed wife
									$stillPartners = $stillPartners + 1;
									if ($smallestPartner == 0) {
										$smallestPartner = $inrWifeMarriage[$j];
									} else {
										$cmp = &comparePosition($inrDist[$inrWifeMarriage[$j]],$inrSideStep[$inrWifeMarriage[$j]],$inrSide[$inrWifeMarriage[$j]],$inrPlacement[$inrWifeMarriage[$j]],$inrDist[$smallestPartner],$inrSideStep[$smallestPartner],$inrSide[$smallestPartner],$inrPlacement[$smallestPartner]);
										if ($cmp == -1) {
											$smallestPartner = $inrWifeMarriage[$j];
										}
									}
								}
							}	 

							# smallest person is a wife and husband is in tree => looking for husbands
							if ( ($smallestPerson == $inrWifeMarriage[$j]) && ($inrGen[$inrHusbandMarriage[$j]] ne "not_in_tree") ) { 
								if ($inrPlacedInGenRow[$inrHusbandMarriage[$j]]==0) { # found a none placed husband
									$stillPartners = $stillPartners + 1;
									if ($smallestPartner == 0) {
										$smallestPartner = $inrHusbandMarriage[$j];
									} else {
										$cmp = &comparePosition($inrDist[$inrHusbandMarriage[$j]],$inrSideStep[$inrHusbandMarriage[$j]],$inrSide[$inrHusbandMarriage[$j]],$inrPlacement[$inrHusbandMarriage[$j]],$inrDist[$smallestPartner],$inrSideStep[$smallestPartner],$inrSide[$smallestPartner],$inrPlacement[$smallestPartner]);
										if ($cmp == -1) {
											$smallestPartner = $inrHusbandMarriage[$j];
										}
									}
								}
							}
						}
						if ($stillPartners > 0) { # placement of the smallest partner
							$inrPlacedInGenRow[$smallestPartner] = 1; # partner marked as placed
							print "Placed Partner ".$smallestPartner." of Person ".$genSmallestInr[$genIdx]." in Generation ".$gen."\n";
							if ($smallestPerson == $inrHusbandMarriage[$j]) {
								print "Husband ".$smallestPartner." of Wife ".$genSmallestInr[$genIdx]." is placed in Generation ".$gen."\n";
							}
							if ($smallestPerson == $inrWifeMarriage[$j]) {
								print "Wife ".$smallestPartner." of Husband ".$genSmallestInr[$genIdx]." is placed in Generation ".$gen."\n";
							}
							$sumOfPlacedPersons = $sumOfPlacedPersons + 1;
							$genInrCnt[$genIdx] = $genInrCnt[$genIdx] + 1;
							$genPlcInr[$genIdx][$genInrCnt[$genIdx]] = $smallestPartner; # placement array value set
							$stillPartners = $stillPartners - 1;
						}
						$smallestPartner = 0; # reset the smallest partner
					}
				}
				$genSmallestInr[$genIdx] = 0; # reset smallest person for next search through all persons
			} else {
				print "No further person in generation ".$gen."\n";
			}
		}
		if ($sumOld == $sumOfPlacedPersons) {
			print "**** ERROR: no increase of the sum of the placed person in a search loop \n";
			print "**** last sum value: ".$sumOld."\n";
			exit;
		}
	print " **** End of search through all person to find the smallest.\n";
	print "      Sum of placed persons: ".$sumOfPlacedPersons."\n";
	}
	print "Sum of placed persons: ".$sumOfPlacedPersons."\n";
	
	# Output into Data File
	
	open(OUT, ">$fnDataFileRowPlacement") || die "Can't open file $fnDataFileRowPlacement ($!)\n";

	$genInrCntMax=0;	

	print OUT "GNR = Generation Number\n";
	print OUT "CNT = Persons per Generation\n";
	print OUT "YMX = max. Y-Position\n";
	print OUT "INR = Index Number\n";
	print OUT "FAM = Familie Number\n\n";

	for $i (1..$nog) {	# find maximum number of placed persons in a row
		if ($genInrCnt[$i]>$genInrCntMax) {
			$genInrCntMax=$genInrCnt[$i]
		}
		$gen = $i + $genMin -1;
		print OUT "Personenanzahl:,GNR,".$gen.",CNT,".$genInrCnt[$i].",,,";
	}

	#print OUT "\n";
	#for $i (1..$nog) {	# print the next free y-Position for each generation
	#	$gen = $i + $genMin -1;
	#	print OUT "max. Y-Position:,GNR,".$gen.",YMX,".$genYpos[$i].",,,";
	#}

	print OUT "\n\n";
	for $j (1..$genInrCntMax) {
		print OUT $j.",";  # running counter
		for $i (1..$nog) {
			$gen = $i + $genMin -1;
			if ($j>$genInrCnt[$i]) { # no more persons in this generation
				print OUT "GNR,".$gen.",INR,0,FAM,0,";
			} else {
				print OUT "GNR,".$gen.",INR,".$genPlcInr[$i][$j].",FAM,".$inrFam[$genPlcInr[$i][$j]].",";
			}
		}
		print OUT "\n";				 
	}

	close(OUT);

	print "*****\n";
	print "***** Define Row Placement End \n";
	print "*****\n";

}


sub comparePosition { # compare which person out of two in one generation level should be placed more left

	my $dist1 = shift; # distance
	my $ss1 = shift; # side steps
	my $s1 = shift; # side
	my $plc1 = shift; # placement number
	my $dist2 = shift; # distance
	my $ss2 = shift; # side steps
	my $s2 = shift; # side
	my $plc2 = shift; # placement number

	print "  Side ".$s1." ".$s2."\n";
	print "  SiSt ".$ss1." ".$ss2."\n";
	print "  Dist ".$dist1." ".$dist2."\n";
	print "  Plac ".$plc1." ".$plc2."\n";

	if ( ($s1 < $s2) && ($s2 == 1) ) { # Person 1 is more left than person 2, side=0 is equally to side=-1
		print "   \$s1 < \$s2 -1\n"; 
		return -1;
	}
	if ( ($s1 > $s2) && ($s1 == 1) ) { # Person 2 is more left than person 1,  side=0 is equally to side=-1
		print "   \$s1 > \$s2 +1\n"; 
		return 1;
	}
	# the side is the same
	# right side or below
	if ($s1 == 1)  { # right side
		print "   right side\n"; 
		#if ($ss1 < $ss2) { # less side steps
		#	return -1;
		#}
		#if ($ss1 > $ss2) { # more side steps
		#	return 1;
		#}
		# same side steps
		if ($dist1 < $dist2) { # smaller distance
				return -1;
		}
		if ($dist1 > $dist2) { # bigger distance
				return 1;
		}
		# same distance
		if ($plc1 < $plc2) { # earlier pre-placement
					return -1;
		}
		if ($plc1 > $plc2) { # later pre-placement
					return 1;
		}
		print "**** ERROR: Two person with exact the same position on right side, should not be.\n";
		exit;
	}
	# left side or below
	if ( ($s1 == -1) || ($s1 == 0) )  {
		print "   left side or below\n"; 
		#if ($ss1 < $ss2) { # less side steps
		#	return 1;
		#}
		#if ($ss1 > $ss2) { # more side steps
		#	return -1;
		#}
		# same side steps
		if ($dist1 < $dist2) { # smaller distance
				return 1;
		}
		if ($dist1 > $dist2) { # bigger distance
				return -1;
		}
		# same distance
		if ($plc1 < $plc2) { # earlier pre-placement
					return 1;
		}
		if ($plc1 > $plc2) { # later pre-placement
					return -1;
		}
		print "**** ERROR: Two person with exact the same position on left side, should not be.\n";
		exit;
	}
	print "**** ERROR: The side of a person is invalid. \n";
	exit;
}


sub groupFamilies { # define the family for each person

	my $i;
	my $inr;

	for $i (1..$noi) { # search through all persons
			$inrFam[$i] == "error_no_fam";
		if ( $inrA2P[$i] != 0 ) { # this partner is attached
			if ( $inrA2P[$i] =~ m/(\d*)/ ) { # correct format in A2P
				$inr = $inrA2P[$i]; # put the attached partner into the partner's family
			} else {
				print "**** ERROR: inrA2P ".$i." = ".$inrA2P[$i]."\n";
				exit;
			}
		} else {
			$inr = $i;
		}
		if ( ($inrFather[$inr] != 0) && ($inrMother[$inr] != 0) ) { # both parent are available
			$inrFam[$i] = $inrFather[$inr]."_".$inrMother[$inr];
		}
		if ( ($inrFather[$inr] != 0) && ($inrMother[$inr] == 0) ) { # only the father is available
			$inrFam[$i] = $inrFather[$inr];
		}
		if ( ($inrFather[$inr] == 0) && ($inrMother[$inr] != 0) ) { # only the mother is available
			$inrFam[$i] = $inrMother[$inr];
		}
		if ( ($inrFather[$inr] == 0) && ($inrMother[$inr] == 0) ) { # no parent is available
			$inrFam[$i] = 0;
		}
	print " Person ".$i." has family ".$inrFam[$i]."\n";
	}
		
}

sub optimize_frame_position_preparation {

	my $i;
	my $j;
	my $k;
	my $inr;
	my $gen;
	my $inrLastPlaced;
	my $inrHus;
	my $inrWif;
	my $nextYpos;
	my $Ypos;



	print "*****\n";
	print "***** Finding first placement of the persons' frames\n";
	print "***** Finding the longest column\n";
	print "*****\n";

	for $i (1..$nog) { # go through all generations

		$gen = $i + $genMin -1;
		print " **** Active Generation: ".$gen."\n";
		$inrLastPlaced = 0;
		for $j (1..$genInrSum[$i]) { # go through all placed persons in a generation
			$inr = $genPlcInr[$i][$j]; # index to be placed
			
			print "*** Add Frame No. ".$inr."\n";

			# Set the X Position Depending on the Generation X Position
			$inrXpos[$inr] = $genXpos[$inrGen[$inr]-$genMin+1];

			if ($j == 1) { # first person in a row
				$inrYpos[$inr] = $genYpos[$inrGen[$inr]-$genMin+1];
			} else {
				if ( &beBrotherOrSister($inr,$inrLastPlaced) == 1 ) { # brother or sister
					$genYpos[$inrGen[$inr]-$genMin+1] = $genYpos[$inrGen[$inr]-$genMin+1] + $deltaYbrosis; # add brother&sister spacer 
					$inrYpos[$inr] = $genYpos[$inrGen[$inr]-$genMin+1];
					$inrLLim[$inr] = "brotherSisterBorder";
					$inrRLim[$inrLastPlaced] = "brotherSisterBorder";
					print "    ".$inr." und ".$inrLastPlaced." sind Geschwister.\n";
				} else { # parent are not the same
					if ( &beMarried($inr,$inrLastPlaced) == 1 ) { # but they are married
						$genYpos[$inrGen[$inr]-$genMin+1] = $genYpos[$inrGen[$inr]-$genMin+1] + $deltaYmar; # add marriage spacer 
						$inrYpos[$inr] = $genYpos[$inrGen[$inr]-$genMin+1];
						$inrLLim[$inr] = "marriageBorder";
						$inrRLim[$inrLastPlaced] = "marriageBorder";
						print "    ".$inr." und ".$inrLastPlaced." are a couple.\n";
					} else { # not married
						if ( &beBrotherOrSisterInLaw($inr,$inrLastPlaced)==1 ) { # Schwager oder Schwaegerin
							$genYpos[$inrGen[$inr]-$genMin+1] = $genYpos[$inrGen[$inr]-$genMin+1] + $deltaYbrosis; # add brother&sister spacer 
							$inrYpos[$inr] = $genYpos[$inrGen[$inr]-$genMin+1];
							print "    ".$inr." und ".$inrLastPlaced." sind Schwager oder Schwaegerin.\n";
							$inrLLim[$inr] = "brotherSisterInLawBorder";
							$inrRLim[$inrLastPlaced] = "brotherSisterInLawBorder";
						} else { # other family, no relationship
							$genYpos[$inrGen[$inr]-$genMin+1] = $genYpos[$inrGen[$inr]-$genMin+1] + $deltaYfam; # add family spacer 
							$inrYpos[$inr] = $genYpos[$inrGen[$inr]-$genMin+1];
							$inrLLim[$inr] = "familyBorder";
							$inrRLim[$inrLastPlaced] = "familyBorder";
							print "    Grenze zwischen Familien gefunden in Generation ".$inrGen[$inr]." zwischen \n";
							print "    Index ".$inr." Platz ".$inrPlacement[$inr]." und Index ".$inrLastPlaced." Platz ".$inrPlacement[$inrLastPlaced]."\n";
						}
					}
				}
			}
			$genYpos[$inrGen[$inr]-$genMin+1] = $genYpos[$inrGen[$inr]-$genMin+1] + $inrYsize[$inr]; ## calculate new free Y-place
			$inrLastPlaced = $inr;

		}
	}

	# calculate Y position of the marriages

	&calcMarriageYpos;
	
	# finding the generation with the maximum Y-Position, the longest column
	
	$maxYpos = 0;
	$maxYposGen = -9999;
	for $i (1..$nog) {	
		$gen = $i + $genMin -1;
		if ($genYpos[$i] > $maxYpos) {
			$maxYpos = $genYpos[$i];
			$maxYposGen = $gen; 
		}
	}

	
	print "***** Finding the series of the couples -> Sorting by Y-pos.\n";
	print "**************\n";
	print "***** Marriage Summary: \n";
	
	for $j (1..$nog) {	
		$genMarSum[$j] = 0;
	}

	for $k (1..$nom) {
		if ($marriageGen[$k] ne "not_in_tree" ) { # marriage is in the tree
			$gen = $marriageGen[$k];
			$j = $gen - $genMin + 1;
			print "HUS ".$inrHusbandMarriage[$k]." WIF ".$inrWifeMarriage[$k]." GEN ".$gen." J ".$j."\n";
			$Ypos = $inrYpos[$k+$noi]; # the y-positions of marriages are listed behind the index positions
			if ( $genMarSum[$j] > 0  ) { # there is already one couple in this generation
				$nextYpos = $inrYpos[$genPlcMar[$j][$genMarSum[$j]]+$noi];
			} else {
				$nextYpos = 0; # yet no marriage in this generation
			}
			$genMarSum[$j] = $genMarSum[$j] + 1; # A new marriage in this generation
			$i = $genMarSum[$j];
		
			while ( ($nextYpos > $Ypos) && ($i > 1) ) { # shift the next marriage to the actual position $i, if bigger in Ypos
				$genPlcMar[$j][$i] = $genPlcMar[$j][$i-1];  # i= actual position in gen
				$i = $i - 1;
				$nextYpos = $inrYpos[$genPlcMar[$j][$i]+$noi];
			}
			$genPlcMar[$j][$i] = $k; # set the marriage number to a placement position
		}
	}
	
	print "**************\n";
	for $i (1..$nog) {	
		$gen = $i + $genMin -1;
		print "GENERATION Nr. ".$gen."\n";
		for $j (1..$genMarSum[$i]) {
			print "Couple X-Y-Position 0:".$j.". Couple: ".$genPlcMar[$i][$j]." Ypos: ".$inrYpos[$genPlcMar[$i][$j]+$noi]."\n";
		}
	}
	print "**************\n\n";

}

sub optimize_frame_position {

	my $i;
	my $j;
	my $k;
	my $charStart;
	my $charStop;
	my $genStart;
	my $genStop;
	my $genInc;

	my $gen;
	my $genInr;
	my $yPosMin;
	my $yPosMinInr;
	my $foundFirstYpos;

	#my @fix;
	#my @flex;
	#my @tension;
	#my @tensionOrder;
	#my @new_flex;
	#my @new_flex2;
	#my @results;
	#my $reference_auf_results;

	#print "**** Test Spring Matrix Funktion\n";

	#$fix[1] = 1;
	#$fix[2] = 2;
	#$fix[3] = 3;
	#$fix[4] = 4;
	#$flex[1] = 10;
	#$flex[2] = 20;
	#$flex[3] = 30;
	#$flex[4] = 40;
	#$i = 4;
	
	#$reference_auf_results = &calcSpringMatrix(\@fix,\@flex,$i);  # \@ARRAY uebergibt Reference auf Array an die Funktion
	#@results = @{$reference_auf_results};  # aus Referenz wieder ein Array erzeugen
	#@new_flex = @{$results[1]};
	#@tension = @{$results[2]};

	#for $j (1..$i) {
	#	print "new_flex: ".$new_flex[$j]." tension: ".$tension[$j]."\n";
	#}

	#$reference_auf_results = &findMostNegativeTension(\@tension,$i);
	#@tensionOrder = @{$reference_auf_results}; # aus Referenz wieder ein Array erzeugen
	#for $j (1..$i) {
	#	print "sorted tensionOrder: ".$tensionOrder[$j]." tension: ".$tension[$tensionOrder[$j]]."\n";
	#}

	print "movementLoopCnt: ".length($movementLoop)."\n";
	
	for ($k=1; $k<=(length($movementLoop)-1); $k=$k+2) { # goes throught the movement definition string, -1 is taking uneven countvalue into account
		$charStart = substr($movementLoop,$k-1,1); # get start char
		$charStop = substr($movementLoop,$k,1); # get stop char
		#$k = $k + 1;
		print "movement Char-Start: ".$charStart."\n";
		print "movement Char-Stop: ".$charStop."\n";
		print "genMin: ".$genMin."\n";
		print "genMax: ".$genMax."\n";
		print "maxYposGen: ".$maxYposGen."\n";
		if ($charStart eq "B") { # B=Bottom, M=Middle, T=Top
			$genStart = $genMin;
			print "Bstart\n";
		}
		if ($charStart eq "M") {
			$genStart = $maxYposGen;
			print "Mstart\n";
		}
		if ($charStart eq "T") {
			$genStart = $genMax;
			print "Tstart\n";
		}
		if ($charStop eq "B") {
			$genStop = $genMin;
			print "Bstop\n";
		}
		if ($charStop eq "M") {
			$genStop = $maxYposGen;
			print "Mstop\n";
		}
		if ($charStop eq "T") {
			$genStop = $genMax;
			print "Tstop\n";
		}
		if ($genStop > $genStart) { # Direction
			$genInc = +1;
		} else {
			$genInc = -1;
		}
	
		print "movement gen-Start: ".$genStart."\n";
		print "movement gen-Stop: ".$genStop."\n";
		print "movement gen-Inc: ".$genInc."\n";
	
		for ($gen = $genStart; ( ($gen>=$genStop+1)&&($genInc==-1) || ($gen<=$genStop-1)&&($genInc==+1)) ; $gen=$gen+$genInc) {
						         # |stop before last column at down     | stop before last column at up
		print "movement gen-Counter: ".$gen."\n";
			$genInr = $gen - $genMin +1;
	
			print "****\n";
			print "**** Optimierung von Generation ".$genStart." ".$charStart." nach ".$genStop." ".$charStop."\n";
			
			if ($genInc == -1) {
				print "**** in Richtung Kinder\n";
				&assignChildrenToMarriage($gen);
					# $flexInr $fixYpos beinhalten nun Paerchen der Indexnummer von Kindern (flex) und Y-Positionen der Ehen (fix) 
			} else { 
				print "**** in Richtung Eltern\n";
				&assignParentsToMarriage($gen);
					# $flexInr $fixYpos beinhalten nun Paerchen der Indexnummern der Eltern (flex) und Y-Positionen des Mittelwert der Kinder (fix) 
			}
			print "****\n";
	
	
			for $i (1..$genInrSum[$genInr+$genInc]) {
				print "Person-Index: ".$flexInr[$i]." alte Y-Pos: ".$inrYpos[$flexInr[$i]]."\n";
			}
			&moveFrames(1,$genInrSum[$genInr+$genInc]); # parameters define the start and stop value of flexible persons
			for $i (1..$genInrSum[$genInr+$genInc]) {
				print "Person-Index: ".$flexInr[$i]." neue Y-Pos: ".$inrYpos[$flexInr[$i]]."\n";
			}
	
			# Calculate Marriage Y-Position, again regarding the new positions of some frames
			
			&calcMarriageYpos;
		}
	}

	# Rounding of the Y-Position after finishing Calculation and Moving all Frame to the Zero Line

	$yPosMin = $zeroY; # find the minimum Y value after frame movement
	$yPosMinInr = 1; # the index with the minimum Y value below yZero
	$foundFirstYpos = 0;

	for $i (1..$noi) {  # for persons

		$inrYpos[$i] = int($inrYpos[$i] * ($gridFactor/2) + 0.5) / ($gridFactor/2); # rounding of Y-Position
		#print "Loop Minimum Y Pos seachr \n";

		if ( ($inrPlacement[$i] > 0) && ($inrYpos[$i]<$yPosMin) && ($foundFirstYpos == 1) ) { # placed person found below actual Y Pos Minimum
			$yPosMinInr = $i;
			$yPosMin = $inrYpos[$i];
			print "New minimum Y Position found\n";
			print "**** New Minimum Y Posistion found:       ".$yPosMin."\n";
			print "**** New Minimum Y Posistion Index found: ".$yPosMinInr."\n";
		}

		if ( ($inrPlacement[$i] > 0) && ($foundFirstYpos == 0) ) { # first placed person found 
			$yPosMinInr = $i;
			$yPosMin = $inrYpos[$i];
			$foundFirstYpos = 1;
			print "**** First Minimum Y Posistion found:       ".$yPosMin."\n";
			print "**** First Minimum Y Posistion Index found: ".$yPosMinInr."\n";
			
		}
	}
	
	for $i (1..$noi) {  # for persons zeroY position correction
		$inrYpos[$i] = $inrYpos[$i] + ($zeroY - $yPosMin);
	}

	print "**** Minimum Y Posistion found:       ".$yPosMin."\n";
	print "**** Minimum Y Posistion Index found: ".$yPosMinInr."\n";

	# Rounding, Subtracting Half-Y-Size of the marriage frames

	for $i (1..$nom) {  
		print "Couple X-Y-Position 1: ".$inrHusbandMarriage[$i]." ".$inrWifeMarriage[$i]." ".$inrYpos[$j]."\n";
		$j = $i + $noi;
		$inrYpos[$j] = int($inrYpos[$j] * ($gridFactor/2) + 0.5) / ($gridFactor/2); # rounding of Y-Position;
		$inrYpos[$j] = $inrYpos[$j] + ($zeroY - $yPosMin);
		$inrYpos[$j] = $inrYpos[$j] - 0.5 * $marriageY;
	}

}



sub collect_connectors {

	my $j;
	my $toDo;
	my $inrFat;
	my $inrMot;
	my $inrHus;
	my $inrWif;
	my $inr;	
	my $inrMarriage;
	my $yValue1;
	my $yValue2;
	my $yValue3;

	print " **** Add Connectors to the Tree \n";
	
	$noc = 0; # set number of connectors to zero
	
	for $inr (1..$noi) {
		if ($inrGen[$inr] ne "not_in_tree") { # actual person is in the tree
		print "  Active Index: ".$inr."\n";
			$toDo = 2;
			$j = 1;
			while ($toDo > 0) {
				if ($toDo == 2) { # connect from children to marriage symbol or to parents
					$inrFat = $inrFather[$inr];
					$inrMot = $inrMother[$inr];
					print "    Father ".$inrFat."\n";
					print "    Mother ".$inrMot."\n";
					if ( ($inrGen[$inrFat] ne "not_in_tree") && ($inrGen[$inrMot] ne "not_in_tree") ) { # both parents are in the tree
						print "    Active Parents found: ".$inrFat." ".$inrMot."\n";
						if ( defined $marriageHash{$inrFat."_".$inrMot} ) {
							$inrMarriage = $marriageHash{$inrFat."_".$inrMot};
							$noc = $noc + 1;
							$inrConStart[$noc] = $inrMarriage;
							$inrConStop[$noc] = $inr;
							$conFamDefInr[$noc] = $inrMarriage;
							$conType[$noc] = 1;
							$conGenHash{$inrMarriage} = $inrGen[$inr];

							# minimum Ypos Position in Family Connector = start position
							$yValue2 = $inrYpos[$inr]+0.5*$inrYsize[$inr];
							$yValue3 = $inrYpos[$inrMarriage];
							if ( defined $conYstartHash{$inrMarriage} ) {
								$yValue1 = $conYstartHash{$inrMarriage};
								$conYstartHash{$inrMarriage} = min($yValue1,$yValue2,$yValue3);	
							} else {
								$conYstartHash{$inrMarriage} = min($yValue2,$yValue3);	
							}
							# maximum Ypos Position in Family Connector = stop position
							if ( defined $conYstopHash{$inrMarriage} ) {
								$yValue1 = $conYstopHash{$inrMarriage};
								$conYstopHash{$inrMarriage} = max($yValue1,$yValue2,$yValue3);	
							} else {
								$conYstopHash{$inrMarriage} = max($yValue2,$yValue3);	
							}

						} else {
							print " **** ERROR found parents pair which is not in the marriage Hash \n";
							print $inrFat." ".$inrMot."\n";
							exit;
						}
					}
					if ( ($inrGen[$inrFat] ne "not_in_tree") && ($inrGen[$inrMot] eq "not_in_tree")) { # only the father is in the tree
						$noc = $noc + 1;
						$inrConStart[$noc] = $inrFat;
						$inrConStop[$noc] = $inr;
						$conFamDefInr[$noc] = $inrFat;
						$conType[$noc] = 1;
						$conGenHash{$inrFat} = $inrGen[$inr];

						# minimum Ypos Position in Family Connector = start position
						$yValue2 = $inrYpos[$inr]+0.5*$inrYsize[$inr];
						$yValue3 = $inrYpos[$inrFat]+0.5*$inrYsize[$inrFat];
						if ( defined $conYstartHash{$inrFat} ) {
							$yValue1 = $conYstartHash{$inrFat};
							$conYstartHash{$inrFat} = min($yValue1,$yValue2,$yValue3);	
						} else {
							$conYstartHash{$inrFat} = min($yValue2,$yValue3);	
						}
						# maximum Ypos Position in Family Connector = stop position
						if ( defined $conYstopHash{$inrFat} ) {
							$yValue1 = $conYstopHash{$inrFat};
							$conYstopHash{$inrFat} = max($yValue1,$yValue2,$yValue3);	
						} else {
							$conYstopHash{$inrFat} = max($yValue2,$yValue3);	
						}

					}
					if ( ($inrGen[$inrFat] eq "not_in_tree") && ($inrGen[$inrMot] ne "not_in_tree") ) { # only the mother is in the tree
						$noc = $noc + 1;
						$inrConStart[$noc] = $inrMot;
						$inrConStop[$noc] = $inr;
						$conFamDefInr[$noc] = $inrMot;
						$conType[$noc] = 1;
						$conGenHash{$inrMot} = $inrGen[$inr];

						# minimum Ypos Position in Family Connector = start position
						$yValue2 = $inrYpos[$inr]+0.5*$inrYsize[$inr];
						$yValue3 = $inrYpos[$inrMot]+0.5*$inrYsize[$inrMot];
						if ( defined $conYstartHash{$inrMot} ) {
							$yValue1 = $conYstartHash{$inrMot};
							$conYstartHash{$inrMot} = min($yValue1,$yValue2,$yValue3);	
						} else {
							$conYstartHash{$inrMot} = min($yValue2,$yValue3);	
						}
						# maximum Ypos Position in Family Connector = stop position
						if ( defined $conYstopHash{$inrMot} ) {
							$yValue1 = $conYstopHash{$inrMot};
							$conYstopHash{$inrMot} = max($yValue1,$yValue2,$yValue3);	
						} else {
							$conYstopHash{$inrMot} = max($yValue2,$yValue3);	
						}

					}
					if ( ($inrGen[$inrFat] eq "not_in_tree") && ($inrGen[$inrMot] eq "not_in_tree") ) { # no parent are in the tree
						print "No Parents are in the tree";
					}
					$toDo = 1; # Parent finished, now marriages
	
				} else { # $toDo == 1,  connect from parents to marriage symbol
	
					$inrHus = $inrHusband[$inr][$j];
					$inrWif = $inrWife[$inr][$j];
					print "    Husband ".$inrHus."\n";
					print "    Wife ".$inrWif."\n";
					if ( ($inrHus == 0) && ($inrWif == 0) ) { # no further marriages
						$toDo = 0;
						$j = 1;
						print "    No furher Marriage\n";
					} else {
						print "    Active Marriage found: ".$inrHus." ".$inrWif."\n";
						$noc = $noc + 1;
						$inrConStart[$noc] = $inr;
						if ( defined $marriageHash{$inrHus."_".$inrWif} ) {
							if ( ($inrGen[$inrHus] eq "not_in_tree") || ($inrGen[$inrWif] eq "not_in_tree") ) {
								print "    One of the partner of the marriage is not in the tree, so no connector \n";
								$noc = $noc - 1;
								$j = $j + 1;
							} else {
								$inrMarriage = $marriageHash{$inrHus."_".$inrWif};
								$inrConStop[$noc] = $inrMarriage;
								$conFamDefInr[$noc] = $inrMarriage;
								$conType[$noc] = 2;
								$conGenParentHash{$inrMarriage} = $inrGen[$inr];

								# minimum Ypos Position in Family Connector = start position
								$yValue2 = $inrYpos[$inr]+0.5*$inrYsize[$inr];
								$yValue3 = $inrYpos[$inrMarriage];
								if ( defined $conYstartParentHash{$inrMarriage} ) {
									$yValue1 = $conYstartParentHash{$inrMarriage};
									$conYstartParentHash{$inrMarriage} = min($yValue1,$yValue2,$yValue3);	
								} else {
									$conYstartParentHash{$inrMarriage} = min($yValue2,$yValue3);	
								}
								# maximum Ypos Position in Family Connector = stop position
								if ( defined $conYstopParentHash{$inrMarriage} ) {
									$yValue1 = $conYstopParentHash{$inrMarriage};
									$conYstopParentHash{$inrMarriage} = max($yValue1,$yValue2,$yValue3);	
								} else {
									$conYstopParentHash{$inrMarriage} = max($yValue2,$yValue3);	
								}

								$j = $j + 1;
							}
						} else {
							print " **** ERROR found a marriage pair, which is not in the marriage Hash \n";
							print $inrHus." ".$inrWif."\n";
							exit;
						}
					}
				}	
			}
		}
	}
}


sub connectors_ordering {

	my $i;
	my $inrFam;
	my $inrFam2;
	my $gen;
	my $start;
	my $stop;
	my $placedOrder;
	my $placedOrder2;
	my $placed;
	my $overlap;


	# Sorting of Family Connectors, looking for overlaps

        while ( ($inrFam, $start) = each %conYstartHash){ 
		$stop = $conYstopHash{$inrFam};
		$placedOrder = 1;
        	if ( ($inrFam2, $placedOrder2) = each %conPlacedOrderHash )  { # already one placed Connector
			$placed = 0;
			while ( $placed == 0 ) {
				$placed = 1;
    		    		while ( ($inrFam2, $placedOrder2) = each %conPlacedOrderHash ) { 
					if ( ($conGenHash{$inrFam2} == $conGenHash{$inrFam}) && ($placedOrder2 == $placedOrder) ) { # Connectors in same Generation
						$overlap = &isOverlap($conYstartHash{$inrFam2},$conYstopHash{$inrFam2},$conYstartHash{$inrFam},$conYstopHash{$inrFam},0.5*$distCon);
						if ( $overlap == 1 ) {
							# conflict
							$placedOrder = $placedOrder + 1;
							$placed = 0;
						}
					}
				}
			}
			$conPlacedOrderHash{$inrFam} = $placedOrder;
		} else { # no placed connector
			$placed = 1;
			$conPlacedOrderHash{$inrFam} = 1
		}
	}

	# Sorting of Parents Connectors, looking for overlaps

        while ( ($inrFam, $start) = each %conYstartParentHash){ 
		$stop = $conYstopParentHash{$inrFam};
		$placedOrder = 1;
        	if ( ($inrFam2, $placedOrder2) = each %conPlacedOrderParentHash )  { # already one placed Connector
			$placed = 0;
			while ( $placed == 0 ) {
				$placed = 1;
    		    		while ( ($inrFam2, $placedOrder2) = each %conPlacedOrderParentHash ) { 
					if ( ($conGenParentHash{$inrFam2} == $conGenParentHash{$inrFam}) && ($placedOrder2 == $placedOrder) ) { # Connectors in same Generation
						$overlap = &isOverlap($conYstartParentHash{$inrFam2},$conYstopParentHash{$inrFam2},$conYstartParentHash{$inrFam},$conYstopParentHash{$inrFam},-0.5*$distCon);
						if ( $overlap == 1 ) {
							# conflict
							$placedOrder = $placedOrder + 1;
							$placed = 0;
						}
					}
				}
			}
			$conPlacedOrderParentHash{$inrFam} = $placedOrder;
		} else { # no placed connector
			$placed = 1;
			$conPlacedOrderParentHash{$inrFam} = 1
		}
	}

	# seach maximum count in a generation of children connectors

	print "*** Familien Connector Y-Range: \n";	
        while ( ($inrFam, $start) = each %conYstartHash){ 
		$stop = $conYstopHash{$inrFam};
		$placed = $conPlacedOrderHash{$inrFam};
		$gen = $conGenHash{$inrFam};
		print "Index ".$inrFam." gen ".$gen." start ".$start." stop ".$stop." placed ".$placed."\n"; 		
		if (defined $conGenMaxCntHash{$gen}) { 
			$conGenMaxCntHash{$gen} = max($conGenMaxCntHash{$gen},$placed);
		} else {
			$conGenMaxCntHash{$gen} = $placed;
		}
			
	}

	# seach maximum count in a generation of parent connectors

	print "*** Eltern Connector Y-Range: \n";	
        while ( ($inrFam, $start) = each %conYstartParentHash){ 
		$stop = $conYstopParentHash{$inrFam};
		$placed = $conPlacedOrderParentHash{$inrFam};
		$gen = $conGenParentHash{$inrFam};
		print "Index ".$inrFam." gen ".$gen." start ".$start." stop ".$stop." placed ".$placed."\n"; 		
		if (defined $conGenMaxCntParentHash{$gen}) { 
			$conGenMaxCntParentHash{$gen} = max($conGenMaxCntParentHash{$gen},$placed);
		} else {
			$conGenMaxCntParentHash{$gen} = $placed;
		}
	}

	# assigning each connector its placement number

	for $i (1..$noc) {
		if ( $conType[$i] == 1 ) { # children connector
			$conPlaced[$i] = $conPlacedOrderHash{$conFamDefInr[$i]};
			$conMaxCnt[$i] = $conGenMaxCntHash{$conGenHash{$conFamDefInr[$i]}};
		} else {
			if ( $conType[$i] == 2 ) { # parents connector
				$conPlaced[$i] = $conPlacedOrderParentHash{$conFamDefInr[$i]};
				$conMaxCnt[$i] = $conGenMaxCntParentHash{$conGenParentHash{$conFamDefInr[$i]}};
			} else {
				print "**** ERROR no defined connector Type \n";
			}
		}
	}

	#exit;
}

sub isOverlap {

	# checking if the intervals [ystart1:ystop1] and [ystart2:ystop2] having an overlap

	my $yStart1 = shift;
	my $yStop1 = shift;
	my $yStart2 = shift;
	my $yStop2 = shift;
	my $yDist = shift;


	# checking if the start or stop point is in the interval of the other start and stop point

	if ( ($yStart1 > $yStart2 - $yDist) && ($yStart1 < $yStop2 + $yDist) ) {
		return 1;
	}
		
	if ( ($yStop1 > $yStart2 - $yDist) && ($yStop1 < $yStop2 + $yDist) ) {
		return 1;
	}

	
	if ( ($yStart2 > $yStart1 - $yDist) && ($yStart2 < $yStop1 + $yDist) ) {
		return 1;
	}
		
	if ( ($yStop2 > $yStart1 - $yDist) && ($yStop2 < $yStop1 + $yDist) ) {
		return 1;
	}

	return 0;	

}	

sub constructTree {

	#my $txtFileName;
	my $line;
	my $i;
	my $j;
	my $k;
	my $inr;
	my $gen;
	my $inrHus;
	my $inrWif;
	my $inrLastPlaced;
	my $p1;
	my $p2;
	my $p3;
	my $p4;
	my $p5;
	my $scaleDistCon;
	my $p_shift;
	my $yMaxPos=0;
	my $xMaxPos=0;
	my $pageHeightNew;
	my $pageWidthNew;
	my $picFileName;
	my $picPathSystem;
	my $picFileNameSystem;
	my $picFileNameSystemAeOeUeSs;


    	print "**** Calculating the X and Y Position of the Pictures \n";
	if ( ($picPos ne "none") ) {
		for $i (1..$noi) {
			if ($inrGen[$i] ne "not_in_tree") { # Not in tree 
				if ( $picPos eq "top" ) {
					$picXPosHash{$i} = $inrXpos[$i] + 0.5*($inrXsize[$i]-$picXSizeHash{$i});
					$picYPosHash{$i} = $inrYpos[$i] + $frameStyleTopPadding;
				}
				if ( $picPos eq "bottom" ) {
					$picXPosHash{$i} = $inrXpos[$i] + 0.5*($inrXsize[$i]-$picXSizeHash{$i});
					$picYPosHash{$i} = $inrYpos[$i] + $inrYsize[$i] - $inrBotPad[$i] + $frameStyleBotPadding; 
				}
				if ( $picPos eq "left" ) {
					$picXPosHash{$i} = $inrXpos[$i] + $frameStyleLeftPadding; 
					$picYPosHash{$i} = $inrYpos[$i] + $frameStyleTopPadding;
				}
				if ( $picPos eq "right" ) {
					$picXPosHash{$i} = $inrXpos[$i] + $inrXsize[$i] - $inrRightPad[$i] + $frameStyleRightPadding; 
					$picYPosHash{$i} = $inrYpos[$i] + $frameStyleTopPadding;
				}
				#print $inrXpos[$i]."\n";
				#print $inrYpos[$i]."\n";
				#print $picXPosHash{$i}."\n";
				#print $picYPosHash{$i}."\n";
				#exit;
			}
		}
	}
	
	print "*****\n";
	print "***** Create Tree Content.Xml File\n";
	print "*****\n";

	open(OUT, ">$fnContent") || die "Can't open file $fnContent ($!)\n";
	open(OUT2, ">$fnManifest") || die "Can't open file $fnManifest ($!)\n";

	print OUT $lineHeadContent;
	print OUT2 $wordManifest;

	#$wordOdg1; # contains the styles
	#$wordOdg2; # contains the page content."\n";

	print " **** Add Texts into the Tree as Title, Source, Date \n";

	$wordOdg2 = $wordOdg2.$wordTitleStart.$titleText.$wordTitleStop;
	$wordOdg2 = $wordOdg2.$wordDateStart.$dateText.$wordDateStop;
	$wordOdg2 = $wordOdg2.$wordSourceStart.$sourceText.$wordSourceStop;


	print " **** Add Frames into the Tree for each Generation \n";

	for $i (1..$nog) { # go through all generations

		$generationTextXpos = $genXpos[$i];

		print " **** Add Generation Text ".$generationText[$i]." for Generation Index ".$i."\n";
		$wordOdg2 = $wordOdg2.$wordGenerationStartX.$generationTextXpos.$wordGenerationMiddle.$generationText[$i].$wordGenerationStop;
		
		$gen = $i + $genMin -1;
		print " **** Active Generation: ".$gen."\n";
		$inrLastPlaced = 0;
		for $j (1..$genInrSum[$i]) { # go through all placed persons in a generation

			$inr = $genPlcInr[$i][$j]; # index to be placed
			$frameId = "id".$inr;
			
			print "*** Add Frame No. ".$inr."\n";

			$frameWidth = $inrXsize[$inr];
			$frameHeight = $inrYsize[$inr];
			$frameXpos = $inrXpos[$inr];
			$frameYpos = $inrYpos[$inr];
		
			# The following value prevents, that the autogrowth option, reduced the frame to a old off-grid value, when opened by Libre-Office.
			$frameStyleMinHeight = $frameHeight-$inrTopPad[$inr]-$inrBotPad[$inr];

			$yMaxPos = max($yMaxPos, $frameYpos+$frameHeight);
			$xMaxPos = max($xMaxPos, $frameXpos+$frameWidth);

			if ( defined $furtherHash{$inr} ) { # this person will get the "further"-symbol
				if ( $furtherHash{$inr} eq "further" ) { # this person will get the "further"-symbol
					$wordOdg2 = $wordOdg2.$wordFurtherStyle;
					$wordOdg2 = $wordOdg2.$furtherStyle;
					$wordOdg2 = $wordOdg2.$wordFurtherIdXml;
					$wordOdg2 = $wordOdg2.$frameId;		# Hier wird die momentane Frame-ID benutzt
					$wordOdg2 = $wordOdg2.$wordFurtherId;
					$wordOdg2 = $wordOdg2.$frameId;		# Hier wird die momentane Frame-ID benutzt
					$wordOdg2 = $wordOdg2.$wordFurtherWidth;
					$wordOdg2 = $wordOdg2.$inrXsize[$inr];		# Das Further-Symbol ist immer so breit wie ein normaler Frame, hier der erste als Beispiel
					$wordOdg2 = $wordOdg2.$wordFurtherHeight;
					$wordOdg2 = $wordOdg2.$furtherHeight;
					$wordOdg2 = $wordOdg2.$wordFurtherXpos;
					$wordOdg2 = $wordOdg2.$frameXpos;     # $furtherXpos;
					$wordOdg2 = $wordOdg2.$wordFurtherYpos;
					$wordOdg2 = $wordOdg2.$frameYpos;
					$wordOdg2 = $wordOdg2.$wordFurtherText;
					# Anfuegen des "moreText"
					if ( defined $furtherTextHash{$inr} ) { # this person will get a "further"-Text
						$line = $furtherTextHash{$inr}; # Weiter Text
						$wordOdg2 = $wordOdg2.$line;
					} else {
						$wordOdg2 = $wordOdg2.$furtherText;		# Dieser Text stammt aus der tree-size-Datei.
					}
					$wordOdg2 = $wordOdg2.$wordFurtherEnd;

				} else { # person appears in the More-Frame

					# A new Frame need its own Style
					$wordOdg1 = $wordOdg1.$wordFrameMoreStyleStart;  # <style:style ...
					$wordOdg1 = $wordOdg1.$frameMoreStyle.$frameId;
					$wordOdg1 = $wordOdg1.$wordFrameMoreStyleMinHeight;
					$wordOdg1 = $wordOdg1.$frameStyleMinHeight;
					$wordOdg1 = $wordOdg1.$wordFrameMoreStyleTopPadding;
					$wordOdg1 = $wordOdg1.$inrTopPad[$inr];
					print "Top Padding More Frame: ".$inrTopPad[$inr]."No. ".$inr."\n";
					$wordOdg1 = $wordOdg1.$wordFrameMoreStyleBotPadding;
					$wordOdg1 = $wordOdg1.$inrBotPad[$inr];
					$wordOdg1 = $wordOdg1.$wordFrameMoreStyleLeftPadding;
					$wordOdg1 = $wordOdg1.$inrLeftPad[$inr];
					print "Left Padding More Frame: ".$inrLeftPad[$inr]."No. ".$inr."\n";
					$wordOdg1 = $wordOdg1.$wordFrameMoreStyleRightPadding;
					$wordOdg1 = $wordOdg1.$inrRightPad[$inr];
					$wordOdg1 = $wordOdg1.$wordFrameMoreStyleEnd;   #  <\style:style>
	
					# Frame Start
					$wordOdg2 = $wordOdg2.$wordFrameStyle;
					$wordOdg2 = $wordOdg2.$frameMoreStyle.$frameId;	# Hier wird zum Frame-Style-Namen noch die ID rangehaengt, fuer eine Individualisierung
					$wordOdg2 = $wordOdg2.$wordFrameMoreIdXml;
					$wordOdg2 = $wordOdg2.$frameId;			# Hier wird die momentane Frame-ID benutzt
					$wordOdg2 = $wordOdg2.$wordFrameMoreId;
					$wordOdg2 = $wordOdg2.$frameId;			# Hier wird die momentane Frame-ID benutzt
					$wordOdg2 = $wordOdg2.$wordFrameMoreWidth;
					$wordOdg2 = $wordOdg2.$frameWidth;
					$wordOdg2 = $wordOdg2.$wordFrameMoreHeight;
					$wordOdg2 = $wordOdg2.$frameHeight;
					$wordOdg2 = $wordOdg2.$wordFrameMoreXpos;
					$wordOdg2 = $wordOdg2.$frameXpos;
					$wordOdg2 = $wordOdg2.$wordFrameMoreYpos;
					$wordOdg2 = $wordOdg2.$frameYpos;
					$wordOdg2 = $wordOdg2.$wordFrameMoreEnd;
	
					# Frame Core Information from PersonData Array
	
					$wordOdg2 = $wordOdg2.$wordFrameParagraphStyle;  # Einlesen des Namens
					$wordOdg2 = $wordOdg2.$wordFramePrerufStyle;
					$line = $personData[$inr][1]; # Preruf
					$wordOdg2 = $wordOdg2.$line;
					$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
					$wordOdg2 = $wordOdg2.$wordFrameRufStyle;
					$line = $personData[$inr][2]; # Ruf
					$wordOdg2 = $wordOdg2.$line;
					$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
					$wordOdg2 = $wordOdg2.$wordFramePrerufStyle;
					$line = $personData[$inr][3]; # Post-Ruf
					$wordOdg2 = $wordOdg2.$line;
					$line = $personData[$inr][4]; # Nachname
					if ( $line =~ m/(.*?)(#.*)/ ) {	# Einfuegen eines zusaetzlichen Leerzeichens, wenn Index-Nr. hinter Nachname
						$line = $1."<text:s/>".$wordFrameTextEnd.$wordFrameIndexNummerStyle.$2;
					}
					$wordOdg2 = $wordOdg2." ".$line;
					$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
					$wordOdg2 = $wordOdg2.$wordFrameParagraphEnd;
	
					for $k (5 .. $imaxArray[$inr]) {		# Anfuegen der restlichen Informationen
						$wordOdg2 = $wordOdg2.$wordFrameParagraphStyle;
						$line = $personData[$inr][$k]; 
						if ( $line =~ m/(#[0-9]+)/ ) {	# Es gibt eine Index-Nummer
							$wordOdg2 = $wordOdg2.$wordFrameIndexNummerStyle;
							$wordOdg2 = $wordOdg2.$line;
							$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
						} else {
							$wordOdg2 = $wordOdg2.$wordFrameRestStyle;
							$wordOdg2 = $wordOdg2.$line;
							$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
						}
						$wordOdg2 = $wordOdg2.$wordFrameParagraphEnd;
					}
					# Anfuegen des "moreText"
					if ( defined $furtherTextHash{$inr} ) { # this person will get a "further"-Text
						$wordOdg2 = $wordOdg2.$wordFrameParagraphStyle;  # Einlesen des Namens
						$wordOdg2 = $wordOdg2.$wordFramePrerufStyle;
						$line = $furtherTextHash{$inr}; # Weiter Text
						$wordOdg2 = $wordOdg2.$line;
						$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
						$wordOdg2 = $wordOdg2.$wordFrameParagraphEnd;
					}
	
					# Frame Stop
					$wordOdg2 = $wordOdg2.$wordFrameMoreStop;
				}

			} else { # person appear with its own frame, no further-symbol
				# A new Frame need its own Style
				$wordOdg1 = $wordOdg1.$wordFrameStyleStart;  # <style:style ...
				$wordOdg1 = $wordOdg1.$frameStyle.$frameId;
				$wordOdg1 = $wordOdg1.$wordFrameStyleMinHeight;

				$wordOdg1 = $wordOdg1.$frameStyleMinHeight;
				$wordOdg1 = $wordOdg1.$wordFrameStyleTopPadding;
				$wordOdg1 = $wordOdg1.$inrTopPad[$inr];
				$wordOdg1 = $wordOdg1.$wordFrameStyleBotPadding;
				$wordOdg1 = $wordOdg1.$inrBotPad[$inr];
				$wordOdg1 = $wordOdg1.$wordFrameStyleLeftPadding;
				$wordOdg1 = $wordOdg1.$inrLeftPad[$inr];
				$wordOdg1 = $wordOdg1.$wordFrameStyleRightPadding;
				$wordOdg1 = $wordOdg1.$inrRightPad[$inr];
				$wordOdg1 = $wordOdg1.$wordFrameStyleEnd;   #  <\style:style>

				# Frame Start
				$wordOdg2 = $wordOdg2.$wordFrameStyle;
				$wordOdg2 = $wordOdg2.$frameStyle.$frameId;	# Hier wird zum Frame-Style-Namen noch die ID rangehängt, fuer eine Individualisierung
				$wordOdg2 = $wordOdg2.$wordFrameIdXml;
				$wordOdg2 = $wordOdg2.$frameId;			# Hier wird die momentane Frame-ID benutzt
				$wordOdg2 = $wordOdg2.$wordFrameId;
				$wordOdg2 = $wordOdg2.$frameId;			# Hier wird die momentane Frame-ID benutzt
				$wordOdg2 = $wordOdg2.$wordFrameWidth;
				$wordOdg2 = $wordOdg2.$frameWidth;
				$wordOdg2 = $wordOdg2.$wordFrameHeight;
				$wordOdg2 = $wordOdg2.$frameHeight;
				$wordOdg2 = $wordOdg2.$wordFrameXpos;
				$wordOdg2 = $wordOdg2.$frameXpos;
				$wordOdg2 = $wordOdg2.$wordFrameYpos;
				$wordOdg2 = $wordOdg2.$frameYpos;
				$wordOdg2 = $wordOdg2.$wordFrameEnd;

				# Frame-More-Core-Information = Frame-Mode-Core-Information from PersonData Array

				$wordOdg2 = $wordOdg2.$wordFrameParagraphStyle;  # Stil des Namens
				$wordOdg2 = $wordOdg2.$wordFramePrerufStyle;
				$line = $personData[$inr][1]; # Preruf
				$wordOdg2 = $wordOdg2.$line;
				$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
				$wordOdg2 = $wordOdg2.$wordFrameRufStyle;
				$line = $personData[$inr][2]; # Ruf
				$wordOdg2 = $wordOdg2.$line;
				$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
				$wordOdg2 = $wordOdg2.$wordFramePrerufStyle;
				$line = $personData[$inr][3]; # Post-Ruf
				$wordOdg2 = $wordOdg2.$line;
				$line = $personData[$inr][4]; # Nachname
				if ( $line =~ m/(.*?)(#.*)/ ) {	# Einfuegen eines zusaetzlichen Leerzeichens, wenn Index-Nr. hinter Nachname
					$line = $1."<text:s/>".$wordFrameTextEnd.$wordFrameIndexNummerStyle.$2;
				}
				$wordOdg2 = $wordOdg2." ".$line;
				$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
				$wordOdg2 = $wordOdg2.$wordFrameParagraphEnd;

				for $k (5 .. $imaxArray[$inr]) {		# Anfuegen der restlichen Informationen
					$wordOdg2 = $wordOdg2.$wordFrameParagraphStyle;
					$line = $personData[$inr][$k]; 
					if ( $line =~ m/(#[0-9]+)/ ) {	# Es gibt eine Index-Nummer
						$wordOdg2 = $wordOdg2.$wordFrameIndexNummerStyle;
						$wordOdg2 = $wordOdg2.$line;
						$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
					} else {
						$wordOdg2 = $wordOdg2.$wordFrameRestStyle;
						$wordOdg2 = $wordOdg2.$line;
						$wordOdg2 = $wordOdg2.$wordFrameTextEnd;
					}
					$wordOdg2 = $wordOdg2.$wordFrameParagraphEnd;
				}

				# Frame Stop
				$wordOdg2 = $wordOdg2.$wordFrameStop;
			}
		}
	}

	print " **** Add Marriage Symbol into the Tree \n";

	for $i (1..$nom) {  # place a symbol for all marriages

		# calculate position as average between the two partners

		$j = $i + $noi;
		$inrHus = $inrHusbandMarriage[$i];
		$inrWif = $inrWifeMarriage[$i];
		if ( ( $inrGen[$inrHus] eq "not_in_tree") || ( $inrGen[$inrWif] eq "not_in_tree") ) {
			print "**** In a couple, the person ".$inrHus." or ".$inrWif." are not in the tree. Marriage Symbol skipped. \n";
		} else {
			print "Couple X-Y-Position 2: ".$inrHus." ".$inrWif." ".$inrYpos[$j]."\n";
			$frameId = "id".$j;
			$inrXsize[$j] = $marriageX;
			$inrYsize[$j] = $marriageY;
			$frameWidth = $inrXsize[$j];
			$frameHeight = $inrYsize[$j];
			$frameXpos = $inrXpos[$j];
			$frameYpos = $inrYpos[$j];

			# print $wordMarriageStart by the following commands	
			$wordOdg2 = $wordOdg2.$wordMarriageStyle;
			$wordOdg2 = $wordOdg2.$marriageStyle;
			$wordOdg2 = $wordOdg2.$wordMarriageIdXml;
			$wordOdg2 = $wordOdg2.$frameId;
			$wordOdg2 = $wordOdg2.$wordMarriageId;
			$wordOdg2 = $wordOdg2.$frameId;
			$wordOdg2 = $wordOdg2.$wordMarriageWidth;
			$wordOdg2 = $wordOdg2.$marriageX;
			$wordOdg2 = $wordOdg2.$wordMarriageHeight;
			$wordOdg2 = $wordOdg2.$marriageY;
			$wordOdg2 = $wordOdg2.$wordMarriageXpos;
			$wordOdg2 = $wordOdg2.$frameXpos;
			$wordOdg2 = $wordOdg2.$wordMarriageYpos;
			$wordOdg2 = $wordOdg2.$frameYpos;
			$wordOdg2 = $wordOdg2.$wordMarriageEnd;

			if ( defined $partnerShipHash{$inrHus."_".$inrWif} ) {
				$wordOdg2 = $wordOdg2.$wordPartnerShipCore;
				#print "test2\n".$wordPartnerShipCore."\n".$wordMarriageCore."\n"; exit;
			} else {
				$wordOdg2 = $wordOdg2.$wordMarriageCore;
			}
			$wordOdg2 = $wordOdg2.$wordMarriageStop;
		}
	}


	print "**** Add Connectors to the Tree\n";	

	print "Number of found Connectors: ".$noc."\n";	

	for $j (1..$noc) { # loop for connector creation

		print "    Connect ".$inrConStart[$j]." with ".$inrConStop[$j]."\n";

		if ( $treeOrientation eq "yo" ) { # young left, old right
			$conX1 = $inrXpos[$inrConStart[$j]];
			$conX2 = $inrXpos[$inrConStop[$j]]+$inrXsize[$inrConStop[$j]];
		} else {                          # young right, old left
			$conX1 = $inrXpos[$inrConStart[$j]]+$inrXsize[$inrConStart[$j]];
			$conX2 = $inrXpos[$inrConStop[$j]];
		}	
		$conY1 = $inrYpos[$inrConStart[$j]]+$inrYsize[$inrConStart[$j]]/2;
		$conY2 = $inrYpos[$inrConStop[$j]]+$inrYsize[$inrConStop[$j]]/2;
		$p1 = $conX1*1000; # start X-coordinate
		$p2 = $conY1*1000; # start Y-coordinate
		$p4 = ($conY2-$conY1)*1000; # distance in Y-direction

		# calculate horizontal pathes
		if ($conType[$j] == 1) { # from children to marriage symbol
			$scaleDistCon = 2;
			while ( ($conMaxCnt[$j]-1)*$distCon*$scaleDistCon > ($dXchanChild - 3.99 * $distCon) ) { # check if enough space for the connectors
				$scaleDistCon = $scaleDistCon * 0.5;
			}
		} else {
			if ( $conType[$j] == 2) { # from parents to marriage symbol
				$scaleDistCon = 2;
				while ( ($conMaxCnt[$j]-1)*$distCon*$scaleDistCon > ($dXchanParent - 3.99 * $distCon) ) { # check if enough space for the connectors
					$scaleDistCon = $scaleDistCon * 0.5;
				}
			} else {
				print "**** Error: Not correct Connector Type Definition.\n";
				exit;
			}
		}

		$p_shift = $distCon*($scaleDistCon*($conPlaced[$j]-1)+2); # placement position of the connector
		if ( $treeOrientation eq "yo" ) { # young left, old right
			$p3 = ( $conX2 - $conX1 + $p_shift ) * 1000;
			$p5 = -$p_shift * 1000;
		} else {                          # young right, old left
			$p3 = ( $conX2 - $conX1 - $p_shift ) * 1000;
			$p5 = +$p_shift * 1000;
		}	
	
		# rounding
		$p1 = int( $p1 + 0.5 * &sign($p1) );
		$p2 = int( $p2 + 0.5 * &sign($p2) );
		$p3 = int( $p3 + 0.5 * &sign($p3) );
		$p4 = int( $p4 + 0.5 * &sign($p4) );
		$p5 = int( $p5 + 0.5 * &sign($p5) );
		$conPath = "m".$p1." ".$p2."h".$p3."v".$p4."h".$p5;
		$conSkew = ($p3 - ($p3+$p5)/2)/1000;   # the skew is the difference of the X-position verical part to the mean value of the complete horizontal distance 

		#print $conX1." ".$conY1." ".$conX2." ".$conY2."\n";

		$wordOdg2 = $wordOdg2.$wordConDef." draw:layer=\"layout\" ";
		$wordOdg2 = $wordOdg2.$wordConSkew;
		$wordOdg2 = $wordOdg2."\"".$conSkew."cm\" ";
		$wordOdg2 = $wordOdg2.$wordConX1;
		$wordOdg2 = $wordOdg2."\"".$conX1."cm\" ";
		$wordOdg2 = $wordOdg2.$wordConY1;	
		$wordOdg2 = $wordOdg2."\"".$conY1."cm\" ";
		$wordOdg2 = $wordOdg2.$wordConX2;
		$wordOdg2 = $wordOdg2."\"".$conX2."cm\" ";
		$wordOdg2 = $wordOdg2.$wordConY2;	
		$wordOdg2 = $wordOdg2."\"".$conY2."cm\" ";
		$wordOdg2 = $wordOdg2.$wordConStartSh;
		$wordOdg2 = $wordOdg2."\"id".$inrConStart[$j]."\" "; #$conStartSh;
		$wordOdg2 = $wordOdg2.$wordConStartShGl;
		$wordOdg2 = $wordOdg2."\"".$startGluePoint."\" "; #$conStartShGl;
		$wordOdg2 = $wordOdg2.$wordConStopSh;
		$wordOdg2 = $wordOdg2."\"id".$inrConStop[$j]."\" "; #$conStopSh;
		$wordOdg2 = $wordOdg2.$wordConStopShGl;
		$wordOdg2 = $wordOdg2."\"".$stopGluePoint."\" "; #$conStopShGl;
		$wordOdg2 = $wordOdg2.$wordConPath;
		$wordOdg2 = $wordOdg2."\"".$conPath."\"";
		$wordOdg2 = $wordOdg2.$wordConEnd;

		$wordOdg2 = $wordOdg2.$wordConnectorCore; 
		$wordOdg2 = $wordOdg2.$wordConnectorStop; 
	}

	print "**** Add Picture to the Tree\n";	

	if ( $picPos ne "none" ) { # Fotos einfuegen, wennnicht "none"
		while ( ($inr, $picFileName) = each %picFileNameHash ) {
			if ( $inrPicYesNo[$inr] eq "yes" ) {
			
				# Styles to Word 1
				$wordOdg1 = $wordOdg1."<style:style ";
				# Style Namen
				$wordOdg1 = $wordOdg1."style:name=\"grPic".$inr."\" ";
				$wordOdg1 = $wordOdg1."style:family=\"graphic\" ";
				$wordOdg1 = $wordOdg1."style:parent-style-name=\"standard\">";
				$wordOdg1 = $wordOdg1."<style:graphic-properties ";
				$wordOdg1 = $wordOdg1."draw:stroke=\"none\" ";
				$wordOdg1 = $wordOdg1."draw:fill=\"none\" ";
				$wordOdg1 = $wordOdg1."draw:textarea-horizontal-align=\"center\" ";
				$wordOdg1 = $wordOdg1."draw:textarea-vertical-align=\"middle\" ";
				$wordOdg1 = $wordOdg1."draw:color-mode=\"standard\" ";
				$wordOdg1 = $wordOdg1."draw:luminance=\"0%\" draw:contrast=\"0%\" ";
				$wordOdg1 = $wordOdg1."draw:gamma=\"100%\" draw:red=\"0%\" ";
				$wordOdg1 = $wordOdg1."draw:green=\"0%\" ";
				$wordOdg1 = $wordOdg1."draw:blue=\"0%\" ";
				# Beschneidung des Fotos
				$wordOdg1 = $wordOdg1."fo:clip=\"rect(";
				$wordOdg1 = $wordOdg1.$picCutTopHash{$inr}."cm, ";
				$wordOdg1 = $wordOdg1.$picCutRightHash{$inr}."cm, ";
				$wordOdg1 = $wordOdg1.$picCutBottomHash{$inr}."cm, ";
				$wordOdg1 = $wordOdg1.$picCutLeftHash{$inr}."cm)\" ";
				$wordOdg1 = $wordOdg1."draw:image-opacity=\"100%\" ";
				$wordOdg1 = $wordOdg1."style:mirror=\"none\"/>";
				$wordOdg1 = $wordOdg1."</style:style>";
	
				# Pictures Kopieren
				$picPathSystem = &utf8_to_WinLin($picPathHash{$inr});         # UTF8 Umlaute durch DOS Umlaute ersetzen
				$picFileNameSystem = &utf8_to_WinLin($picFileNameHash{$inr}); # UTF8 Umlaute durch DOS Umlaute ersetzen
				$picFileNameSystemAeOeUeSs = &utf8_to_aeoeuess($picFileNameHash{$inr}); # UTF8 Umlaute durch Ae-Oe-Ue-SS Umlaute ersetzen
	        		if ( $^O eq "MSWin32") {  # Window Operating System
	  				print "Window Operating System @ copy Pictures\n";
					print "copy \"".$picPathSystem."\\".$picFileNameSystem."\" \"\%\$workOdgDir\%Pictures"."\\".$picFileNameSystemAeOeUeSs."\"\n";
					system("copy \"".$picPathSystem."\\".$picFileNameSystem."\" \"\%\$workOdgDir\%Pictures"."\\".$picFileNameSystemAeOeUeSs."\"");
					#exit;
				} else {
					print "Linux Cygwin or MAC Operating System @ copy Pictures\n";
					system("cp \"".$picPathSystem."\/".$picFileNameSystem."\" \"\$workOdgDir/Pictures"."\/".$picFileNameSystemAeOeUeSs."\"");
					#system("cp \"".$picPathSystem."\/".$picFileNameSystem."\" \$workOdgDir/Pictures");
				}

				# Frames to Word 2
	
				$wordOdg2 = $wordOdg2."<draw:frame draw:style-name=";
				$wordOdg2 = $wordOdg2."\"grPic".$inr."\" "; 
				$wordOdg2 = $wordOdg2."draw:text-style-name=\"P1\" ";
				$wordOdg2 = $wordOdg2."draw:layer=\"layout\" ";
				$wordOdg2 = $wordOdg2."svg:width=\"".$picXSizeHash{$inr}."cm\" ";
				$wordOdg2 = $wordOdg2."svg:height=\"".$picYSizeHash{$inr}."cm\" ";
				$wordOdg2 = $wordOdg2."svg:x=\"".$picXPosHash{$inr}."cm\" ";
				$wordOdg2 = $wordOdg2."svg:y=\"".$picYPosHash{$inr}."cm\">";
	
				#$wordOdg2 = $wordOdg2."<draw:image xlink:href=\"Pictures/".$picFileNameHash{$inr}."\" ";
				$wordOdg2 = $wordOdg2."<draw:image xlink:href=\"Pictures/".$picFileNameSystemAeOeUeSs."\" ";
				$wordOdg2 = $wordOdg2."xlink:type=\"simple\" ";
				$wordOdg2 = $wordOdg2."xlink:show=\"embed\" ";
				$wordOdg2 = $wordOdg2."xlink:actuate=\"onLoad\">";
				$wordOdg2 = $wordOdg2."<text:p/></draw:image></draw:frame>";
	
				# Picture register in the Manifest File

				print OUT2 " <manifest:file-entry manifest:full-path=\"";
				#print OUT2 "Pictures/".$picFileNameHash{$inr}."\"";
				print OUT2 "Pictures/".$picFileNameSystemAeOeUeSs."\""; # keine Sonderzeichen im Meta-File
				print OUT2 " manifest:media-type=\"\"/>";
				print OUT2 "\n"; # print newline 
			}
		}
	}


	
	# finish the odg content file

	$wordOdg1 = $wordOdg1.$wordOdg1End;
	
	print OUT $wordOdg1; #."\n"; # all style informations
	print OUT $wordOdg2; #."\n"; # start of page and all new grafic informations
	print OUT $wordOdg4; #."\n"; # end of page
	print OUT $wordOdg5; #."\n"; # end of document of content.xml

	print OUT2 "</manifest:manifest>";

	close(OUT);
	close(OUT2);

	if ($picPos eq "none") { # orginal Manifest.xlm benutzen
       		if ( $^O eq "MSWin32") {  # Window Operating System
 			print "Window Operating System @ copy Orginal Manifest\n";
			system("copy /Y manifest_example.xml manifest.xml");
		} else {
			print "Linux Cygwin or MAC Operating System @ copy Orginal Manifest\n";
			system("cp manifest_example.xml manifest.xml");
		}
	}


	print "*****\n";
	print "***** Create Tree Styles.Xml File\n";
	print "*****\n";

	open(OUT, ">$fnStyles") || die "Can't open file $fnStyles ($!)\n";

	$pageHeightNew = max($pageHeight,int($yMaxPos+5));
	$pageWidthNew = max($pageWidth,int($xMaxPos+5));

	print OUT $lineHeadStyles;
	print OUT $wordPageWidth; #."\n";
	print OUT $pageWidthNew;
	print OUT $wordPageHeight; #."\n";
	print OUT $pageHeightNew;
	print OUT $wordPageEnd; #."\n";
	
	close(OUT);

}

sub sign {
	my $realNumber = shift;
	if ($realNumber > 0) {
		return 1;
	}
	if ($realNumber < 0) {
		return -1;
	}
	if ($realNumber == 0) {
		return 0;
	} else {
		print "**** ERROR No sign found \n";
		exit;
	}
}

sub beBrotherOrSister {
	my $inr1 = shift; # Index 1
	my $inr2 = shift; # Index 2

	if ( ($inrFather[$inr1] == $inrFather[$inr2]) && ($inrFather[$inr1] != 0) ) {
		return 1;  # the same father
	}

	if ( ($inrMother[$inr1] == $inrMother[$inr2]) && ($inrMother[$inr1] != 0) ) {
		return 1;  # the same mother
	}

	return 0;  # not the same parents
	
}	

sub beMarried {
	my $inr1 = shift; # Index 1
	my $inr2 = shift; # Index 2
	if ( (defined $marriageHash{$inr1."_".$inr2}) || (defined $marriageHash{$inr2."_".$inr1}) ) { 
		return 1;  # married
	} else {
		return 0;  # not married
	}
}	

sub beBrotherOrSisterInLaw {
	my $inr1 = shift; # Index 1
	my $inr2 = shift; # Index 2
	if ( $inrA2P[$inr1] != 0 ) { # Index1 is married to someone
		if ( &beBrotherOrSister($inrA2P[$inr1], $inr2) == 1 ) {
			return 1;  # brother or sister in law
		}
	}
	if ( $inrA2P[$inr2] != 0 ) { # Index2 is married to someone
		if ( &beBrotherOrSister($inrA2P[$inr2], $inr1) == 1 ) {
			return 1;  # brother or sister in law
		}
	}
	if ( ($inrA2P[$inr1] != 0) && ($inrA2P[$inr2] != 0) ) { # Index 1&2 is married to someone
		if ( &beBrotherOrSister($inrA2P[$inr1], $inrA2P[$inr2]) == 1 ) {
			return 1;  # brother or sister in law
		}
	} else {
		return 0;  # not brother or sister in law
	}
}	

sub calcSpringMatrix {
	my $reference_auf_fix = shift;  # reference to array "fix"
	my $reference_auf_flex = shift; # reference to array "flex"
	my $cnt = shift;
	my @fix; 	# positions of the fixed element
	my @flex; 	# starting position of the moving element
	my @tension;	# mechnical tension in the moving element
	my @new_flex;   # new position of the moving element after balance of all forces
	my @results;	# array of two references (one to array "tension", one to array "new_free")
	my $i;
	my $j;
	my @dFix;	# difference of one fix position to the next
	my @dFlex;	# difference of one flex position to the next
	my @dFF;	# difference of dFlex and dFix
	my @force;	# force (=distance) from the free position to fix position

	#prepare input values by dereferencing 
	@fix  = @{$reference_auf_fix};   # create an local array from a reference
	@flex = @{$reference_auf_flex};  # create an local array from a reference
	print "**** Funktion calcSpringMatrix:\n";
	for $i (1..$cnt) {
		print "fix ".$fix[$i]." flex ".$flex[$i]."\n";
	}

	# calculate the differences	
	for $i (1..$cnt-1) {
		$dFix[$i] = $fix[$i+1] - $fix[$i];
		$dFlex[$i] = $flex[$i+1] - $flex[$i];
		$dFF[$i] = $dFlex[$i] - $dFix[$i];
		print "dFix[".$i."]= ".$dFix[$i]." dFlex[".$i."]= ".$dFlex[$i]." dFF[".$i."]= ".$dFF[$i]."\n";
	}

	# calculate the balance of forces (force is equal to distance of the spring)
	for $i (1..$cnt) {
		print "Coefficient for Summand ".$i.": ";
		$force[$i] = 0;  # in case of only element, the force becomes zero
		for $j (1..$cnt-1) {
			if ($i > $j) {
				$force[$i] = $force[$i] - $j*$dFF[$j]/$cnt;
				print "Neg ".(-$j)." ";
			} else {
				$force[$i] = $force[$i] + ($cnt-$j)*$dFF[$j]/$cnt;
				print "Pos ".($cnt-$j)." ";
			}
		}
		print "\n";
	}

	# calculate the balance distance into new flex positions
	for $i (1..$cnt) {
		$new_flex[$i] = $fix[$i] - $force[$i]; # from the fix position the new flex position can be calculated by subtrace the force
		if ($i == 1) {
			$tension[1] = $force[1]; # initialize the tension
		} else {
			$tension[$i] = $tension[$i-1] + $force[$i]; # the tension is the integral of the forces
		}
		print "tension[".$i."] = ".$tension[$i]."\n";
	}

	# check balance
	if ( ($tension[$cnt] < -1E-10) && ($tension[$cnt] > +1E-10) ) { # range um null herun wegen Rundungsfehlern
		print "**** \n";
		print "**** Error: no force balance is achieved \n";
		print "**** \n";
		print "**** EXIT \n";
		print "**** \n";
		exit;
	}


	# prepare return values
	$results[1] = \@new_flex;	# create first array reference
	$results[2] = \@tension;	# create second array reference
	return \@results;	
}

sub findMostNegativeTension {
	# cuts are positions, where the tensions is mostly negative.
	# ordering by the most negativ tensions
	my $start = shift;
	my $stop = shift;
	my @tensionOrder;
	my $i;
	my $j;
	my $cnt;

	$cnt = $stop - $start + 1;
	$tensionOrder[1] = 1;
	for $i (2..$cnt) { # sorting for the smalltest cut
		$j=$i;
		while ( ($inrTension[$tensionOrder[$j-1]+$start-1] > $inrTension[$i+$start-1]) && ($j > 1) ) { # shift the next tension to the actual position
			$tensionOrder[$j] = $tensionOrder[$j-1];
			$j = $j - 1;
		}
		$tensionOrder[$j]= $i;
	}

	return \@tensionOrder;
}

sub assignChildrenToMarriage {

	my $gen = shift;
	my $i;
	my $j;
	my $inr;
	my $father;
	my $mother;

	print "**** Funktion assignChildrenToMarriage\n";
	$i = $gen - $genMin + 1 -1;
	print "Anzahl der Kinder ".$genInrSum[$i]." in Generation ".$gen."\n";
	for $j (1..$genInrSum[$i]) {  # Durchlaufe die Schleife fuer alle Kinder
		$inr = $genPlcInr[$i][$j];
		$flexInr[$j] = $inr;
		$father = $inrFather[$inr];	
		$mother = $inrMother[$inr];
		print "inr ".$inr." father ".$father." mother ".$mother."\n";

		if ( ($inrGen[$father] eq "not_in_tree") && ($inrGen[$mother] eq "not_in_tree") ) { # no parents in tree
			$fixYpos[$j] = "flex_person_has_no_fix_partner";  # than means not parents
		}
		if ( ($inrGen[$father] ne "not_in_tree") && ($inrGen[$mother] ne "not_in_tree") ) { # there are parents in tree
			if ( defined $marriageHash{$father."_".$mother} ) {
	 			$fixYpos[$j] = $inrYpos[$marriageHash{$father."_".$mother}]; # Y-Position of marriage,
			} else {
				print " **** ERROR didn't parent of a children in subroutine assignChildrenToMarriage\n";
				print $father." ".$mother."\n";
				exit;
			}
		}
		if ( ($inrGen[$father] ne "not_in_tree") && ($inrGen[$mother] eq "not_in_tree") ) { # mother not in tree
			$fixYpos[$j] = $inrYpos[$inrFather[$inr]]+0.5*$inrYsize[$inrFather[$inr]];
		}
		if ( ($inrGen[$father] eq "not_in_tree") && ($inrGen[$mother] ne "not_in_tree") ) { # father not in tree
			$fixYpos[$j] = $inrYpos[$inrMother[$inr]]+0.5*$inrYsize[$inrMother[$inr]];
		}
	}
}

sub assignParentsToMarriage {

	my $gen = shift;
	my $i;
	my $j;
	my $inr;
	my $father;
	my $mother;
	my @fatherYpullAvg;
	my @motherYpullAvg;
	my @fatherYpullCnt;
	my @motherYpullCnt;


	print "**** Funktion assignParentsToMarriage\n";

	# Count Values initialisieren
	for $j (0..$noi) {
		$parentsYpullCnt[$i]=0;
		$parentsYpullAvg[$i]=0;
	}

	$i = $gen - $genMin + 1 ;  # Kindergeneration (fixed Generation)
	for $j (1..$genInrSum[$i]) {  # Durchlaufe die Schleife fuer alle Kinder, um den Mittelwert der Kinder zu berechnen
		$inr = $genPlcInr[$i][$j];
		$father = $inrFather[$inr];	
		$mother = $inrMother[$inr];
		print "Kind: ".$inr." Vater: ".$father." Mutter: ".$mother."\n";
		$parentsYpullAvg[$father] = $parentsYpullAvg[$father] + $inrYpos[$inr] + 0.5*$inrYsize[$inr];
		$parentsYpullCnt[$father] = $parentsYpullCnt[$father] + 1;
		$parentsYpullAvg[$mother] = $parentsYpullAvg[$mother] + $inrYpos[$inr] + 0.5*$inrYsize[$inr];
		$parentsYpullCnt[$mother] = $parentsYpullCnt[$mother] + 1;
	}

	# Durchschnitt berechnen bei den Eltern
	
	for $j (1..$noi) {
		if ($parentsYpullCnt[$j] > 1.5) {
			$parentsYpullAvg[$j] = $parentsYpullAvg[$j] / $parentsYpullCnt[$j];
		}
	}

	$i = $gen - $genMin + 1 + 1; # Eltern Generation
	for $j (1..$genInrSum[$i]) {  # Durchlaufe die Schleife fuer alle Eltern und finde deren Zugpunkt bei den Kindern
		$inr = $genPlcInr[$i][$j];
		$flexInr[$j] = $inr;
		print "Eltern Indizes ".$inr."\n";

		if ( $parentsYpullCnt[$inr] > 0.5 ) { # es gibt einen Zugpunkt
			$fixYpos[$j] = $parentsYpullAvg[$inr];
		} else {                        # es gibt keinen Zugpunkt, also keine Kinder in der fixed Generation
			$fixYpos[$j] = "flex_person_has_no_fix_partner";  # than means no children
		}
	print "Zugpunkt von ".$inr." ist ".$fixYpos[$j]."\n";
	}
}
			
sub moveFrames {
	
	my $start = shift;
	my $stop = shift;
	my $i;
	my $j;
	my $cntOfSprings;
	my $cntOfFlexPersons;
	my $fix;
	my $flex;
	my @fixArray;
	my @flexArray;
	my @newFlexYpos;
	my @tension;
	my $tens;  # single intermediate tension
	my @tensionOrder;
	my $cut;
	my $movement; # Verschiebung der Rahmen nach Feder-Matrix-Berechnung in [cm]
	my $reference_auf_results;
	my @results;
	my $inrT; # index nummer der Spannungen
        my $inr; # index nummer
	
	print "**** \n";
	print "**** Funktion moveFrames\n";
	print "**** \n";

	print "Number of Persons to be moved: ".($stop-$start+1)."\n";
	print "start ".$start." stop ".$stop."\n";

	# zaehle die Anzahl der mechanischen Federn und ermittelte die jeweiligen Y-Positionen

	$cntOfFlexPersons = $stop - $start + 1; # Anzahl der Personen mit flexibler Position

	$cntOfSprings=0;
	for $i ($start..$stop) {
		print $i." flexInr ".$flexInr[$i]." fixYpos ".$fixYpos[$i]."\n";
		if ($fixYpos[$i] ne "flex_person_has_no_fix_partner") {
			$cntOfSprings = $cntOfSprings + 1;
			$fix = $fixYpos[$i];
			$flex = $inrYpos[$flexInr[$i]] + $inrYsize[$flexInr[$i]]*0.5;
			$fixArray[$cntOfSprings] = $fix;
			$flexArray[$cntOfSprings] = $flex;
		}
	}
	print "Anzahl der Federn: ".$cntOfSprings."\n";

	# berechne Feder Matrix
	
	$reference_auf_results = &calcSpringMatrix(\@fixArray,\@flexArray,$cntOfSprings);  # \@ARRAY uebergibt Reference auf Array an die Funktion
	@results = @{$reference_auf_results};  # aus Referenz wieder ein Array erzeugen
	@newFlexYpos = @{$results[1]};
	@tension = @{$results[2]};

	$movement = $newFlexYpos[1] - $flexArray[1];  # Verschiebung des flexiblen Blocks am Beispiel des ersten Rahmes mit Feder.
	print "Movement: ".$movement."\n";

	# berechne alle neuen Y-Positionen der Rahmen
		
	for $i ($start..$stop) {
		print "veraendere Ypos von Index ".$flexInr[$i];
		print " von ".$inrYpos[$flexInr[$i]];
		$inrYpos[$flexInr[$i]] = $inrYpos[$flexInr[$i]] + $movement;
		print " auf ".$inrYpos[$flexInr[$i]]."\n";
	}

	# ordne die mechanischen Spannungen wieder allen Personen zu, auch wenn sie nicht in der Feder-Matrix-Berechnung enthalten waren

	$j=1;
	$tens=0;
	for $i ($start..$stop) {
		if ($fixYpos[$i] ne "flex_person_has_no_fix_partner") {
			$tens = $tension[$j];
			$j = $j + 1;
		}
		$inrTension[$i] = $tens;
		print "Position: ".$i." hat die Spannung: ".$tens."\n";
	}


	# ordne die mechanischen Spannung der Groesse nach

	for $j ($start..$stop) {
		print "position: ".$j." index: ".$flexInr[$j]." tension: ".$inrTension[$j]."\n";
	}
	$reference_auf_results = &findMostNegativeTension($start,$stop);
	@tensionOrder = @{$reference_auf_results}; # aus Referenz wieder ein Array erzeugen
	for $j (1..$cntOfFlexPersons) {
		print "sorted tensionOrder: ".$tensionOrder[$j]." tension: ".$inrTension[$tensionOrder[$j]+$start-1]."\n";
	}

	# suche optimale Schnittstelle mit maximaler Zugspannung

	$cut = 0;
	$j=1;
	$inrT=0;
	while ( ($cut == 0) && ($j<=$cntOfFlexPersons) ) {
		$inrT = $tensionOrder[$j]+$start-1;
		$inr = $flexInr[$inrT];
		$tens = $inrTension[$inrT];
		#print "rechte Grenze: ".$inrRLim[$inr]."\n";
		#print "Spannung ".$tens." nach Person".$inr."\n";
		if ($tens < -0.01) { # eine Schnittstelle gefunden!
			if ( ($inrRLim[$inr] eq "familyBorder") && ($stickYfam eq "no") ) { # Familiengrenze und diese nicht verklebt
				$cut = $tensionOrder[$j];
			}
			if ( ($inrRLim[$inr] eq "brotherSisterInLawBorder") && ($stickYbrosis eq "no") ) { # Schwagergrenze und diese nicht verklebt
				$cut = $tensionOrder[$j];
			}
			if ( ($inrRLim[$inr] eq "brotherSisterBorder") && ($stickYbrosis eq "no") ) { # Geschwistergrenze und diese nicht verklebt
				$cut = $tensionOrder[$j];
			}
			if ( ($inrRLim[$inr] eq "marriageBorder") && ($stickYmar eq "no") ) { # Ehegrenze und diese nicht verklebt
				$cut = $tensionOrder[$j];
			}
		}
		$j=$j+1;
	}
	if ($cut == 0) {
		print "Keine Schnittmoeglichkeit gefunden!\n";
	} else {
		print "Schnitt-Stelle an Position ".$cut." mit der Spannung ".$tens."\n";
		print "Start ".$start." Cut ".$cut." Stop ".$stop."\n";
		 &moveFrames($start,($start+$cut-1));
		 &moveFrames(($start+$cut),$stop);
	}
		
}

sub calcMarriageYpos {

	my $i;
	my $j;
	my $inrHus;
	my $inrWif;

	print " **** Function Calculate Y-position of the couples \n";

	for $i (1..$nom) {  # calculate the position of the symbol for all marriages

		# calculate position as average between the two partners

		$j = $i + $noi;
		$inrHus = $inrHusbandMarriage[$i];
		$inrWif = $inrWifeMarriage[$i];
		$marriageGen[$i] = "not_in_tree"; # Default: marriage is not in tree.
		if ( ( $inrGen[$inrHus] eq "not_in_tree") && ( $inrGen[$inrWif] eq "not_in_tree") ) {
			# print "**** In a couple, both persons ".$inrHus." and ".$inrWif." are not in the tree. \n";
			# no setting of the marriage symbol Y-position
		} else {
			if ( ( $inrGen[$inrHus] eq "not_in_tree") && ( $inrGen[$inrWif] ne "not_in_tree") ) {
				# print "**** In a couple, the husband ".$inrHus." is not in the tree. \n";
				# use the husband coordinates as marriage position
				$marriageGen[$i] = $inrGen[$inrWif];	# the marriage is defined to have the same generation as the wife
				if ( $treeOrientation eq "oy" ) { # young left, old right
					if ( ($genHasPic[$marriageGen[$i]-$genMin+1] eq "yes") && (($picPos eq "left")||($picPos eq "right")) ) { # es gibt fotos in der Generation und die Heiratssymbole muessen gerutscht werden
						$inrXpos[$j] = $genXpos[$marriageGen[$i]-$genMin+1] + $frameWidthAll + $picMaxWidth + $frameStyleLeftPadding + 0*$marriageX + $marriageXdelta;
					} else {                          # young right, old left
						$inrXpos[$j] = $genXpos[$marriageGen[$i]-$genMin+1] + $frameWidthAll + 0*$marriageX + $marriageXdelta;
					}	
					$inrYpos[$j] = $inrYpos[$inrHus] + $inrYsize[$inrHus]/2;
				} else {
					$inrXpos[$j] = $genXpos[$marriageGen[$i]-$genMin+1] - $marriageX - $marriageXdelta;
				}
			} else {
				if ( ( $inrGen[$inrHus] ne "not_in_tree") && ( $inrGen[$inrWif] eq "not_in_tree") ) {
					# print "**** In a couple, the wife ".$inrWif." is not in the tree. \n";
					# use the wife coordinates as marriage position
					$marriageGen[$i] = $inrGen[$inrHus];	# the marriage is defined to have the same generation as the husband
					if ( $treeOrientation eq "oy" ) { # young left, old right
						if ( ($genHasPic[$marriageGen[$i]-$genMin+1] eq "yes") && (($picPos eq "left")||($picPos eq "right")) ) { # es gibt fotos in der Generation und die Heiratssymbole muessen gerutscht werden
							$inrXpos[$j] = $genXpos[$marriageGen[$i]-$genMin+1] + $frameWidthAll + $picMaxWidth + $frameStyleLeftPadding + 0*$marriageX + $marriageXdelta;
						} else {                          # young right, old left
							$inrXpos[$j] = $genXpos[$marriageGen[$i]-$genMin+1] + $frameWidthAll + 0*$marriageX + $marriageXdelta;
						}	
						$inrYpos[$j] = $inrYpos[$inrHus] + $inrYsize[$inrHus]/2;
					} else {
						$inrXpos[$j] = $genXpos[$marriageGen[$i]-$genMin+1] - $marriageX - $marriageXdelta;
					}
					$inrYpos[$j] = $inrYpos[$inrWif] + $inrYsize[$inrWif]/2;
				} else {
					print "**** The couple ".$inrHus." and ".$inrWif." is in the tree. \n";
					$marriageGen[$i] = $inrGen[$inrHus];	# the marriage is defined to have the same generation as the husband
					if ( $treeOrientation eq "oy" ) { # young left, old right
						if ( ($genHasPic[$marriageGen[$i]-$genMin+1] eq "yes") && (($picPos eq "left")||($picPos eq "right")) ) { # es gibt fotos in der Generation und die Heiratssymbole muessen gerutscht werden
							$inrXpos[$j] = $genXpos[$marriageGen[$i]-$genMin+1] + $frameWidthAll + $picMaxWidth + $frameStyleLeftPadding + 0*$marriageX + $marriageXdelta;
						} else {                          # young right, old left
							$inrXpos[$j] = $genXpos[$marriageGen[$i]-$genMin+1] + $frameWidthAll + 0*$marriageX + $marriageXdelta;
						}	
						$inrYpos[$j] = $inrYpos[$inrHus] + $inrYsize[$inrHus]/2;
					} else {
						$inrXpos[$j] = $genXpos[$marriageGen[$i]-$genMin+1] - $marriageX - $marriageXdelta;
					}
					# average calculation
					if ( $inrYpos[$inrHus] < $inrYpos[$inrWif] ) { # Husband is left
						#$inrYpos[$j] = ($inrYpos[$inrHus] + $inrYpos[$inrWif] + $inrYsize[$inrWif] - 0*$marriageY)/2;
						$inrYpos[$j] = ($inrYpos[$inrHus] + 0.5*$inrYsize[$inrHus] + $inrYpos[$inrWif] + 0.5*$inrYsize[$inrWif] - 0*$marriageY)/2;
					} else { # Wife is left
						#$inrYpos[$j] = ($inrYpos[$inrWif] + $inrYpos[$inrHus] + $inrYsize[$inrHus] - 0*$marriageY)/2;
						$inrYpos[$j] = ($inrYpos[$inrWif] + 0.5*$inrYsize[$inrWif] + $inrYpos[$inrHus] + 0.5*$inrYsize[$inrHus] - 0*$marriageY)/2;
					}
					#if ($i == 1) {
					#	print "Example for Ypos Marriage Averaging:\n";
					#	print $i," ",$j." \n";
					#	print $inrHus," ",$inrWif,"\n";
					#	print $inrYpos[$inrHus]," ",$inrYpos[$inrWif],"\n";
					#	print $inrYsize[$inrHus]," ",$inrYsize[$inrWif],"\n";
					#	print $marriageY,"\n";
					#	print $inrYpos[$j],"\n";
					#}
				}
			}
		}	
	}
}

sub checkHusWifSameGen {

	my $i;
	my $inrHus;
	my $inrWif;

	# checking if husband and wife are in the same generation


	print "**** \n";
	print "**** BEGINN: Ueberpruefung, ob Ehefrau und Ehemann\n";
	print "****         in der gleichen Generation sind.\n";
	print "**** \n";
	for $i (1..$nom) {
		$inrHus = $inrHusbandMarriage[$i];   # Husband index number of n'th marriage
		$inrWif = $inrWifeMarriage[$i];   # Husband index number of n'th marriage
		if ( ($inrGen[$inrHus] != $inrGen[$inrWif]) && ($inrPlacement[$inrHus]>0) && ($inrPlacement[$inrWif]>0) ) { # not in same generation, but placed
			#print "**** WARNING: Not same generation of ".$inrHus." and ".$inrWif."\n";
			#print "**** WARNING: Use evtl. the \"looseCon\"-attribute in file tree_form.txt to optimize loop cut.\n";
			print "**** WARNUNG: Nicht in der gleichen Generation platziert: ".$inrHus." und ".$inrWif."\n";
			#print "**** WARNUNG: Use evtl. the \"looseCon\"-attribute in file tree_form.txt to optimize loop cut.\n";
		}
	}
	print "**** \n";
	print "**** ENDE:  Ueberpruefung, ob Ehefrau und Ehemann\n";
	print "****        in der gleichen Generation sind.\n";
	print "**** \n";
	print "**** Wenn keine WARNUNGEN fuer Ehemaenner und -frauen zwischen\n";
	print "**** BEGINN und ENDE aufgelistet sind, dann ist alles ok.\n";
	print "**** Ansonsten den Baum ansehen und ggf. die Benutzung\n";
	print "**** von looseCon in der Datei tree_form.txt pruefen.\n";
	print "**** \n";
}

sub printPersonList {

	my $fnDataPersonList = shift;
	my $fnPersonsInTree = shift;
	my $fnPersonsInTreeNr = shift;
	my @name_line; # Array mit der Namensliste
	my $line;
	my $i;
	my $j;

	open(IN, "<$fnDataPersonList") || die "Can't open file $fnDataPersonList ($!)\n";	
	$line = <IN>;  #erste Zeile weglesen mit Ueberschrift
	while(<IN>) {
		$line = $_;
		print $line;
		if ( $line =~ m/([0-9]+) (.*)  AD ([0-9]{2})\.([0-9]{2})\.([0-9]{4})/ ) { # suche Index-Nummer, Namen + Aenderungsdatum
			$i=$1;
			$name_line[$i] = $line;
		} else {
			print "FEHLER: Zeile ohne Nummer und Name und Datum in ".$fnDataPersonList."\n";
			print $line;
			exit;
		}
	}
	close(IN);

	open(OUT1, ">$fnPersonsInTree") || die "Can't open file $fnPersonsInTree ($!)\n";
	open(OUT2, ">$fnPersonsInTreeNr") || die "Can't open file $fnPersonsInTree ($!)\n";

	print "\n";
	print "Personen im Stammbaum \n";
	print OUT1 "Personen im Stammbaum \n";
	print "--------------------- \n";
	print OUT1 "--------------------- \n";
	print "\n";
	print OUT1 "\n";
	$j=0;
	for $i (1..$noi) {
		if ($inrPlacement[$i]>0.5) {
			$j = $j + 1;
			print $i." ";
			print  OUT1 $name_line[$i]; # Liste mit Index, Name und Aenderungsdatum
			#print OUT1 $i." ";
			print OUT2 $i.",";          # Liste nur mit Indexnummern
			#print $personData[$i][1];
			#print OUT1 $personData[$i][1];
			#print $personData[$i][2];
			#print OUT1 $personData[$i][2];
			#print $personData[$i][3]." ";
			#print OUT1 $personData[$i][3]." ";
			#if ( $personData[$i][4] =~ m/(.*) (#[0-9]+)/ ) {
			#	print $1;
			#	print OUT1 $1;
			#} else {
			#	print $personData[$i][4];
			#	print OUT1 $personData[$i][4];
			#}
			#print "\n";
			#print OUT1 "\n";
		}
	}
	print "\n";
	print OUT1 "\n";
	print "Anzahl der Personen im Baum: ".$j."\n";
	print OUT1 "Anzahl der Personen im Baum: ".$j."\n";
	print "\n";
	print OUT1 "\n";
	print OUT2 "\n\n";

	close(OUT1);
	close(OUT2);
}

sub constructTreeUnzipOdg {
        if ( $^O eq "MSWin32") {  # Window Operating System
                print "Window Operating System 1\n";
		system("\%\$scriptDir\%construct_tree_unzip_odg.bat");
        } else {
                print "Linux Cygwin or MAC Operating System 1\n";
		system("\$scriptDir\/construct_tree_unzip_odg.sh");
        }

}

sub constructTreeZipOdg {
        if ( $^O eq "MSWin32") {  # Window Operating System
                print "Window Operating System 2\n";
		system("\%\$scriptDir\%construct_tree_zip_odg.bat");
        } else {
                print "Linux Cygwin or MAC Operating System 2\n";
		system("\$scriptDir\/construct_tree_zip_odg.sh");
        }
}

sub constructTreeCleanUp {

        if ( $^O eq "MSWin32") {  # Window Operating System
                print "Window Operating System 3\n";
		system("\%\$scriptDir\%construct_tree_clean_up.bat");
        } else {
                print "Linux Cygwin or MAC Operating System 3\n";
		system("\$scriptDir\/construct_tree_clean_up.sh");
        }

	my $i;
	my $gen;
	print  "\n";
	print  "**********************************\n";
	print  "* Printing Y-Position Informations";
	print  "\n";
	for $i (1..$nog) {	# print the next free y-Position for each generation
		$gen = $i + $genMin -1;
		print "Generation: ".$gen."; max. Y-Position: ".$genYpos[$i]."\n";
	}
	print  "longest Generation: ".$maxYposGen."; largest max. Y-Position: ".$maxYpos."\n";
	print  "\n";
	print  "**********************************\n";
	print  "\n";

}


sub utf8_to_WinLin {

	# Replacing the UTF8 Characters by DOS characters for system DOS commands

	my $text = shift;

	$text =~ s/ä//g;
	$text =~ s/ö//g;
	$text =~ s/ü//g;
	$text =~ s/ß//g;

	$text =~ s/Ä//g;
	$text =~ s/Ö//g;
	$text =~ s/Ü//g;

	return $text;
		
}	

sub utf8_to_aeoeuess {

	# Replacing the UTF8 Characters by DOS characters for system DOS commands

	my $text = shift;

	$text =~ s/ä/ae/g;
	$text =~ s/ö/oe/g;
	$text =~ s/ü/ue/g;
	$text =~ s/ß/ss/g;

	$text =~ s/Ä/Ae/g;
	$text =~ s/Ö/Oe/g;
	$text =~ s/Ü/Ue/g;

	return $text;
		
}	
