######################################################################################
# Author        : Ruediger Arnold
# Date          : 23.09.2013
# Description   : Check if the Resolution in the file data_file_pictures.txt are valid
# Category      : Parser
######################################################################################
#               : 
#               : initial
#               :
######################################################################################

use strict;


###################################
# main routine
###################################

if ($#ARGV == 0) {
	&checkPicResolution(@ARGV[0]);
#	&generateContent(@ARGV[0]);
	exit;
	}	
else {
	print "*****************************\n";
	print "usage: $0 <data_file_pictures> \n";
	print "*****************************\n";
	exit;
}		

###################################
# subroutines
###################################
sub checkPicResolution {
	my $filename = shift;
	my $line;
	my $resxy;
	my $inr;
	my $pic_path;
	my $pic_name;
	my $i=0;

	## open symbol definition file
	#print "***** Open Person Data File \n";
	open(IN, "<$filename") || die "Can't open file $filename ($!)\n";

	$line = <IN>; # Header weglesen
	$i = $i +1;

	while(<IN>) {			
		$line= $_;
		$i = $i +1;
		if ( $line =~ m/(.*) Index/ ) {
			$inr = $1;
			$line = <IN>; # Datenpfad
			$i = $i +1;
			if ( $line =~ m/(.*)\\(.*)/ ) { # MOS Pfad
				$pic_path = $1;
				$pic_name = $2;
			} else {
				if ( $line =~ m/(.*)\/(.*)/ ) { # MOS Pfad
					$pic_path = $1;
					$pic_name = $2;
				} else {
					print "*** WARNUNG:  Falsches Format in der Datei data_file_pictures.txt\n";
					print "*** in Zeile: ".$i."\n";
				}
			}	
			$line = <IN>; # Size
			#print "Size: ".$line."\n";
			$i = $i +1;
			$line = <IN>; # Cutting
			#print "Cut: ".$line."\n";
			$i = $i +1;
			$line = <IN>; # Resolution
			$i = $i +1;
			if ( $line =~ m/(.*) xres yres/ ) {
				$resxy = $1;
				#print "resxy ".$resxy."\n";
			} else {
					print "*** WARNUNG:  Falsches Format in der Datei data_file_pictures.txt\n";
					print "*** in Zeile: ".$i."\n";
			}
			if (($pic_name =~ m/(.*)\.jpg/) || ($pic_name =~ m/(.*)\.JPG/) || ($pic_name =~/(.*)\.jpeg/) ) { 
				if (($resxy eq "") || ($resxy eq " ") || ($resxy eq "  ")) {
					print "*** WARNUNG KEINE AUFLOESUNG in Datei data_file_pictures.txt\n";
					print "*** Person: ".$inr."\n";
					print "*** Zeile: ".$i."\n";
					print "*** Bild:   ".$pic_name."\n";
					print "*** Path:   ".$pic_path."\n";
				}
				if ($resxy eq "0 0") {
					print "*** WARNUNG AUFLOESUNG = 0 in Datei data_file_pictures.txt\n";
					print "*** Person: ".$inr."\n";
					print "*** Zeile: ".$i."\n";
					print "*** Bild:   ".$pic_name."\n";
					print "*** Path:   ".$pic_path."\n";
				}
				if ($resxy eq "1 1") {
					print "*** WARNUNG AUFLOESUNG = 1 in Datei data_file_pictures.txt\n";
					print "*** Person: ".$inr."\n";
					print "*** Zeile: ".$i."\n";
					print "*** Bild:   ".$pic_name."\n";
					print "*** Path:   ".$pic_path."\n";
				}
			}
		} else {
			print "*** WARNUNG:  Falsches Format in der Datei data_file_pictures.txt\n";
			print "*** in Zeile: ".$i."\n";
		}
	}

}
